
<TABLE class="table table-condensed">
    <tr>
        <td><strong>Num Contrato</strong>:{{$contrato->numcontrato}}</td>
        <td><strong>Fecha: </strong>:{{$contrato->fechacontrato->format('d/m/Y')}}</td>
        <td colspan="2"><strong>Cliente: </strong>:{{$contrato->nombre_completo}}</td>
    </tr>
    <tr>
        <td><strong>Precio Venta</strong>: {{$contrato->preciototal}}</td>
        <td><strong>Cuota Inicial</strong>: {{$contrato->credito->cuotainicial}}</td>
        <td><strong>Cuota Inicial</strong>: {{$contrato->credito->saldo}}</td>
        <td><strong>Num Pagos</strong>: {{$contrato->credito->numpagos}}</td>

    </tr>
    <tr>
        <td colspan="2"><strong>Vendedor</strong>: {{$contrato->vendedor->nombre_completo}}</td>
        <td colspan="2"><strong>Chofer</strong>: {{$contrato->chofer->nombre_completo}}</td>

    </tr>
</TABLE>
<form method="post" action="{{url('diferidos/devolucion/store')}}" class="form">
    {!! csrf_field() !!}

    <input type="hidden" name="contrato_id" value="{{$contrato->id}}">
    <div class="row form-group">
        <div class="col-md-3">
            <label for="">Fecha </label>
        <input type="text" readonly name="fecha" value="{{date('d/m/Y')}}" class="fecha datepicker form-control">
        </div>
        <div class="col-md-4">
            <label for="">Tipo devolucion</label>
            <select name="tipo" id="" class="tipo form-control">
                <option value="TOTAL">DEVO. TOTAL</option>
                <option value="PARCIAL">DEVO. PARCIAL</option>
            </select>
        </div>
        <div class="col-md-5">
            <label for="">Observaciones</label>
            <textarea name="obs" id="" cols="30" rows="2" class="form-control"></textarea>
        </div>
    </div>
    {{-- <div class="row form-group">
        <div class=" col-md-offset-3 col-md-4 div-fecha_remision"  style="display: none">
            <label for="">Fecha de  Remision </label>
            <input type="text" readonly name="fecha_remision" class="fecha_remision datepicker form-control">
        </div>

    </div> --}}
    <table class="table table-condensed table-detalle-devo">
        <thead>
        <tr>
            <td width="12%">Codigo</td>
            <td class="col-md-6">Titulo</td>
            <td class="col-md-1">CANT</td>
            <td class="col-md-1">P.U.</td>
            <td class="col-md-1">P.T.</td>
            <td class="col-md-1"><i class="icon md-check"></i></td>
        </tr>
        <tbody>
        @foreach($contrato->detalle as $d)
            <tr>
                <td>{{$d->codigo}}</td>
                <td>{{$d->titulo}}</td>
                <td align="center" >{{$d->cantidad}}</td>
                <td>{{$d->precio_unitario}}</td>
                <td>{{$d->precio_total}}</td>
                <td >
                    <input class="cb" type="checkbox" value="{{$d->libros_id}}" name="cb[]">
                    <input  type="hidden" value="{{$d->cantidad}}" name="cantidad[]">
                    <input type="hidden" value="{{$d->libros_id}}" name="libros_id[]">
                    <input type="hidden" value="{{$d->codigo}}" name="codigo[]">
                    <input type="hidden" value="{{$d->titulo}}" name="titulo[]">
                    <input type="hidden" value="{{$d->precio_unitario}}" name="precio_unitario[]">
                    <input type="hidden" value="{{$d->precio_total}}" name="precio_total[]">

                </td>
            </tr>
        @endforeach
        </tbody>
        </thead>
    </table>
    <button class="btn btn-devolver btn-block btn-outline-primary"><i class="icon md-wrench  "></i> REGISTRAR LA DEVOLUCION</button>

</form>

<script>
          var sending=false
    function sendForm(){
        if(sending==false){
        $('form').submit();
        sending=true  
        }
    }

    $('.tipo').change(function(){
        if($(this).val()=='TOTAL') {
            $('.table-detalle-devo tbody').find('.cb').prop('checked', 1)
            $('.div-fecha_remision').hide();
            $('.fecha_remision').val('');
        }
        else{
             $('.div-fecha_remision').show();
            $('.fecha_remision').focus();

        }
    })
    $('.datepicker').datepicker({
        language: 'es',
        autoclose:true,
        format:'dd/mm/yyyy',
        showOn: "button",
        zIndexOffset:10000,
        buttonText: '<i class="fa fa-calendar"></i>',
    });
    function validarTotal(){
        let sw=true;
        if($('.tipo').val()=='TOTAL'){
            $('.table-detalle-devo tbody').each(function(k,v){
                if(!$(v).find('.cb').prop('checked')){
                    sw=false;
                }
            })
        }
        else{
            sw=true
        }
        return sw;
    }
    function validarMarcado(){
        let sw=false;
       let count = $('.table-detalle-devo input:checkbox:checked').length

       return count
    }

    $('.btn-devolver').click(function(_evt){
        _evt.preventDefault()

        if(!validarTotal()){
            swal('Alerta','Debe seleccionar todos los items','warning')
            return false;
        }
        if(validarMarcado()<=0){
            swal('Alerta','Debe seleccionar al menos un item','warning')
            return false;
        }

        if($('.fecha').val()==''){
            swal('Alerta','Ingrese una fecha para la devolucion','warning')
            return false;
        }
        // if($('.tipo').val()=='PARCIAL'){
        //     if($('.fecha_remision').val()==''){
        //         swal('Alerta','Ingrese una fecha para la nota de remision ','warning')
        //         $('.fecha_remision').focus();
        //         return false;
        //     }
        // }

 _fecha=$('.fecha').val()
         
         $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha,modulo:'VENTAS'},
             dataType:'json',
             method:'GET',
             async:false,
          

         }).done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                        return false;
                        
                    }      
                    else{

        swal({
                title: "Registrar Devolucion",
                text: "Se procedera a la devolucion "+$('.tipo').val()+" del contrato. Esta Seguro?",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-success",
                confirmButtonText: "Si, Procesar!",
                cancelButtonText:"Cancelar",
                closeOnConfirm: false
            },
            function(){
                sendForm()
            });
                     }
         }).fail(function(){
             alert('exisitio un error')
         })

    })
</script>