@extends('layouts.admin')
@section('title') @if(isset($contrato)) Editar contrato @else  Cear contrato @endif @stop
@section('titulo') @if(isset($contrato)) EDITAR CONTRATO @else  REGISTRAR CONTRATO @endif   @stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('diferidos')}}">Contratos Diferido</a></li>
        <li class="breadcrumb-item active">
            @if(isset($contrato)) Editar contrato @else  Registrar Contrato @endif
        </li>

    </ol>
@stop
@section('content')
    <div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true"
         aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">

                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>


    <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('diferidos/store')}}" class="form col-lg-10">
        {!! csrf_field() !!}
        @if($edit)
            <input type="hidden" name="contrato_id" value="{{$contrato->id}}">
        @endif
        <div class="row form-group" >
            <div class="col-md-2">
                <label for=""><strong>NUMERO  CONTRATO</strong></label>
                <input type="text" READONLY   value="{{$numcontrato}}" name="numcontrato" class="form-control form-control-sm ">
            </div>
            <div class="col-md-2">
                <label for=""><strong>FECHA CONTRATO</strong></label>
                <input type="text"  readonly name="fecha" value="{{$fecha->format('d/m/Y')}}" class="datepicker2 form-control form-control-sm">
            </div>
            <div class="col-md-2">
                <label for=""><strong>CARNET CLIENTE</strong></label>
                <input type="text" readonly name="carnet" value="{{$carnet}}" class="form-control form-control-sm">
            </div>
            <div class="col-md-3">
                <label for=""><strong>VENDEDOR</strong></label>
                <input type="text" READONLY  value="{{$vendedor->nombre_completo}}" name="vendedor" class="form-control form-control-sm ">
                <input type="hidden"  value="{{$vendedor->id}}" name="vendedor_id" >
            </div>
            <div class="col-md-3">
                <label for=""><strong>CHOFER</strong></label>
                <input type="text" READONLY  value="{{$chofer->nombre_completo}}" name="chofer" class="form-control form-control-sm ">
                <input type="hidden"  value="{{$chofer->id}}" name="chofer_id" >
            </div>
        </div>
        <hr>

        @if(isset($procesado) && !$procesado)
        <div class="form-row" >
            <div class=" form-group col-md-6 col-sm-12">
                <label class="form-control-label "><strong>CODIGO</strong></label>
                <select  id="select3" name="libro_id" class="form-control form-control-sm select3"  >
                    <option value="">Seleccione</option>
                    @foreach($libros as $l)
                        <option  stock="{{$l['cantidad']}}" codigo="{{$l['codigo']}}" pu="{{$l['precio_base']}}" titulo="{{$l['titulo']}}" tomo="{{$l['tomo']}}" value="{{$l['id']}}"><strong> {{$l['codigo']}} - </strong>{{$l['titulo']}} [{{$l['cantidad']}}] </option>
                    @endforeach
                </select>
            </div>
            <div class=" form-group col-md-1 col-sm-3 col-xs-3">
                <label   class="form-control-label" for=""><strong>REMITIDO</strong></label>
                <input  readonly type="text"  class="stock limpiar  form-control form-control-sm">
            </div>

            <div class=" form-group col-md-1 col-sm-2 col-xs-2">
                <label   class="form-control-label" for=""><strong>CANTIDAD</strong></label>
                <input type="text"  id="cantidad" class="cantidad limpiar  solo-enteros form-control form-control-sm">
            </div>
            <div class=" form-group col-md-1 col-sm-2 col-xs-2">
                <label   class="form-control-label" for=""><strong>PRECIO.UNIT</strong></label>
                <input type="text"   size="15%" id="pu" class="pu limpiar numeroscondecimales  form-control form-control-sm">
            </div>
            <div class=" form-group col-md-1 col-sm-1">
                <label class="form-control-label" for="">&nbsp;</label>
                <button  type="button" class=" btn-add btn    btn-outline-success "><i class="icon md-plus"></i> Adicionar</button>
            </div>

        </div>
        @endif
        <hr>
        
        <div class="visible col-md-11"  @if(!$edit) style="display: none" @endif>
            <table class="table table-detalle">
                <thead>
                <tr>
                    <th>No</th>
                    <th>CODIGO</th>
                    <th>TITULO</th>
                    <th>TOMO</th>
                    <th>CANT</th>
                    <th class="col-md-2">P.UNIT</th>
                    <th>P.TOTAL</th>
                    <th>Acciones</th>
                </tr>
                </thead>

                <tbody>
                @if($edit)

                    @foreach($contrato->detalle as $k=>$d)
                        <tr>
                         <td>{{$k+1}}</td>
                         <td class="" width="10%"><strong class="td-codigo" >{{$d->codigo}}</strong></td>
                         <td class="col-md-8">{{$d->titulo}}</td>
                         <td>{{$d->volumen}}</td>
                         <td class=" text-left"><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="{{$d->cantidad}}"></td>
                         <td class=" text-left   "><input type="text" class="td-pu numeroscondecimales" name="pu[]"  size="8%" value="{{$d->precio_unitario}}"></td>
                         <td><input type="text" readonly size="10%"  class="td-pt" value="{{$d->precio_total}}" name="pt[]"/><input type="hidden" name="libro_id[]" value="{{$d->libros_id}}"></td>
                         <td>
                               @if(isset($procesado) && !$procesado && $edit)
                             <button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button>
                            @endif
                            </td>
                            </tr>
                    @endforeach

                @endif

                </tbody>
                <tfoot>
                <tr>
                    <th></th>
                    <th></th>
                    <td></td>
                    <td></td>

                    <td><input  @if($edit) value="{{$contrato->detalle->sum('cantidad')}}" @endif  type="text" name="cant_total"  size="5%" class="cant_total form-control" readonly></td>
                    <th  align="right" class="text-right" style=" font-size:1.1em;font-weight: bolder;color:#2c2c2c">P.VENTA</th>

                    <td><input  style="color: #2c2c2c; font-weight: bolder; font-size: 1.1em" @if($edit) value="{{$contrato->preciototal}}" @endif  type="text" name="precio_total"  size="10%" class="precio_total form-control" readonly></td>
                </tr>
                </tfoot>
            </table>
            <HR>
            <div class=" row form-group radio-inline ">

                <div class="col-md-2">
                    <label><strong>CREDITO</strong></label>
                    <input type="radio" @if($edit && $contrato->tipoventa=='credito')   checked @endif name="tipo" value="credito" class="rb-credito" >
                </div>
                <div class="col-md-offset-6 ">
                    <label><strong>CONTADO</strong></label>
                    <input type="radio" name="tipo"  value="contado"  @if($edit && $contrato->tipoventa=='contado')  checked @endif       class="rb-contado">
                </div>
            </div>


            <div class="row form-group ">
                <div class="col-md-3">
                <label for=""  class="control-label-sm"><strong><span class="text-danger">*</span>LOCALIDAD</strong></label>
                <input type="text" name="localidad"  @if(isset($credito)) value="{{$contrato->localidad}}" @endif class="required form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for=""  class="control-label-sm"><strong><span class="text-danger">*</span>NOMBRES</strong></label>
                    <input type="text" name="nombres" @if(isset($credito)) value="{{$contrato->nombres}}" @endif  class="required form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for=""  class="control-label-sm"><strong><span class="text-danger">*</span>APELLIDO PATERNO</strong></label>
                    <input type="text" name="paterno"  @if(isset($credito)) value="{{$contrato->apellidopaterno}}" @endif class=" form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label for=""  class="control-label-sm"><strong>APELLIDO MATERNO</strong></label>
                    <input type="text" name="materno" @if(isset($credito)) value="{{$contrato->apellidomaterno}}" @endif  class=" form-control form-control-sm">
                </div>

            </div>

            <div class="div-credito"  @if($edit && $contrato->tipoventa=='credito') style="display: block" @else style="display: none" @endif>
                <div class="row form-group ">

                    <div class="col-md-2">
                        <label for="" class="control-label-sm"><strong>CUOTA INICIAL</strong></label>
                        <input type="text" required name="cuota_ini" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->cuotainicial}}" @endif class="required-credito cuota_ini form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>SALDO CONTRATO</strong></label>
                        <input type="text"  readonly  required name="saldo"  @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->saldo}}" @endif class="required-credito  saldo form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>MONTO COMISIONABLE</strong></label>
                        <input type="text" name="comisionable_credito" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->valorcomisionable}}" @endif class="required-credito comisionable_credito form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm">
                            @if($vendedor->tipocomisioncredito=='P')
                                <strong>PORCENT. COMISION %</strong>
                            @else
                                <strong>MONTO COMISION</strong>

                            @endif

                        </label>
                        <input type="text" name="valorcomisioncredito"  @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->porcentajecomision}}" @else value="{{$vendedor->valorcomisioncredito}}"  @endif  class="required-credito valorcomisioncredito form-control form-control-sm numeroscondecimales">
                        <input type="hidden" name="tipocomisioncredito"   value="{{$vendedor->tipocomisioncredito}}" class="required-credito  tipo-comision-credito form-control form-control-sm numeroscondecimales">
                    </div>
                    @if($vendedor->tipocomisioncredito=='P')
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm" class="control-labeL"><strong> MONTO COMISION</strong></label>
                        <input type="text" name=""  readonly  class="montocomisioncredito form-control form-control-sm" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->montocomision}}" @endif >
                    </div>
                    @endif
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm" class="control-labeL"  style="font-size:8px"><strong><span class="text-danger">*</span>MONTO A  CUENTA DE COMISION</strong></label>
                        <input type="text" name="cuenta_comision" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->cuentacomision}}" @endif class="required-credito form-control form-control-sm numeroscondecimales">
                    </div>
                    <input type="hidden" name="tipocomisioncredito" value="{{$vendedor->tipocomisioncredito}}">
                    </div>
                    <div class=" row">

                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>FECHA COBRO CI</strong></label>
                        <input type="text" required readonly name="fecha_cobro" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->fechacobranza->format('d/m/Y')}}" @endif class="required-credito datepicker form-control form-control-sm">
                    </div>

                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>NUM DE PAGOS</strong></label>
                        <input type="text" name="num_pagos" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->numcuotas}}" @endif class="required-credito num_pagos form-control form-control-sm solo-enteros">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>MONTO X PAGO</strong></label>
                        <input type="text" required readonly name="monto_pago" @if(isset($contrato)  && $contrato->tipoventa=='credito')  value="{{$credito->montocuotas}}" @endif class="required-credito monto_pago form-control form-control-sm numeroscondecimales">
                    </div>

                    <div class="col-md-4">
                        <label for=""  class="control-label-sm"><strong>COBRADOR</strong></label>
                        <select name="cobrador_id" id="" class="required-credito  form-control" id="cobrador">

                            @foreach($cobradores as $c)
                                <option @if(isset($credito) && $credito->cobrador_id==$c->id) selected @endif  value="{{$c->id}}">{{$c->nombre_completo}}</option>
                            @endforeach
                        </select>
                    </div>


                </div>

            </div>
            <div class="div-contado"  @if(isset($contrato) && $contrato->tipoventa=='contado')) style="display: block" @else style="display: none" @endif >
                <div class="row form-group ">

                    <div class="col-md-2">
                        <label for="" class="control-label-sm"><strong>PRECIO DE VENTA</strong></label>
                        <input type="text" @if(isset($contrato)  && $contrato->tipoventa=='contado') value="{{$credito->cuotainicial}}" @endif name="cancelado_contado" class="required-contado  monto-cancelado form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>SALDO</strong></label>
                        <input type="text"  readonly @if(isset($contrato)  && $contrato->tipoventa=='contado') value="{{$credito->saldo}}" @endif  name="saldo_contado" class="required-contado saldo-contado form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>M.COMISIONABLE</strong></label>
                        <input type="text" @if(isset($contrato)  && $contrato->tipoventa=='contado') value="{{$credito->valorcomisionable}}" @endif name="comisionable_contado" class="required-contado comisionable_contado form-control form-control-sm numeroscondecimales">
                    </div>
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm">
                            @if($vendedor->tipocomisioncontado=='P')
                                <strong>PORCENT. COMISION %</strong>
                            @else
                                <strong>MONTO. COMISION </strong>
                            @endif
                        </label>
                        <input type="text" name="valorcomisioncontado"    @if(isset($contrato)  && $contrato->tipoventa=='contado')  value="{{$credito->porcentajecomision}}" @else value="{{$vendedor->valorcomisioncontado}}"  @endif class="required-contado valorcomisioncontado form-control form-control-sm numeroscondecimales">
                        <input type="hidden" name="tipocomisioncontado"   value="{{$vendedor->tipocomisioncontado}}" class="form-control tipocomisioncontado form-control-sm numeroscondecimales">
                    </div>
                    @if($vendedor->tipocomisioncontado=='P')
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong>MONTO COMISION</strong></label>
                        <input type="text" @if(isset($contrato)  && $contrato->tipoventa=='contado') value="{{$credito->montocomision}}" @endif name="montocomision_contado" class="required-contado  montocomisioncontado form-control form-control-sm numeroscondecimales">
                    </div>
                    @endif
                    <div class="col-md-2">
                        <label for=""  class="control-label-sm"><strong> A CUENTA COMISION</strong></label>
                        <input type="text" @if(isset($contrato)  && $contrato->tipoventa=='contado') value="{{$credito->cuentacomision}}" @endif name="cuentacomision_contado" class="required-contado form-control form-control-sm numeroscondecimales">
                    </div>

                </div>
            </div>
            <div class="form-group form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('notas-remision')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
        </div>
    </form>

@section('scripts')

    <script>
        var codigos=[]
        function buscarCodigo(codigo){
            var sw=false;
            if(codigos.indexOf(codigo)!=-1)
                sw=true;
            return sw;
        }
        function numerosTabla(){
            var cant=0;
            var pu=0;
            var t=0;
            $('.table-detalle tbody tr').each(function(k,v){

                $(v).find('td:first').html(k+1)
                cant+=parseInt($(v).find('.td-cant').val())
                pu+=parseFloat($(v).find('.td-pu').val())
                t+=parseInt($(v).find('.td-cant').val())*parseFloat($(v).find('.td-pu').val())


            });

            return {
                cant:cant,
                pu:t.toFixed(2)
            }
        }
        function limpiar(){
            $('.limpiar').val('')
            $('#select3').val('').trigger('change');
            $('#select3').focus()



        }
        function addFila(datos){
            var fila='<tr>';
            fila+='<td></td>'+
                '<td class="" width="10%"><strong class="td-codigo" ">'+datos.codigo+'</strong></td>'+
                '<td class="col-md-8">'+datos.titulo+'</td>'+
                '<td>'+datos.tomo+'</td>'+
                '<td class=" text-left    "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="'+datos.cantidad+'"></td>'+
                '<td class=" text-left   "><input type="text" class="td-pu numeroscondecimales" name="pu[]"  size="8%" value="'+datos.pu+'"></td>'+
                '<td><input type="text" readonly size="10%"  class="td-pt" value="'+datos.pt+'" name="pt[]"/><input type="hidden" name="libro_id[]" value="'+datos.id+'"></td>'+
                '<td><button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button></td>'+
                '</tr>';



            $('.table-detalle tbody').append(fila)
            codigos.push(datos.codigo)

            var _credito=(parseInt($('.credito').val())-parseInt(datos.cantidad));
            $('.credito').val(_credito)
            limpiar();
            $('.visible').show()
            var totales=numerosTabla()
            $('.cant_total').val(totales.cant)
            $('.precio_total').val(totales.pu)
// console.log(datos)
        }
        function remove(btn)
        {
            // alert('')
            limpiar();
            let codigo=$(btn).closest('tr').find('.td-codigo').html()
            let cant=$(btn).closest('tr').find('.td-cant').val()
            $(btn).closest('tr').remove()
            _cantfilas=$('.table-detalle tbody tr').length;
            if(_cantfilas<=0){
                $('.visible').hide();
            }

            var totales=numerosTabla()
            $('.cant_total').val(totales.cant)
            $('.precio_total').val(totales.pu)
            borrarArray(codigo)

        }
        function borrarArray(valor){
            var index = codigos.indexOf(valor);
            if (index > -1) {
                codigos.splice(index, 1);
                return true;
            }
            return false;

        }
        function calcularComision(){
            let tipo=$('.tipo-comision-credito').val();
            let monto_comisionable=$('.comisionable_credito').val();
            let porcentaje_comision=$('.valorcomisioncredito').val();
            let comision=0;

            if(tipo=='P' && porcentaje_comision!='' && parseFloat(porcentaje_comision)>0){
                comision=(parseFloat(porcentaje_comision)/100)*parseFloat(monto_comisionable)

            }
            $('.montocomisioncredito').val(comision.toFixed(2))
        }
        function calcularComisionContado(){
            let tipo=$('.tipocomisioncontado').val();
            let monto_comisionable=$('.comisionable_contado').val();
            let porcentaje_comision=$('.valorcomisioncontado').val();
            let comision=0;

            if(tipo=='P' && porcentaje_comision!='' && parseFloat(porcentaje_comision)>0){
                comision=(parseFloat(porcentaje_comision)/100)*parseFloat(monto_comisionable)

            }
            $('.montocomisioncontado').val(comision.toFixed(2))
        }
        function enviarFormulario(){

            swal({
                    title: "Guardar Contrato",
                    text: "Revise que todos los campos esten llenados correctamente.",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Si, Guardar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function () {
                    $('.btn-guardar').addClass('disabled')
                    $('.form').submit();
                })

        }


        function validarCliente(){
             var sw=true;
             var campos=[]
            $('.required').each(function(k,v){
                if($(v).val()=='') {
                 sw=false;

                 let label=$(v).siblings('label').children('strong').html()
                 campos.push(label)
                }
            })

            return sw
        }

        function validarCredito(){
            var sw=true;
            var campos=[]
            $('.required-credito').each(function(k,v){
                if($(v).val()=='') {
                    sw=false;

                    let label=$(v).siblings('label').children('strong').html()
                    campos.push(label)
                }
            })

            return sw
        }
        function validarContado(){
            var sw=true;
            var campos=[]
            $('.required-contado').each(function(k,v){
                if($(v).val()=='') {
                    sw=false;
                    let label=$(v).siblings('label').children('strong').html()
                    campos.push(label)
                }
            })

            return sw
        }


        $(document).ready(function(){

            $('.cuota_ini').on('change',function(){
                let total=parseFloat($('.precio_total').val())

                if(parseFloat($(this).val())>total){
                    let saldo='';
                    $(this).val('')
                    swal('Alerta','La cuota inicial no puede ser mayor al monto total del contrato','warning')

                    $('.saldo').val('')

                }
                else {

                    let saldo = total - parseFloat($(this).val())
                $('.saldo').val(saldo.toFixed(2))
                }


            })


            $('.monto-cancelado').on('change',function(){
                let total=parseFloat($('.precio_total').val())

                if(parseFloat($(this).val())>total){
                    let saldo='';
                    $(this).val('')
                    swal('Alerta','el monto cancelado  no puede ser mayor al monto total del contrato','warning')


                $('.saldo-contado').val('')
                }
                else {

                    let saldo = total - parseFloat($(this).val())
                $('.saldo-contado').val(saldo.toFixed(2))
                }


            })

            $('.num_pagos').on('change',function(){
                let saldo=parseFloat($('.saldo').val())
                // alert(saldo)
                if($('.saldo').val()!='' || saldo>0) {
                    let num_pagos = saldo / parseFloat($(this).val())
                    $('.monto_pago').val(num_pagos.toFixed(2))
                }
                else{
                    $(this).val('')
                }

            })

            $("#pu").keypress(function (e) {
                if(e.which == 13) {
                    $(".btn-add").trigger("click");
                }
            });

            var endDate={{$fecha->endOfMonth()->day}}+'/'+{{$fecha->format('m')}}+'/'+{{$fecha->format('Y')}}
            var startDate={{$fecha->firstOfMonth()->day}}+'/'+{{$fecha->format('m')}}+'/'+{{$fecha->format('Y')}}

            $('.datepicker2').datepicker({
                language: 'es',
                autoclose:true,
                format:'dd/mm/yyyy',
                showOn: "button",
                clearBtn:true,
                endDate:endDate,
                startDate:startDate,
                buttonText: '<i class="fa fa-calendar"></i>',

            });

            @if($edit)
            $('.table-detalle tbody tr').each(function(k,v){

                let codigo=$(v).find('.td-codigo').html()
                codigos.push(codigo)
            });
            @endif


            $('.btn-guardar').click(function(_evt) {
                _evt.preventDefault();

                if($('.rb-credito').is(':checked')) {

                    if (validarCredito() && validarCliente()) {
                      enviarFormulario()
                    }
                    else {
                        swal('Alerta', 'No se completaron todos los campos correctamente', 'warning')
                    }
                }



                if($('.rb-contado').is(':checked')) {
                    if (validarContado() && validarCliente()) {
                     enviarFormulario()
                    }
                    else {
                        swal('Alerta', 'No se completaron todos los campos correctamente', 'warning')
                    }
                }



            })

            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let id =$('.select3').find(":selected").val()
                let stock =$('.stock').val()
                let pu=$('.pu').val()
                let cantidad=$('.cantidad').val()
                if(parseInt(cantidad)<=0 || (parseInt(cantidad)>parseInt(stock)) || cantidad==''){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;

                }
                if(parseFloat(pu)<=0 || pu==''){
                    swal('Alerta','Ingrese precio correcto','warning')
                    return false;

                }

                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if($('.vendedor').val()=='')
                {
                    swal('Alerta','Es necesario seleccionar un vendedor','warning')

                    return false
                }
                if($('.credito').val()=='' || parseInt($('.credito').val())<=0)
                {
                    swal('Alerta','El vendedor no cuenta con suficiente stock','warning')

                    return false
                }

                let pt=parseFloat(cantidad*pu).toFixed(2)
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad,
                    pu:pu,
                    pt:pt
                }

                addFila(datos)
                $('.select3').select2('open');


            })
            $('.select2').on('select2:selecting', function(e) {
                let cant=numerosTabla()

                let credito =e.params.args.data.element.attributes.credito.value;
                if(parseInt(credito)<parseInt(cant)){
                    swal('Alerta','El vendedor no cuenta con credito suficiente para asignarle items','warning')

                    return false;
                }


                if(parseInt(credito)<=0 || credito=='' || typeof(credito)=='undefined'){
                    $('.credito').val(0)
                }
                else{
                    $('.credito').val(credito)
                }

            });
            $('.select3').on('select2:selecting', function(e) {
                let stock =e.params.args.data.element.attributes.stock.value;
                let pu =e.params.args.data.element.attributes.pu.value;

                if(parseInt(stock)<=0 || stock=='' || typeof(stock)=='undefined'){
                    $('.stock').val(0)

                }
                else{
                    $('.stock').val(stock)
                    // $('.pu').val(pu)
                }
                $('#cantidad').focus()
            });
            $('.select3').on('select2:select', function(e) {

                $('#cantidad').focus();

            });
            $('#select4').select2({
                placeholder: 'Seleccione un cobrador',
                multiple:false,
                width:'100%'
            });
            $('.select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });
            $('.select3').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });
            $('.rb-credito').click(function(){
                if($(this).is(':checked')){
                    $('.div-credito').show()
                    $('.div-contado').hide()

                }
            })
            $('.rb-contado').click(function(){
                if($(this).is(':checked')){
                    $('.div-credito').hide()
                    $('.div-contado').show()

                }
            })


             $('.comisionable_credito').change(function(){
                calcularComision()
             })
            $('.valorcomisioncredito').change(function(){
                let tipo=$('.tipo-comision-credito').val();

                if(tipo=='P' ){
                calcularComision()

                }

            })

            $('.comisionable_contado').change(function(){
                calcularComisionContado()
            })
            $('.valorcomisioncontado').change(function(){
                let tipo=$('.tipocomisioncontado').val();

                if(tipo=='P' ){
                    calcularComisionContado()

                }

            })



            $('body').on('change','.td-pu',function(){


                let pu=parseFloat($(this).val());
                let cant=parseFloat($(this).closest('tr').find('.td-cant').val())
                let pt=$(this).closest('tr').find('.td-pt')
                pt.val((pu*cant).toFixed(2))
                var totales=numerosTabla()

                $('.cant_total').val(totales.cant)
                $('.precio_total').val(totales.pu)
            })





        })
    </script>
@stop


@endsection