@extends('layouts.admin')
@section('title')Vendedores @stop
@section('titulo')VENDEDORES @stop
@section('menu-vendedores')active open @stop
@section('acciones')
    <button class=" btn-create btn btn-outline-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo vendedor</button>

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Vendedores</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    @include('vendedores.create_edit')
    <div class="modales">
    </div>
    <div class=" btn-group col-md-2 float-right ">
        <a href="{{url('vendedores/excel/')}}" class="btn btn-outline-success">EXCEL</a>
        <a href="{{url('vendedores/pdf/')}}" class="btn btn-outline-danger">PDF</a>
    </div>

    <div style="font-size: 11px" class=" col-lg-12 table-responsive">

    <table  id="table"  class="table table-hover  table-striped " >
        <thead>
        <tr>
            <th>NUM</th>
            <th>CODIGO</th>
            <th>NOMBRES</th>
            <th>NUM <br> DOCUMENTO</th>
            <th>TIPO <br> DOCUMENTO</th>
            <th>NACIONALIDAD</th>
            <th>TELEFONO</th>
            <th>EMAIL</th>
            <th>DIRECCION</th>
            <th>ESTADO</th>
            <th>SUPERVISOR</th>
            <th>CREDITO</th>
            <th>ACCIONES</th>
        </tr>
        </thead>
        <tbody>
        @foreach($vendedores as $f=>$r)
            <tr>
                <td>{{$f+1}}</td>
                <td>{{$r->codigo}}</td>
                <td>{{$r->nombre_completo}}</td>
                <td>{{$r->carnet}}</td>
                <td>{{$r->tipo_documento}}</td>
                <td>{{$r->nacionalidad}}</td>
                <td>{{$r->telefono}}</td>
                <td>{{$r->email}}</td>
                <td>{{$r->direccion}}</td>
                <td>{{$r->estatus}}</td>
                <td>@isset($r->supervisornombre) {{$r->supervisornombre->nombre_completo}} @endisset</td>
                <td>{{$r->credito}}</td>

                <td>
                    <button  type="button"     onclick="alerta({{$r->id}})" class=" btn btn-sm btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></button>
                    <!-- <a href="vendedores/{{$r->id}}/delete" class="btn-delete btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a> -->
                </td>

            </tr>
        @endforeach
        </tbody>
    </table>
    </div>

@section('scripts')

    <script>

        function alerta(id)
        {
            $.ajax({
               url:'./vendedores/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }



        $(document).ready(function(){



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara el vendedor de los registros!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })


        })

        $('#table').dataTable({
   "lengthMenu": [ [50, 100, 300, 500, -1], [50, 100, 300, 500, "Todos"] ],
        'iDisplayLength': -1,
        "aaSorting": []
        })
    </script>
@stop


@endsection