@extends('layouts.admin')
@section('title') Usuarios @stop
@section('titulo') GESTION DE USUARIOS @stop
@section('menu-users')active open @stop
@section('acciones')
    <a data-toggle="modal" href="#modal-create" class=" btn-create btn btn-outline-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo Usuario</a>

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Usuarios</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    <div class="modales">



        <div  id="modal-create" class="modal-create   modal fade modal-fade-in-scale-up" id="form" aria-labelledby="exampleModalTitle" role="dialog"  aria-hidden="true" style="display: none;">
            <div class="modal-dialog modal-simple">


                <form class="form-horizontal" method="POST" action="{{url('users/store')}}">
                    {!! csrf_field() !!}
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                            <h4 class="modal-title">Registrar usuario </h4>
                        </div>
                        <div class="modal-body">


                            <div class="form-group row form-material row">
                                <label class="col-md-4 form-control-label">Nombres completo: </label>
                                <div class="col-md-8">
                                    <input type="text"  required class="form-control" name="name" placeholder="Nombres" autocomplete="off">
                                </div>
                            </div>
                            <div class="form-group row form-material row">
                                <label class="col-md-4 form-control-label">Nombre de usuario (emial) </label>
                                <div class="col-md-8">
                                    <input type="email" required class="form-control" name="email" placeholder="correo electronico" autocomplete="off">
                                </div>
                            </div>
                            <div class="form-group row form-material row">
                                <label class="col-md-4 form-control-label">Contraseña </label>
                                <div class="col-md-8">
                                    <input type="text" required class="form-control" name="password" placeholder="contraseña" autocomplete="off">
                                </div>
                            </div>

                            <div class="form-group row form-material row">
                                <label class="col-md-4 form-control-label">Rol de usuario </label>
                                <div class="col-md-8">

                                    <select name="role"  required id="role" class="form-control">
                                        <option value="">Seleccione</option>
                                        @foreach($roles as $role)
                                            <option value="{{$role->id}}">{{$role->name}}</option>
                                            @endforeach
                                    </select>
                                </div>
                            </div>




                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default btn-pure waves-effect waves-light waves-round" data-dismiss="modal">Cerrar</button>
                            <button type="submit" class="btn btn-primary waves-effect waves-light waves-round">Guardar</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div style="font-size: 11px" class=" col-lg-12 table-responsive">

        @if(auth()->user()->can('contratos diferidos'))

POSITIVO 
@endif


        <table  id="table"  class="table table-hover  table-striped " >
            <thead>
            <tr>
                <th>NUM</th>
                <th>NOMBRES</th>
                <th>USUARIO</th>
                <th>ROL DE USUARIO</th>
                <th>PERMISOS</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($usuarios as $f=>$r)
                <tr>
                    <td>{{$f+1}}</td>
                    <td>{{$r->name}}</td>
                    <td>{{$r->email}}</td>

                    <td>
                        @if(count($r->roles)>0)
                        {{$r->roles[0]->name}}
                            @endif
                    </td>
                    <TD>
                      
                        <ul class="lisunstyled">

                            @foreach($r->getPermissionsViaRoles()->sortBy('modulo') as $p)
                        <li>{{$p->name}} - {{$p->modulo}}</li>
                            @endforeach
                        </ul>

                    </TD>


                    <td>
                        <a href="#modal-edit{{$r->id}}"  data-toggle="modal"  class="btn-edit btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                        <a href="users/{{$r->id}}/delete" class="btn-delete btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>

                        <div  id="modal-edit{{$r->id}}" class="modal-create   modal fade modal-fade-in-scale-up" id="form" aria-labelledby="exampleModalTitle" role="dialog"  aria-hidden="true" style="display: none;">
                            <div class="modal-dialog modal-simple">


                                <form class="form-horizontal" method="POST" action="{{url('users/update')}}">
                                    {!! csrf_field() !!}
                                    <input type="hidden" name="id" value="{{$r->id}}">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                            <h4 class="modal-title">Editar usuario </h4>
                                        </div>
                                        <div class="modal-body">


                                            <div class="form-group row form-material row">
                                                <label class="col-md-4 form-control-label">Nombres completo: </label>
                                                <div class="col-md-8">
                                                    <input type="text" value="{{$r->name}}"  required class="form-control" name="name" placeholder="Nombres" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="form-group row form-material row">
                                                <label class="col-md-4 form-control-label">Nombre de usuario (emial) </label>
                                                <div class="col-md-8">
                                                    <input type="email"  value="{{$r->email}}" required class="form-control" name="email" placeholder="correo electronico" autocomplete="off">
                                                </div>
                                            </div>

                                            <div class="form-group row form-material row">
                                                <label class="col-md-4 form-control-label">Cambiar contraseña </label>
                                                <input type="checkbox" class="check-cambiar" name="cambiar" value="1">

                                            </div>

                                            <div class="div-password orm-group row form-material row" style="display: none">
                                                <label class="col-md-4 form-control-label">Contraseña </label>
                                                <div class="col-md-8">
                                                    <input type="text"  class="form-control" name="password" placeholder="contraseña" autocomplete="off">
                                                </div>
                                            </div>

                                            <div class="form-group row form-material row">
                                                <label class="col-md-4 form-control-label">Rol de usuario </label>
                                                <div class="col-md-8">

                                                    <select name="role"  required id="role" class="form-control">
                                                        <option value="">Seleccione</option>
                                                        @foreach($roles as $role)
                                                            <option  @if(count($r->roles)>0 && $r->roles[0]->id==$role->id) selected @endif value="{{$role->id}}">{{$role->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default btn-pure waves-effect waves-light waves-round" data-dismiss="modal">Cerrar</button>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light waves-round">Guardar</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

@section('scripts')

    <script>



        $(document).ready(function(){

            $('.check-cambiar').click(function(){
                if($(this).is(':checked')){
                    $(this).closest('form').find('.div-password').show();
                    $(this).closest('form').find('.div-password').find('input').attr('required',true);

                }
                else{
                    $(this).closest('form').find('.div-password').hide();
                    $(this).closest('form').find('.div-password').find('input').val('');
                    $(this).closest('form').find('.div-password').find('input').attr('required',false);

                }
            })






            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara este usuario de los registros!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })

        })

        $('#table').dataTable({

        })
    </script>
@stop


@endsection