@extends('layouts.admin')
@section('title')libros @stop
@section('titulo')LIBROS @stop
@section('menu-catalogo')active open @stop
@section('libros-opcion')active @stop
@section('acciones')
<button class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>Registrar Libro</button>

@stop
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item active">Libros</li>
</ol>
@stop
@section('content')
{{--modal--}}
@include('libros.create_edit')
<div class="modales">
</div>
<div class=" btn-group col-md-2 float-right ">
    <a href="{{url('libros/excel/')}}" class="btn btn-outline-success">EXCEL</a>
    <a href="{{url('libros/pdf/')}}" class="btn btn-outline-danger">PDF</a>
</div>
<div class="table-responsive">

    <table id="table" class="table data-table table-hover  table-striped ">
        <thead>
            <tr>
                <th>NUM</th>
                <th>CODIGO</th>
                <th>FOTO</th>
                <th>TITULO</th>
                <th>TOMO</th>
                <th>EDITORIAL</th>
                <th>PRECIO BASE</th>
                <th>PRECIO FINAL</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            @foreach($libros as $f=>$r)
            <tr>
                <td>{{$f+1}}</td>
                <td>{{$r->codigo}}</td>
                <td><img src="" alt="">@if($r->foto!='')<img onClick="showImage(this.src)" src="{{ asset('storage/local/'.$r->foto) }}" width="150" />@endif</td>
                <td>{{$r->titulo}}</td>
                <td>{{$r->tomo}}</td>
                <td>
                    @if(isset($r->editorial))
                    {{$r->editorial->nombre}}
                    @endif
                </td>
                <td>{{$r->precio_base}}</td>
                <td>{{$r->precio_final}}</td>
                <td>
                    <button type="button" onclick="alerta({{$r->id}})" class=" btn btn-sm btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></button>
                    <a href="libros/{{$r->id}}/delete" class="btn-delete btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>


<!-- Modal -->
<div class="modal fade" id="modalFoto" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Foto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

@section('scripts')

<script>
    function alerta(id) {
        // var id=$(this).attr('id')


        $.ajax({
            url: './libros/' + id + '/edit',
            method: 'GET',
            dataType: 'html',
            success: function(res) {
                $('.modales').empty();
                $('.modales').append(res)
                $('.modal-edit').modal('show')
                select2();
            },
            error: function() {
                alert('ocurrio un error')
            }
        })

    }

    function showImage(url='') {
      let _img=  `<img src="${url}" width="100%" />`
     $('#modalFoto').find('.modal-body').empty();
     $('#modalFoto').find('.modal-body').append(_img)
     $('#modalFoto').modal('show')
    }


    $(document).ready(function() {
        $(document).on('change', '.codigo', function() {
            var _this = $(this)

            var codigo = _this.val();
            $.ajax({
                url: './libros/validar-codigo/' + codigo,
                dataType: 'json',
                type: 'GET',
                success: function(res) {
                    if (res.status) {
                        swal('Alert', 'el codigo del libro:' + codigo + ' ya existe', 'warning')
                        _this.val('')
                        _this.focus()
                    }

                },
                error: function() {
                    alert('Ocurrio un error')
                }


            })
        })



        var select2 = function() {


            $('body .select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple: false,
                width: '90%'
            });

        }


        $('.btn-delete').click(function(_evt) {
            _evt.preventDefault();

            var _href = $(this).prop('href')

            swal({
                    title: "Esta seguro?",
                    text: "Se eliminara el item de los registros!",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    window.location = _href
                });

        })





        $('.btn-create').click(function() {
            $('.modal-create').modal('show')
            select2()
        })



        $('body .btn-edit').on('click', function() {
            alert('')



            var id = $(this).attr('id')


            $.ajax({
                url: './libros/' + id + '/edit',
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error: function() {
                    alert('ocurrio un error')
                }
            })
        })
    })
</script>
@stop


@endsection