 <style>
     form.imagen {
         width: 25em;
         padding: 1em;
         border: 1px solid #ccc;
         border-radius: .5em;
         margin: auto;
         box-shadow: .25em .25em 0 #ccc;
     }

     /* Estilo del área del input[file] */
     .drag-drop {
         height: 8em;
         width: 8em;
         background-color: #ccc;
         border-radius: 4em;
         text-align: center;
         color: white;
         position: relative;
         margin: 0 auto 1em;
     }

     .drag-drop span.desc {
         display: block;
         font-size: .7em;
         padding: 0;
         position: absolute;
         top: 60%;
         color: #000;
     }

     input[type="file"] {
         height: 10em;
         opacity: 0;
         position: absolute;
         top: 0;
         left: 0;
         width: 100%;
         z-index: 3;
     }

     /* Estilo del área del input[file] con :hover */

     .drag-drop:hover,
     input[type="file"]:hover {
         background-color: #3276b1;
         cursor: pointer;
     }

     .drag-drop:hover span.desc {
         color: #fff;
     }

     /* Composición del icono de Upload con FontAwesome */
     .fa-stack {
         margin-top: .5em;
     }

     .fa-stack .top {
         color: white;
     }

     .fa-stack .medium {
         color: black;
         text-shadow: 0 0 .25em #666;
     }

     .fa-stack .bottom {
         color: rgba(225, 225, 225, .75);
     }

     .drag-drop:hover .pulsating {
         animation: pulse1 1s linear infinite;
         animation-direction: alternate;
         -webkit-animation: pulse1 1s linear infinite;
         -webkit-animation-direction: alternate;
     }

     /* Keyframing de la animación */

     @keyframes pulse1 {
         0% {
             color: rgba(225, 225, 225, .75);
         }

         50% {
             color: rgba(225, 225, 225, 0.25);
         }

         100% {
             color: rgba(225, 225, 225, .75);
         }
     }

     @-moz-keyframes pulse1 {
         0% {
             color: rgba(225, 225, 225, .75);
         }

         50% {
             color: rgba(225, 225, 225, 0.25);
         }

         100% {
             color: rgba(225, 225, 225, .75);
         }
     }

     @-webkit-keyframes pulse1 {
         0% {
             color: rgba(225, 225, 225, .75);
         }

         50% {
             color: rgba(225, 225, 225, 0.25);
         }

         100% {
             color: rgba(225, 225, 225, .75);
         }
     }

     @-ms-keyframes pulse1 {
         0% {
             color: rgba(225, 225, 225, .75);
         }

         50% {
             color: rgba(225, 225, 225, 0.25);
         }

         100% {
             color: rgba(225, 225, 225, .75);
         }
     }
 </style>
 <div class="row justify-content-center align-items-center ">

     <div class="panel panel-primary panel-foto" @if($credito->foto=='') style="display:block" @else style="display:none" @endif>
         <div class="panel-heading panel-primary">
             <h4 class="panel-title" align="center">SUBIR FOTO DEL CONTRATO</h4>
         </div>
         <div class="panel-body ">


             <form action="{{url('referencias/store-image')}}" method="post" enctype="multipart/form-data" class="imagen form-foto">
                 {!! csrf_field() !!}
                 <input type="hidden" name="credito_id" value="{{$credito->id}}">
                 <div class="drag-drop">
                     <input type="file" multiple="multiple" name="foto" id="foto" />
                     <span class="" style="font-size: 4em">
                         <i class="icon md-cloud-upload bottom pulsating"></i>

                     </span>
                     <span class="desc">Pulse aquí para añadir archivos</span>
                 </div>
                 <p class="label label-info text-sm nombre-archivo text-center">
                     <span class="text-danger "> Puede subir archivos hasta 2 megas (jpeg,png,jpg,gif,svg)</span>
                 </p>

                 <button type="button" class="btn btn-primary btn-block btn-guardar-foto">GUARDAR</button>
             </form>


         </div>
     </div>


     <div class=" col-md-12 div-foto " @if($credito->foto=='') style="display:none" @else style="display:block" @endif>

         <img src="data:image/jpeg;base64,{{ base64_encode($imagen) }}" width="200px" class="col-md-6 "><br>
         <div class="btn-group" role="group" aria-label="Basic example">
             <a class="btn btn-primary btn-xs" href="{{url('referencias/descargar-foto/'.$credito->foto)}}"><i class="icon md-download"></i>Descargar foto</a>
             <button type="button" class="btn-cambiarfoto btn btn-xs btn-warning"><i class="icon md-edit"></i>Cambiar foto</button>
         </div>

     </div>


 </div>
 <script>
     $('#foto').change(function() {
         var fichero_seleccionado = $(this).val();
         var nombre_fichero_seleccionado = fichero_seleccionado.replace(/.*[\/\\]/, ''); //Eliminamos el path hasta el fichero seleccionado
         $(".nombre-archivo").empty();
         $(".nombre-archivo").text(nombre_fichero_seleccionado);
     })


     $('.btn-guardar-foto').click(function(_evt) {
         _evt.preventDefault()
         // $('.div-foto').hide();
         $('.form-foto').submit();
     })

     $('.btn-cambiarfoto').click(function() {
         // $('.div-foto').hide();
         $('.panel-foto').show();
     })
 </script>