@extends('layouts.admin')
@section('title') REGISTRAR DEVOLUCION OBRAS @stop
@section('titulo')  REGISTRAR DEVOLUCION OBRAS @stop
@section('styles')
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">

@stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item "><a href="{{url('/devolucion-cobranza')}}">Devolucion cobranza</a></li>
        <li class="breadcrumb-item active"><a href="{{url('devolucion-cobranza')}}">Registrar Devolucion</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <form class="form-inline" method="POST" action="{{url('devolucion-cobranza/create')}}">
        {!! csrf_field() !!}
        <div class="form-group col-md-4">
            <div class="row">
                <div class="form-row col-md-12">
                    <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"  style="width:150%" class="numcuenta  form-control" >
                    <input type="hidden" name="credito_id" class="credito_id" value=""  >
                </div>
                <div class="form-row col-md-12">
                    <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                    <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                </div>

            </div>
        </div>
        <div class="form-group ">
            <button type="submit" name="buscar"  style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>

    @if(isset($credito) && !is_null($credito))
        <hr>
        <div class="table-responsive col-md-10">

            
          @include('cobranza.includes.detalle-cuenta')

        </div>
        <hr>
        @if(count($devoluciones)>0)
        <div class="row">
            <div class="col-md-6">
                <table class="table">
                    <thead>
                        <tr>
                            <td colspan="5">HISTORIAL DE DEVOLUCIONES</td>
                        </tr>
                        <tr>
                            <th>Fecha</th>
                            <th>Tipo</th>
                            <th>#Contrato</th>
                            
                            <th>Estado</th>
                            <th>Monto</th>
                            {{-- <th>Ver Nota</th> --}}
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($devoluciones as $d)
                        <tr>
                            <td>{{$d->fecha}}</td>
                            <td>{{$d->tipo_devolucion}}</td>
                            <td>{{$d->num_contrato}}</td>
                            <td>{{$d->estado}}</td>
                            <td>{{$d->monto_devolucion}}</td>
                            {{-- <td>

                                <a id="{{$d->id}}" href="###" class="btn-ver-devolucion btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round"data-toggle="tooltip" data-original-title="Ver nota devolucion"><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                            </td> --}}
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
        <div class="row">
            
            <div class="col-md-6">
                <form action="{{url('devolucion-cobranza/store')}}" method="POST" class="form" style="font-size: 0.9em">
                    {!! csrf_field() !!}
                    <input type="hidden" name="credito_id" value="{{$credito->id}}">
                    <div class="form-group  form-row">
                        <div class="col-md-2">
                            <label for="">FECHA</label>
                            <input type="text"  name="fecha" class="fecha datepicker form-control">
                        </div>

                        <div class="col-md-6">
                            <label for="">OBSERVACIONES</label>
                            <textarea name="obs" class="form-control"></textarea>
                        </div>
                    </div>
                    <table class="table table-condensed table-bordered table-detalle">
                        <thead>
                        <tr style="font-weight: bolder">
                            <td align="center">CANT</td>
                            <td align="center">CODIGO</td>
                            <td align="center">TITULO</td>
                            <td align="right">P.UNIT</td>
                            <td align="right">P.TOTAL</td>
                            <td>CANT/MARCAR</td>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($credito->contrato->detalle as $k=>$d)
                            <tr>
                                <td align="center" class="cant_detalle">{{$d->cantidad}}</td>
                                <td>{{$d->codigo}}</td>
                                <td>{{$d->titulo}}</td>
                                <td align="right" class=""><input   disabled type="text" class=" pu_detalle numeroscondecimales" size="5" value="{{$d->precio_unitario}}"></td>
                                <td align="right" class="p_total">{{$d->precio_total}}</td>
                                <td align="center">
                                    <input type="text" name="cantidad[]"  class="solo-enteros cant_marcar" value="{{$d->cantidad}}" size="3%">/
                                    <input type="checkbox" name="cb[]"  value="{{$d->libros_id}}" class="cb">
                                </td>
                                <input type="hidden" name="codigo[]" value="{{$d->codigo}}">
                                <input type="hidden" name="titulo[]" value="{{$d->titulo}}">
                                <input type="hidden" name="precio_unitario[]" value="{{$d->precio_unitario}}">
                                <input type="hidden" name="libros_id[]" value="{{$d->libros_id}}">
                            </tr>
                            @endforeach
                        <tr>
                            <td></td>
                            <td></td>

                            <td ALIGN="right" colspan="2" style="font-weight: bolder">P.VENTA</td>
                            <td align="right" style="font-weight: bolder">{{$credito->contrato->preciototal}}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td></td>

                            <td  ALIGN="right" colspan="2" style="font-weight: bolder">SALDO ACTUAL</td>
                            <td align="right" style="font-weight: bolder"><input  style="font-weight: bolder; text-align: right" type="text"  name="saldo_actual"  size="5%" value="{{$credito->saldo_actual}}" class=" saldo_actual form-control form-control-sm numeroscondecimales"></td>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>

                    <button   type="submit" class="btn btn-guardar btn-primary btn-block"> GUARDAR</button>


                </form>
            </div>
            <div class="col-md-3">
                <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
                <table class="table table-condensed">
                    <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>NUM RECIBO</td>
                        <td>MONTO</td>
                        <td>SALDO</td>
                        <td>ACCIONES</td>
                    </tr>
                    </thead>
                    <tbody>
                         @php
                    $saldo=$credito->saldo_inicial;
                    @endphp
                    @foreach($pagos as $p)
                        <tr>
                            <td>{{$p->fecha->format('d/m/Y')}}</td>
                            <td align="center">{{$p->recibo->numero}}</td>
                            <td align="right">{{$p->recibo->monto}}</td>
                             @php $saldo-=$p->monto @endphp
                            <td align="right">{{round($saldo,2)}}</td>
                            <td>
                                <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}" class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>
            <div class="col-md-3">

                <h5 class="alert alert-info text-primary text-center">PLAN DE PAGOS</h5>
                <table class="table table-condensed">
                    <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>CUOTA</td>
                        <td>MONTO</td>
                        <td>SALDO</td>
                    </tr>
                    </thead>
                    <tbody>
                    @php $saldo=$credito->saldo;
                    @endphp
                    @foreach($cuotas as $p)
                        <tr>
                            <td>{{\Carbon\Carbon::createFromFormat('Y-m-d',$p['fecha'])->format('d/m/Y')}}</td>
                            <td align="center">{{$p['numcuota']}}</td>
                            <td align="right">{{$p['monto']}}</td>
                            <td align="right">{{round($saldo-$p['monto'],2)}}</td>

                        </tr>
                        @php
                            $saldo-=$p['monto'];
                        @endphp
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
@section('scripts')
    <script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>
<script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>
    <script>

  function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#myPrintArea').printArea();


        }


        var options = {
            theme:'dark',
            url: "../common/buscar-cuenta",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 400
        };

        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });

        $('.cant_marcar').on('change',function(){
            let cant=parseFloat($(this).closest('tr').find('.cant_detalle').html());
            let _this=parseFloat($(this).val())
            if(_this>cant || _this<=0){
                $(this).val(cant)
            }

        })

        // $('.pu_detalle').change(function(){
        //     let cb=$(this).closest('tr').find('.cb')
        //     let cant_marcar=parseInt($(this).closest('tr').find('.cant_marcar').val())
        //     let cant_origen=parseInt($(this).closest('tr').find('.cant_detalle').html())
        //     let pu=parseFloat($(this).closest('tr').find('.pu_detalle').val())
        //     let saldo_actual=parseFloat($('.saldo_actual').val());
        //     let monto=(cant_marcar*pu).toFixed(2)
            
        //    if($(cb).is(':checked')){
          

        //         $('.saldo_actual').val((saldo_actual-monto).toFixed(2));


        //     }
            
        //     else{
        //         monto=parseFloat(cant_origen*pu).toFixed(2)

        //         let res=parseFloat(saldo_actual)+parseFloat(monto)
        //         $('.saldo_actual').val(res.toFixed(2));

        //     }
        // })
         $('.btn-ver-devolucion').click(function(_evt){
                _evt.preventDefault();
                let id=$(this).attr('id')
                 let url='{{url("devolucion-cobranza'+id+'/ver")}}'
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })

        $('.cb').click(function(){
            let cant_marcar=parseInt($(this).closest('tr').find('.cant_marcar').val())
            let cant_origen=parseInt($(this).closest('tr').find('.cant_detalle').html())
            let pu=parseFloat($(this).closest('tr').find('.pu_detalle').val())
            let saldo_actual=parseFloat($('.saldo_actual').val());
            let monto=(cant_marcar*pu).toFixed(2)
            
            if($(this).is(':checked')){
                  $(this).closest('tr').find('.pu_detalle').attr('disabled',false)
                $('.saldo_actual').val((saldo_actual-monto).toFixed(2));


            }else{
                monto=parseFloat(cant_origen*pu).toFixed(2)
           $(this).closest('tr').find('.pu_detalle').attr('disabled',true)
                let res=parseFloat(saldo_actual)+parseFloat(monto)
                $('.saldo_actual').val(res.toFixed(2));

            }
        })

    $('.fecha').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha.val(),modulo:'COBRANZA'},
             dataType:'json',
             method:'GET',
             async:false,
          

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })


        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();

            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }
            let num_check=$('.table-detalle tbody input:checkbox:checked').length;

            if(num_check<=0){
                swal('Alerta','Debe seleccionar al menos un item','warning')
                return false;

            }


            swal({
                    title: "Revise todo los campos",
                    text: "Se registrara la devolucion ?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





    </script>
@stop


@endsection