@extends('layouts.admin')
@section('title') Cobradores @stop
@section('titulo')COBRADORES @stop
@section('acciones')
    <button class=" btn-create btn btn-outline-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo Cobrador</button>
  
@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Cobradores</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    @include('cobradores.create_edit')
    <div class="modales">
    </div>
    <div class="btn-group col-md-2 float-right " role="group" >
            <form method="POST" class="form-inline" action="{{url('cobradores')}}">
                {{ csrf_field()}}
                <button name="tipoexportacion" value="excel" class="btn btn-outline-success">EXCEL</button>
                <button name="tipoexportacion" value="pdf" class="btn btn-outline-danger">PDF</button>
            </form>

        </div>

    <div style="font-size: 11px" class=" col-lg-12 table-responsive">

       @include('cobradores.tabla')
    </div>

@section('scripts')

    <script>

        function alerta(id)
        {
            $.ajax({
                url:'./cobradores/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }



        $(document).ready(function(){



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara el vendedor de los registros!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })


        })

        $('#table').dataTable({
   "lengthMenu": [ [50, 100, 300, 500, -1], [50, 100, 300, 500, "Todos"] ],
        'iDisplayLength': -1,
        "aaSorting": []
        })
    </script>
@stop


@endsection