@extends('layouts.admin') 
@section('title') MANTENIMIENTO 
@stop 
@section('titulo') MANTENIMIENTO 
@stop 
@section('styles')
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}"> 
@stop 
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Cobranza</li>
    <li class="breadcrumb-item "><a href="{{url('/central-riesgos')}}">Central de riesgos</a></li>
    <li class="breadcrumb-item active"><a href="">Mantenimiento</a></li>
</ol>






@stop 
@section('content')
    @include('includes.modal-ver')

<form class="form-inline" method="GET" action="{{url('central-riesgos/mantenimiento')}}">


    <div class="form-group col-md-4 ">
        <div class="row">
            <div class="form-row col-md-12">
                <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"
                    style="width:150%" class="numcuenta  form-control">
                <input type="hidden" name="deuda_id" class="deuda_id" value="">
            </div>
            <div class="form-row col-md-12">
                <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                <label for="">Carnet <input type="radio"  class=" radio-inline tipo_carnet" name="tipo" value="carnet"></label>
            </div>

        </div>
    </div>
    <div class="form-group ">
        <button type="submit" name="buscar" style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
    </div>
</form>

@if(isset($deuda) && !is_null($deuda))
<hr> @if(!is_null($credito))
<div class="table-responsive col-md-10">
    @include('cobranza.includes.detalle-cuenta')

</div>

<hr>
<div class="row">



    <div class="col-md-6 row">
        <div class="col-md-6">
            <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>NUM RECIBO</td>
                        <td>NUM REPORTE</td>
                        <td>MONTO</td>
                        <td>SALDO</td>
                        <td>ACCIONES</td>
                    </tr>
                </thead>
                <tbody>
                    @php $saldo=$credito->saldo_inicial; 
@endphp @foreach($pagos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d/m/Y')}}</td>
                        <td align="center">
                            @isset($p->recibo) {{$p->recibo->numero}} @endisset
                        </td>
                        <td>
                            {{$p->num_reporte}}
                        </td>
                        <td align="right">

                            {{$p->monto}}

                        </td>
                        @php $saldo-=$p->monto 
@endphp
                        <td align="right">{{round($saldo,2)}}</td>
                        <td>
                            <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}" class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>

        @if(count($descuentos)>0)

        <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DESCUENTOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>NUMRECIBO</td>
                        <td>NUMREPORTE</td>
                        <td>MONTO</td>

                    </tr>
                </thead>
                <tbody>

                    @foreach($descuentos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$p->pago->numrecibo}}</td>
                        <td align="right">{{$p->pago->num_reporte}}</td>
                        <td align="right">{{round($p->monto,2)}}</td>

                    </tr>

                    @endforeach
                </tbody>
            </table>
        </div>
        @endif @if(count($devoluciones)>0)

        <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DEVOLUCIONES</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>TIPO</td>
                        <td>MONTO</td>

                    </tr>
                </thead>
                <tbody>

                    @foreach($devoluciones as $d)
                    <tr>
                        <td>{{$d->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$d->tipo}}</td>
                        <td align="right">{{round($d->monto_devolucion,2)}}</td>

                    </tr>

                    @endforeach
                </tbody>
            </table>
        </div>
        @endif
    </div>
    <div class="col-md-6">
        @if($credito->saldo>0)
        <form action="{{url('pagos-cobranza/store')}}" method="POST" class="form" style="font-size: 0.9em">
            {!! csrf_field() !!}
            <input type="hidden" name="credito_id" value="{{$credito->id}}">
            <div class="form-group  form-row">
                <div class="col-md-12">
                    <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                    <input type="text" name="nombres" value="{{$credito->nombre_cliente}}" class="nombres form-control">
                </div>
            </div>
            <div class="form-group  form-row">
                <div class="col-md-2">
                    <label for="">NUM RECIBO</label>
                    <input type="text" autofocus name="numrecibo" class="recibo form-control">
                </div>
                <div class="col-md-2">
                    <label for="">FECHA RECIBO</label>
                    <input type="text" name="fecha" class="fecha datepicker form-control">
                </div>
                <div class="col-md-3">
                    <label for="">IMPORTE PAGADO</label>
                    <input type="text" name="monto" class="monto numeroscondecimales form-control">
                </div>
                <div class="col-md-2">
                    <label for="">N° REPORTE</label>
                    <input type="text" name="reporte" class="reporte form-control">
                </div>

            </div>
            <div class="form-group  form-row">
                <div class="col-md-6">
                    <label for="">QUIEN COBRO</label>
                    <select name="cobrador" class="form-control select2" id="">
                                <option value="">SELECCIONE</option>
                                @foreach($cobradores as $c)
                                <option value="{{$c->id}}" @if(isset($credito->cobrador) && $credito->cobrador->id==$c->id)  selected @endif>{{$c->nombre_completo}}</option>
                                    @endforeach
                            </select>
                </div>


                <div class="col-md-6">
                    <label for="">OBSERVACIONES</label>
                    <textarea name="obs" class="form-control"></textarea>
                </div>
            </div>

            <button type="button" class="btn btn-info btn-registrar-descuento"> + Registrar Descuento</button>

            <div class="div-descuento form-row" style="display: none">
                <div class="col-md-12">
                    <h5 class="label label-primary text-center"><strong>REGISTRAR DESCUENTO</strong></h5>
                </div>
                <div class="col-md-4">
                    <label for="">TIPO DESCUENTO</label>
                    <input type="text" READONLY value="PRONTO PAGO" name="tipo_descuento" class="tipo-descuento form-control">
                </div>

                <div class="col-md-2">
                    <label for="">MONTO PAGO</label>
                    <input type="text" name="monto_descuento" class="monto-descuento  numeroscondecimales form-control">
                </div>
                <div class="col-md-2">
                    <label for="">&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-cancelar-descuento" style="margin-top: 20px">Cancelar</button>
                </div>

            </div>
            <hr>

            <button type="submit" class="btn btn-guardar btn-primary btn-block"> GUARDAR</button>


        </form>
       
        @endif
    </div>



</div>

@endif



<div class="row">

   
    <div class="col-md-6">
     
        
        <div class="card ">
            <div class="card-header bg-primary mb-3 text-white">
                
                <h4 class="text-white  card-title">DATOS DE LA DEUDA</h4>
            </div> 
            <div class="card-body">
                <table class="table">
                    <tr>
                        <td><strong>Nombres:</strong></td><td>{{$deuda->nombres}} {{$deuda->apellidos}} </td>
                        
                    </tr>
                    <tr>
                           <td><strong>Doc. Identidad:</strong></td><td align="left">{{$deuda->num_documento}} {{$deuda->lugar_doc}}</td>
                    </tr>
                    <tr>
                        <td><strong>Tipo documento deuda:</strong></td><td>{{$deuda->tipo_doc_deuda}} </td>
                    </tr>
                    <tr>
                        <td><strong>Numero documento deuda:</strong></td>
                        <td>{{$deuda->num_doc_deuda}} </td>
                    </tr>
                    <tr>
                        <td><strong>Fecha de Ingreso vencida:</strong></td>
                        <td>{{$deuda->fecha_ingreso_vencida}} </td>
                    </tr>
                    <tr>
                        <td><strong><H4 class="text-danger">MONTO DE LA DEUDA</H4>:</strong></td>
                    <td><H4 class="text-danger">{{$deuda->saldo_deuda_vencida}}{{$deuda->moneda}}</H4> </td>
                    </tr>
                </table>
            </div>

            </div>
       
    </div>
    
<div class="col-md-6">

    @if($deuda->estado=='T')
<h4 class="alert alert-info">ESTA DEUDA YA  HA SIDO PAGADA EN FECHA {{$deuda->fecha_cancelado}}</h4>

@else
    <div class="card ">
        <div class="card-header bg-primary mb-3 text-white">

            <h4 class="text-white  card-title">FORMULARIO DE CANCELACION</h4>
        </div>
        <div class="card-body">
            <form action="{{url('central-riesgos/pago-store')}}" method="POST" class="form" style="font-size: 0.9em">
                    {!! csrf_field() !!}
                    <input type="hidden" name="deuda_id" value="{{$deuda->id}}">
                    <div class="form-group  form-row">
                        <div class="col-md-12">
                            <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                        <input type="text" name="nombres" value="{{$deuda->nombres}} {{$deuda->apellidos}}" class="nombres form-control">
                        </div>
                    </div>
                    <div class="form-group  form-row">
                        <div class="col-md-2">
                            <label for="">NUM RECIBO</label>
                            <input type="text" autofocus name="numrecibo" class="recibo form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">FECHA RECIBO</label>
                        <input type="text"  required   value="{{date('d/m/Y')}}" name="fecha" class="fecha datepicker form-control">
                        </div>
                        <div class="col-md-3">
                            <label for="">IMPORTE PAGADO</label>
                        <input type="text" name="monto"  readonly  value="{{$deuda->saldo_deuda_vencida}}" class="monto numeroscondecimales form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">N° REPORTE</label>
                            <input type="text" name="reporte" class="reporte form-control">
                        </div>
                
                    </div>
                    <div class="form-group  form-row">
                  
                
                
                        <div class="col-md-12">
                            <label for="">OBSERVACIONES</label>
                            <textarea name="obs" class="form-control"></textarea>
                        </div>
                    </div>
                
                    {{-- <button type="button" class="btn btn-info btn-registrar-descuento"> + Registrar Descuento</button> --}}
                
                    <div class="div-descuento form-row" style="display: none">
                        <div class="col-md-12">
                            <h5 class="label label-primary text-center"><strong>REGISTRAR DESCUENTO</strong></h5>
                        </div>
                        <div class="col-md-4">
                            <label for="">TIPO DESCUENTO</label>
                            <input type="text" READONLY value="PRONTO PAGO" name="tipo_descuento" class="tipo-descuento form-control">
                        </div>
                
                        <div class="col-md-2">
                            <label for="">MONTO PAGO</label>
                            <input type="text" name="monto_descuento" class="monto-descuento  numeroscondecimales form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">&nbsp;</label>
                            <button type="button" class="btn btn-danger btn-cancelar-descuento" style="margin-top: 20px">Cancelar</button>
                        </div>
                
                    </div>
                    <hr>
                
                    <button type="submit" class="btn btn-guardar btn-primary btn-block"> GUARDAR</button>
                
                
                </form>
           
        </div>

    </div>
    @endif

</div>
</div>



@endif 
@section('scripts')
<script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>

<script>
    var pagos=[];

        @if(isset($pagos))

                        @foreach($pagos as $p)

                            @isset($p->recibo)
                        pagos.push('{{$p->recibo->numero}}')
                            @endisset


                        @endforeach

                        @endif





        var options = {
             theme:'dark',
            // url: "../common/buscar-cuenta",
            url: "{{url('common/buscar-deudor')}}",


            getValue: function(element) {
                console.log(element.datos)
               
                // return 'Documento:'+element.datos.num_doc_deuda+' Cliente: '+element.datos.nombres;
                return 'Documento:'+element.num_doc_deuda+' Cliente: '+element.nombres;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                maxNumberOfElements: 1000,
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".deuda_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else if($('.tipo_carnet').is(':checked')){
                      tipo='carnet'
                }
                else  {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 200
        };

         $('.btn-registrar-descuento').click(function(){
             $(this).hide();
             $('.div-descuento').show()
             $('.monto-descuento').focus()

         })
        $('.btn-cancelar-descuento').click(function(){
            $('.div-descuento').hide()
            $('.btn-registrar-descuento').show()
            $('.monto-descuento').val('')
        })


        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });
        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();

            let recibo=$('.recibo').val();
            if($('.monto').val()==''){
                swal('Alerta','Ingrese un monto para el pago','warning')
                return false;

            }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }
              console.log(pagos.indexOf(recibo),recibo,pagos)


            if(pagos.indexOf(recibo)!=-1){
                 swal('Alerta','El numero de recibo ya se encuentra registrado','warning')
                return false;
            }


            swal({
                    title: "Registro de Pago",
                    text: "Se registrara el pago?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })

</script>






@stop
@endsection