@extends('layouts.admin')
@section('styles')


@stop

@section('title')NOTAS DE REMISION @stop
@section('titulo')NOTAS DE REMISION @stop
@section('menu-remision')active open @stop

{{--@section('libros-opcion')active @stop--}}
@section('acciones')
<a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>Nueva Remision</a>


@stop
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Almacenes</li>
    <li class="breadcrumb-item active"><a href="{{url('/notas-remision')}}">Notas de Remision</a></li>
</ol>
@stop
@section('content')



<div class="nav navbar-nav float-xs-right">
    <form class="form-inline pull-right" method="get" action="{{url('notas-remision')}}">
        @include('includes.form-periodo')
        <div class="form-group form-material">
            <button type="submit" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>
</div>
@if(Session::has('errorLibros'))
<BR>
<h4>LISTA DE LIBROS QUE NO TIENEN INVENTARIO</h4>
<ul class="alert alert-warning list-unstyled">
    @foreach(Session::get('errorLibros') as $error)
    <li>{{$error['libro']->codigo}} {{$error['libro']->titulo}} - <strong>CANTIDAD SOBRE EL INVENTARIO</strong> : {{$error['overqty']}}</li>
    @endforeach
</ul>
@endif

<div class="table-responsive">

    <table id="table" class="data-table table table-hover  table-striped">
        <thead>
            <tr>
                <th>FECHA</th>
                <th>NUMERO</th>
                <th>VENDEDOR</th>
                <th>ESTADO</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            @foreach($datos as $f=>$r)
            <tr>
                <td>{{$r->fecha->format('d/m/Y')}}</td>
                <td width="1%">{{$r->id}}</td>
                <td>{{$r->vendedor->nombre_completo}}</td>
                <td>{{$r->estado}}</td>
                <td>
                    @if($r->estado=='CREADO')
                    <a a href="notas-remision/{{$r->id}}/editar" class=" btn  btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                    <a href="notas-remision/{{$r->id}}/delete" id="{{$r->id}}" class="btn-delete btn  btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                    <a href="notas-remision/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-success on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>
                    @endif
                    <a href="notas-remision/{{$r->id}}/ver" class="btn-ver btn btn-icon btn-pure btn-primary on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Nota"><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                    @if($r->estado=='PROCESADO')
                    <a href="notas-remision/{{$r->id}}/anular" id="{{$r->id}}" class="btn-anular btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Anular Nota"><i class="icon md-block" aria-hidden="true"></i></a>
                    <button onclick="cargarModalKardex('remision',{{$r->id}})" class=" btn-verkardex  btn btn-info btn-icon btn-pure btn-dark on-default remove-row waves-effect waves-light waves-round" data-target="#" data-toggle="modal" type="button">K</button>


                    @endif

                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>


<div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true" aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">

            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>

            </div>
        </div>
    </div>
</div>

@include('includes.modal-kardex')

@section('scripts')
<script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

<script>
              var sending=false
    function processData(_href){
        if(sending==false){
            window.location = _href
        sending=true  
        }
    }
    function alerta(id) {
        $.ajax({
            url: './libros/' + id + '/edit',
            method: 'GET',
            dataType: 'html',
            success: function(res) {
                $('.modales').empty();
                $('.modales').append(res)
                $('.modal-edit').modal('show')
                select2();
            },
            error: function() {
                alert('ocurrio un error')
            }
        })

    }

    function imprimir() {
        var options = {
            mode: "iframe",
            popClose: close,
            retainAttr: ['class', 'style', 'id']
        };

        $('#myPrintArea').printArea();


    }


    function imprimirNota(id) {
        let url = 'notas-remision/' + id + '/ver'
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'HTML',
            async: false,
            cache: false,
            success: function(res) {

                $('.modal-ver').find('.modal-body').empty();
                $('.modal-ver').find('.modal-body').html(res)
                $('.modal-ver').modal('show')

            }
        })
    }
    $(document).ready(function() {
        // $(".data-table").tableHeadFixer();




        @if(isset($imprimir) && $imprimir)
        imprimirNota({{$remision}})
        @endif


        $('.btn-anular').click(function(_evt) {
            _evt.preventDefault();
            let _href = $(this).attr('href')
            let _id = $(this).attr('id')
            swal({
                    title: "Esta seguro?",
                    text: "Se anulara la Remision Num:" + _id,
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-warning",
                    confirmButtonText: "Si, Anular!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    $.ajax({
                        url: './notas-remision/' + _id + '/validar-anular',
                        method: 'get',
                        dataType: 'json',
                        success: function(res) {
                            if (res.status) {

                                swal('Alerta', 'No se puede anular la nota. Existen items  asociados a otras notas', 'warning')

                            } else {
                                window.location = _href

                            }

                        },
                        error: function() {
                            alert('Ocurrio un error en el servidor')
                        }
                    })



                });


        });

        $('.btn-ver').click(function(_evt) {
            _evt.preventDefault();
            let url = $(this).attr('href')
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'HTML',
                async: false,
                cache: false,
                success: function(res) {

                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').html(res)
                    $('.modal-ver').modal('show')

                }
            })
        });

        $('.btn-procesar').click(function(_evt) {
            _evt.preventDefault();
            _href = $(this).attr('href')

            swal({
                    title: "Esta seguro?",
                    text: "Se Procesara esta nota de remision  y ya no  podra editar:",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Procesar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    processData(_href)
                    // window.location = _href
                });

        })



        var select2 = function() {


            $('body .select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple: false,
                width: '90%'
            });

        }


        $('.btn-delete').click(function(_evt) {
            _evt.preventDefault();

            var _href = $(this).attr('href')
            var _id = $(this).attr('id')


            swal({
                    title: "Esta seguro?",
                    text: "Se eliminara la nota de remision Num:" + _id,
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    window.location = _href
                });

        })





        $('.btn-create').click(function() {
            $('.modal-create').modal('show')
            select2()
        })



        $('body .btn-edit').on('click', function() {
            var id = $(this).attr('id')


            $.ajax({
                url: './libros/' + id + '/edit',
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error: function() {
                    alert('ocurrio un error')
                }
            })
        })
    })
</script>
@stop


@endsection