@extends('layouts.admin')
@section('styles')


@stop

@section('title')IMPRIMIR REMISION @stop
@section('titulo')IMPRIMIR REMISION @stop

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('/notas-remision?mes='.$remision->fecha->month.'&anio='.$remision->fecha->year)}}">Notas de Remision</a></li>
    </ol>
@stop
@section('content')




    @include('almacen.partials.notaremision')

@section('scripts')
    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>

        function alerta(id)
        {
            $.ajax({
                url:'./libros/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }

        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#myPrintArea').printArea();


        }



        $(document).ready(function(){

            $('.btn-anular').click(function(_evt){
                _evt.preventDefault();
                let _href=$(this).attr('href')
                let _id=$(this).attr('id')
                swal({
                        title: "Esta seguro?",
                        text: "Se anulara la Remision Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Anular!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        $.ajax({
                            url: '/notas-remision/' + _id + '/validar-anular',
                            method: 'get',
                            dataType: 'json',
                            success: function (res) {
                                if (res.status) {

                                    swal('Alerta', 'No se puede anular la nota. Existen items  asociados a otras notas', 'warning')

                                }
                                else {
                                    window.location = _href

                                }

                            },
                            error: function () {
                                alert('Ocurrio un error en el servidor')
                            }
                        })



                    });


            });

            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
                let url=$(this).attr('href')
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'HTML',
                    async:false,
                    cache:false,
                    success:function(res)
                    {

                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').html(res)
                        $('.modal-ver').modal('show')

                    }
                })
            });

            $('.btn-procesar').click(function(_evt){
                _evt.preventDefault();
                _href=$(this).attr('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se Procesara esta nota de remision  y ya no  podra editar:",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).attr('href')
                var _id=$(this).attr('id')


                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la nota de remision Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })



            $('body .btn-edit').on('click',function(){
                var id=$(this).attr('id')


                $.ajax({
                    url:'./libros/'+id+'/edit',
                    method:'GET',
                    dataType:'html',
                    success:function(res){
                        $('.modales').empty();
                        $('.modales').append(res)
                        $('.modal-edit').modal('show')
                        select2();
                    },
                    error:function(){
                        alert('ocurrio un error')
                    }
                })
            })
        })


    </script>
@stop


@endsection