@extends('layouts.admin')
@section('title')INGRESO @stop
@section('titulo')NOTAS DE INGRESO @stop
@section('menu-ingreso')active open @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    <a href="{{url('notas-ingreso/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo Ingreso</a>


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacen</li>
        <li class="breadcrumb-item active"><a href="{{url('/notas-ingreso')}}">Notas de Ingreso</a></li>
    </ol>
@stop
@section('content')

    <div class="nav navbar-nav float-xs-right">
        <form class="form-inline pull-right" method="get" action="{{url('notas-ingreso')}}" >
            @include('includes.form-periodo')
            <div class="form-group form-material">
                <button type="submit" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>

    <div class="table-responsive">

        <table  id="table"  class=" data-table table table-hover  table-striped " >
            <thead>
            <tr>
                {{--<th>FECHA <br> REGISTRO</th>--}}
                <th>FECHA </th>
                <th>NUMERO</th>
                <th>PROCEDENCIA</th>
                <th>CONCEPTO</th>
                {{--<th>RECIBE</th>--}}
                <th>ESTADO</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($datos as $f=>$r)
                <tr>
                    <td>{{$r->fecha->format('d/m/Y')}}</td>
                    <td width="1%">{{$r->id}}</td>
{{--                    <td>{{$r->created_at->format('d/m/Y H:i:s')}}</td>--}}
                    <td >{{$r->envia}}</td>
{{--                    <td >{{$r->recibe}}</td>--}}
                    <td >{{$r->concepto}}</td>
                    <td>{{$r->estado}}</td>
                    <td>
                        @if($r->estado=='CREADO')
                            <a a href="notas-ingreso/{{$r->id}}/editar" class=" btn  btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                            <a href="notas-ingreso/{{$r->id}}/delete" id="{{$r->id}}"  class="btn-delete btn  btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                            <a href="notas-ingreso/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-success on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>
                        @endif
                        <a href="notas-ingreso/{{$r->id}}/ver" class="btn-ver btn btn-icon btn-pure btn-primary on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Nota"><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                            @if($r->estado=='PROCESADO')
                                <a href="notas-ingreso/{{$r->id}}/anular" id="{{$r->id}}" class="btn-anular btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="anular"><i class="icon md-block" aria-hidden="true"></i></a>

                            @endif

                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true"
         aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">

                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
@section('scripts')

    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>
        function imprimirNota(id){
            let url='notas-ingreso/'+id+'/ver';
            $.ajax({
                url:url,
                method:'GET',
                dataType:'html',
                success:function(res)
                {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').html(res)
                    $('.modal-ver').modal('show')
                }
            })

        }

        function alerta(id)
        {
            $.ajax({
               url:'./libros/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }
        // function printDiv() {
        //     var printContents = document.getElementById('nota').innerHTML;
        //     var originalContents = document.body.innerHTML;
        //     document.body.innerHTML = printContents;
        //     window.print();
        //     document.body.innerHTML = originalContents;
        // }
        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#nota').printArea(options);
        }



        $(document).ready(function(){
            @if(isset($imprimir) && $imprimir)
            imprimirNota({{$id_nota}})
            @endif


            $('.btn-anular').click(function(_evt){
                _evt.preventDefault();
                let _href=$(this).attr('href')
                let _id=$(this).attr('id')

                swal({
                        title: "Esta seguro?",
                        text: "Se anulara la nota de Ingreso Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Anular!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        window.location=_href

                    });


            });

            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
                let url=$(this).attr('href')
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            });

            $('.btn-procesar').click(function(_evt){
                _evt.preventDefault();
                _href=$(this).attr('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se Procesara esta nota de ingreso  y ya no  podra editar.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).attr('href')
                var _id=$(this).attr('id')


                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la nota de ingreso  Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })



            $('body .btn-edit').on('click',function(){
                var id=$(this).attr('id')


                $.ajax({
                   url:'./libros/'+id+'/edit',
                    method:'GET',
                    dataType:'html',
                    success:function(res){
                        $('.modales').empty();
                        $('.modales').append(res)
                        $('.modal-edit').modal('show')
                        select2();
                    },
                    error:function(){
                        alert('ocurrio un error')
                    }
                })
            })
        })


    </script>
@stop


@endsection