@extends('layouts.admin')
@section('title') PROCESAR DEVOLUCION @stop
@section('titulo') CREAR NOTA DE INGRESO  @stop
{{--@section('libros-opcion')active  @stop--}}

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('almacen/devolucion-cobranza')}}">Devolucion Obras</a></li>
        <li class="breadcrumb-item active">Procesar Devolucion
        </li>

    </ol>
@stop
@section('content')


    <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('almacen/devolucion-cobranza/ingreso/store')}}" class="form col-lg-10">
        {!! csrf_field() !!}


        <hr>
        <h4 class="alert alert-primary">NOTA DE INGRESO</h4>
        <input type="hidden" name="devolucion_id" value="{{$devolucion->id}}">
        <input type="hidden" name="numcontrato" value="{{$devolucion->contrato->numcontrato}}">
        <input type="hidden" name="contrato_id" value="{{$devolucion->contrato->id}}">

        <div class="form-group  col-md-3">
            <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA  DE INGRESO</strong></label>
            <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                <input  name="fecha" readonly  value="{{$devolucion->fecha->format('d/m/Y')}}"style="font-size: 16px; font-weight: bold;"  type="text" class=" datepicker2 password-strength-example2 form-control strength-input"  >
            </div>

        </div>
        <div class=" form-group form-row">
            <div class="col-md-3">

            <label   class="form-control-label" for=""><strong>GLOSA</strong></label>
            <input  name="glosa" value=""  type="text" class=" glosa form-control strength-input"  >
            </div>
            <div class="col-md-6">
                <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                <textarea name="obs" class="form-control" id=""  placeholder="Observacion" rows="2"></textarea>
            </div>
        </div>


        <hr>
        <div class="visible" >
            <table class="table table-detalle">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Cantidad</th>
                    <th>Codigo</th>
                    <th>Titulo</th>
                    <th>Tomo</th>
                    <th>P.U.</th>
                    <th>P.T.</th>
                <th>Observacion{{$devolucion->id}}</th>

                </tr>
                </thead>
                <tbody>
                @php $cont=0 @endphp
                @foreach($devolucion->detalle as $k=>$d)
                    @if($d->sw==1)
                        <tr>

                            <td>{{$cont+1}}</td>
                            <td class=" text-center">{{$d->cantidad}}</td>
                            <td ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                            <td>{{$d->titulo}}</td>
                            <td>{{$d->volumen}}</td>
                            <td>{{$d->precio_unitario}}</td>
                            <td>{{$d->precio_total}}</td>
                            <td>
                                <input type="text" size="27%" name="ingreso_obs_detalle[]" value=""/>
                                <input type="hidden" name="ingreso_detalle_cantidad[]" value="{{$d->cantidad}}">
                                <input type="hidden" name="ingreso_detalle_codigo[]" value="{{$d->codigo}}">
                                <input type="hidden" name="ingreso_detalle_titulo[]" value="{{$d->titulo}}">
                                <input type="hidden" name="ingreso_detalle_volumen[]" value="{{$d->volumen}}">
                                <input type="hidden" name="ingreso_detalle_libro_id[]" value="{{$d->libro_id}}">
                                <input type="hidden" name="ingreso_detalle_preciounitario[]" value="{{$d->precio_unitario}}">
                                <input type="hidden" name="ingreso_detalle_preciototal[]" value="{{$d->precio_total}}">
                            </td>


                        </tr>
                        @php $cont++; @endphp
                    @endif
                @endforeach



                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td><input  value="{{$devolucion->detalle->where('sw',0)->sum('cantidad')}}"   type="text" name="ingreso_cant_total"  size="5%" class="cant_total" readonly></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td><input  value="{{$devolucion->detalle->where('sw',0)->sum('precio_total')}}"   type="text" name="ingreso_precio_total"  size="5%" class="cant_total" readonly></td>
                    </tr>
                </tfoot>
            </table>



            <div class="form-group form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('almacen/devolucion-cobranza')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
        </div>
    </form>

@section('scripts')

    <script>




        $(document).ready(function(){




            $('.datepicker2').datepicker({
                language: 'es',
                autoclose:true,
                format:'dd/mm/yyyy',
                showOn: "button",
                clearBtn:true,

                buttonText: '<i class="fa fa-calendar"></i>',

            });


            $('.btn-guardar').click(function(_evt){
                _evt.preventDefault();
                if($('.datepicker2').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning')

                    return false;
                }
                if($('.glosa').val()==''){
                    swal('Alerta','Debe ingresar una glosa','warning')

                    return false;
                }
                 _fecha=$('.datepicker2').val()
         
         $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha,modulo:'ALMACEN'},
             dataType:'json',
             method:'GET',
             async:false,
          

         }).done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                        return false;
                        
                    }      
                    else{
                 swal({
                

                swal({
                        title: "Procesar la devolucion cobranza",
                        text: "Se pocesara la devolucion de cobranza y se registrara la nota de Ingreso. Esta Seguro?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('.form').submit();
                    });
                     }
         }).fail(function(){
             alert('exisitio un error')
         })


            })


            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let id =$('.select3').find(":selected").val()
                let stock =$('.stock').val()
                let cantidad=$('.cantidad').val()
                if(parseInt(cantidad)<=0 || (parseInt(cantidad)>parseInt(stock))){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;

                }

                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if($('.vendedor').val()=='')
                {
                    swal('Alerta','Es necesario seleccionar un vendedor','warning')

                    return false
                }
                if($('.credito').val()=='' || parseInt($('.credito').val())<=0)
                {
                    swal('Alerta','El vendedor no cuenta con suficiente stock','warning')

                    return false
                }
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad
                }

                addFila(datos)
                $('.select3').select2('open');


            })





        })
    </script>
@stop


@endsection