@extends('layouts.admin')
@section('title') PROCESAR CAMBIO OBRA @stop
@section('titulo') CREAR NOTA DE INGRESO Y EGRESO @stop
{{--@section('libros-opcion')active  @stop--}}

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('almacen/cambio-obra')}}">Cambio de  Obras</a></li>
        <li class="breadcrumb-item active">Procesar Cambio de Obra
        </li>

    </ol>
@stop
@section('content')


    <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('almacen/cambio-obra/procesar')}}" class="form  row">
        {!! csrf_field() !!}
        <input type="hidden" name="cambio_id" value="{{$cambio->id}}">
        <input type="hidden" name="credito_id" value="{{$cambio->credito_id}}">
        <hr>
        <div class=" col-md-6 div-ingreso" >
        <h4 class="alert alert-primary">NOTA DE INGRESO</h4>


        <div class=" form-group form-row">
            <div class="form-group  col-md-3">
                <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA  DE INGRESO</strong></label>
                <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                    <input  name="ingreso_fecha" readonly  value="{{$cambio->fecha->format('d/m/Y')}}"style="font-size: 16px; font-weight: bold;"  type="text" class=" datepicker2 password-strength-example2 form-control strength-input"  >
                </div>

            </div>
            <div class="col-md-3">

                <label   class="form-control-label" for=""><strong>ENVIA</strong></label>
                <input  name="ingreso_envia" value=""  type="text" class=" form-control strength-input"  >
            </div>
            <div class="col-md-3">

                <label   class="form-control-label" for=""><strong>GLOSA</strong></label>
                <input  name="ingreso_glosa" value=""  type="text" class=" glosa form-control strength-input"  >
            </div>
            <div class="col-md-12">
                <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                <textarea name="ingreso_obs" class="form-control" id=""  placeholder="Observacion" rows="2"></textarea>
            </div>
        </div>


        <hr>

            <table class="table table-detalle">
                <thead>
                <tr>

                    <th>Codigo</th>
                    <th>Titulo</th>
                    <th>Cantidad</th>
                    <th>P.U.</th>
                    <th>P.T.</th>
                    <th>Observacion</th>

                </tr>
                </thead>
                <tbody>

                @foreach($cambio->detalle_ingresos as $k=>$d)
                        <tr>


                            <td ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                            <td>{{$d->titulo}}</td>
                            <td class=" text-center">{{$d->cantidad}}</td>
                            <td>{{$d->precio_unit}}</td>
                            <td>{{$d->precio_total}}</td>
                            <td>
                                <input type="text" size="10%" name="ingreso_obs_detalle[]" value=""/>
                                <input type="hidden" name="ingreso_detalle_cantidad[]" value="{{$d->cantidad}}">
                                <input type="hidden" name="ingreso_detalle_codigo[]" value="{{$d->codigo}}">
                                <input type="hidden" name="ingreso_detalle_titulo[]" value="{{$d->titulo}}">
                                <input type="hidden" name="ingreso_detalle_libro_id[]" value="{{$d->libro_id}}">
                                <input type="hidden" name="ingreso_detalle_preciounitario[]" value="{{$d->precio_unit}}">
                                <input type="hidden" name="ingreso_detalle_preciototal[]" value="{{$d->precio_total}}">
                            </td>


                        </tr>

                @endforeach



                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td></td>
                    <td align="center">{{$cambio->detalle_ingresos->sum('cantidad')}}</td>
                    <td></td>
                    <td>{{$cambio->detalle_ingresos->sum('precio_total')}}</td>
                    <td></td>

                </tr>
                </tfoot>
            </table>


        </div>
        <div class=" col-md-6 div-egreso" >
            <h4 class="alert alert-primary">NOTA DE EGRESO</h4>
            <input type="hidden" name="cambio_id" value="{{$cambio->id}}">
            <input type="hidden" name="credito_id" value="{{$cambio->credito_id}}">


            <div class=" form-group form-row">
                <div class="form-group  col-md-4">
                    <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA  DE EGRESO</strong></label>
                    <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                        <input  name="egreso_fecha" readonly  value="{{$cambio->fecha->format('d/m/Y')}}"style="font-size: 16px; font-weight: bold;"  type="text" class=" datepicker2 password-strength-example2 form-control strength-input"  >
                    </div>

                </div>
                <div class="col-md-3">

                    <label   class="form-control-label" for=""><strong>RECIBE</strong></label>
                    <input  name="egreso_recibe" value=""  type="text" class=" form-control strength-input"  >
                </div>
                <div class="col-md-12">
                    <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                    <textarea name="egreso_obs" class="form-control" id=""  placeholder="Observacion" rows="2"></textarea>
                </div>
            </div>


            <hr>

            <table class="table table-detalle">
                <thead>
                <tr>

                    <th width="15%">Codigo </th>
                    <th width="50%" class="col-md-8">Titulo</th>
                    <th>Cant</th>
                    <th>P.U.</th>
                    <th>P.T.</th>
                    <th width="5%">Observacion</th>

                </tr>
                </thead>
                <tbody>

                @foreach($cambio->detalle_egresos as $k=>$d)
                    <tr>


                        <td width="10%" ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                        <td>{{$d->titulo}}</td>
                        <td class=" text-center">{{$d->cantidad}}</td>
                        <td>{{$d->precio_unit}}</td>
                        <td>{{$d->precio_total}}</td>
                        <td>
                            <input type="text" size="10%" name="egreso_obs_detalle[]" value=""/>
                            <input type="hidden" name="egreso_detalle_cantidad[]" value="{{$d->cantidad}}">
                            <input type="hidden" name="egreso_detalle_codigo[]" value="{{$d->codigo}}">
                            <input type="hidden" name="egreso_detalle_titulo[]" value="{{$d->titulo}}">
                            <input type="hidden" name="egreso_detalle_libro_id[]" value="{{$d->libro_id}}">
                            <input type="hidden" name="egreso_detalle_preciounitario[]" value="{{$d->precio_unit}}">
                            <input type="hidden" name="egreso_detalle_preciototal[]" value="{{$d->precio_total}}">
                        </td>


                    </tr>

                @endforeach



                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td></td>
                    <td align="center">{{$cambio->detalle_egresos->sum('cantidad')}}</td>
                    <td></td>
                    <td>{{$cambio->detalle_egresos->sum('precio_total')}}</td>
                    <td></td>

                </tr>
                </tfoot>
            </table>
        </div>
            <div class="form-group  col-md-12 form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('almacen/cambio-obra')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
    </form>

@section('scripts')

    <script>




        $(document).ready(function(){




            $('.datepicker2').datepicker({
                language: 'es',
                autoclose:true,
                format:'dd/mm/yyyy',
                showOn: "button",
                clearBtn:true,

                buttonText: '<i class="fa fa-calendar"></i>',

            });


            $('.btn-guardar').click(function(_evt){
                _evt.preventDefault();
                if($('.datepicker2').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning')

                    return false;
                }
                if($('.glosa').val()==''){
                    swal('Alerta','Debe ingresar una glosa','warning')

                    return false;
                }

                swal({
                        title: "Procesar Cambio de Obra",
                        text: "Revise bien todos los campos y fechas antes de procesar.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('.form').submit();
                    });


            })


            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let id =$('.select3').find(":selected").val()
                let stock =$('.stock').val()
                let cantidad=$('.cantidad').val()
                if(parseInt(cantidad)<=0 || (parseInt(cantidad)>parseInt(stock))){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;

                }

                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if($('.vendedor').val()=='')
                {
                    swal('Alerta','Es necesario seleccionar un vendedor','warning')

                    return false
                }
                if($('.credito').val()=='' || parseInt($('.credito').val())<=0)
                {
                    swal('Alerta','El vendedor no cuenta con suficiente stock','warning')

                    return false
                }
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad
                }

                addFila(datos)
                $('.select3').select2('open');


            })
        })
    </script>
@stop


@endsection