<?php $__env->startSection('title'); ?> Nota Remision <?php $__env->stopSection(); ?>
<?php $__env->startSection('titulo'); ?>CREAR NOTA DE REMISION <?php $__env->stopSection(); ?>
<?php $__env->startSection('menu-remision'); ?>active open <?php $__env->stopSection(); ?>

<?php $__env->startSection('acciones'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('descripcion'); ?>
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Inicio</a></li>
    <li class="breadcrumb-item ">Almacenes</li>
    <li class="breadcrumb-item active"><a href="<?php echo e(url('notas-remision')); ?>">Nota de Remision</a></li>
    <li class="breadcrumb-item active">Registrar Nota de Remision</a></li>

</ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<form style="border: 1px solid" autocomplete="off" method="post" action="<?php echo e(url('notas-remision/store')); ?>" class="form col-lg-10">
    <?php echo csrf_field(); ?>

    <?php if(isset($remision)): ?>
    <input type="hidden" name="id" value="<?php echo e($remision->id); ?>">
    <?php endif; ?>
    <div class="row d-flex">
    <div class="form-group  col-md-3">
        <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA</strong></label>
        <div class="input-group">
            <span class="input-group-addon">
                <i class="icon md-calendar text-danger" aria-hidden="true"></i>
            </span>
            <input name="fecha" required readonly style="font-size: 16px; font-weight: bold;" value="<?php if(isset($remision)): ?> <?php echo e($remision->fecha->format('d/m/Y')); ?> <?php else: ?> <?php echo e(date('d/m/Y')); ?> <?php endif; ?>" type="text" class=" datepicker password-strength-example2 form-control strength-input">

            
        </div>


    </div>
    <div class="form-group  col-md-3">

    <a href="<?php echo e(url('common/regularizacion-inventario')); ?>"class="mt-4 btn btn-success">Regularizar Inventario</a>
    </div>
</div>

    <div class="form-row">
        <div class=" form-group col-md-4">
            <label class="form-control-label"><strong>VENDEDOR</strong></label>
            <select name="vendedor_id" class=" vendedor form-control select2">
                <option value="">Seleccione</option>
                <?php $__currentLoopData = $vendedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option credito="<?php echo e($r->credito_disponible); ?>" <?php if(isset($remision) && $remision->vendedor_id==$r->id): ?> selected <?php endif; ?> value="<?php echo e($r->id); ?>"><?php echo e($r->nombre_completo); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class=" form-group col-md-1">
            <label class="form-control-label" for=""><strong>CREDITO</strong></label>
            <input readonly type="text" <?php if(isset($remision)): ?> value="<?php echo e(($remision->vendedor->credito)-$remision->cant_total); ?> <?php endif; ?>" class="credito form-control">
        </div>
        <div class=" form-group col-md-6">
            <label class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
            <textarea name="obs" class="form-control" id="" placeholder="Observacion" rows="2"><?php if(isset($remision)): ?> <?php echo e($remision->obs); ?> <?php endif; ?></textarea>
        </div>

    </div>

    <div class="form-row" style="border-top:1px solid">
        <div class=" form-group col-md-7 col-sm-12">
            <label class="form-control-label "><strong>CODIGO</strong></label>
            <select id="select3" name="libro_id" class="form-control select3">
                <option value="">Seleccione</option>
                <?php $__currentLoopData = $libros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option stock="<?php echo e($r->stock); ?>" codigo="<?php echo e($r->codigo); ?>" titulo="<?php echo e($r->titulo); ?>" tomo="<?php echo e($r->tomo); ?>" value="<?php echo e($r->id); ?>"><strong><?php echo e($r->codigo); ?> - </strong><?php echo e($r->titulo); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class=" form-group col-md-1 col-sm-3 col-xs-3">
            <label class="form-control-label" for=""><strong>STOCK</strong></label>
            <input readonly type="text" class="stock limpiar  form-control">
        </div>
        <div class=" form-group col-md-2 col-sm-4 col-xs-4">
            <label class="form-control-label" for=""><strong>CANTIDAD</strong></label>
            <input type="number" step="1" id="cantidad" class="cantidad limpiar solo-enteros form-control">
        </div>
        <div class=" form-group col-md-1 col-sm-1">
            <label class="form-control-label" for="">&nbsp;</label>
            <button type="button" class=" btn-add btn    btn-outline-success "><i class="icon md-plus"></i> Adicionar</button>
        </div>

    </div>
    <hr>
    <div class="visible" <?php if(!isset($remision)): ?> style="display: none" <?php endif; ?>>
        <table class="table table-detalle">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Cantidad</th>
                    <th>Codigo</th>
                    <th>Titulo</th>
                    <th>Tomo</th>
                    <th>Observacion</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if(isset($remision)): ?>
                <?php $__currentLoopData = $remision->detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td><?php echo e($k+1); ?></td>
                    <td class=" text-left"><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="<?php echo e($d->cantidad); ?>"></td>
                    <td><strong class="td-codigo"><?php echo e($d->codigo); ?></strong></td>
                    <td><?php echo e($d->titulo); ?></td>
                    <td><?php echo e($d->volumen); ?></td>
                    <td><input type="text" size="27%" name="observacion[]" value="<?php echo e($d->obs); ?>" /><input type="hidden" name="libro_id[]" value="<?php echo e($d->libro_id); ?>"></td>
                    <td><button type="button" class="brn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i>Borrar</button></td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endif; ?>

            </tbody>
            <tfoot>
                <tr>
                    <th>Total</th>
                    <td><input <?php if(isset($remision)): ?> value="<?php echo e($remision->cant_total); ?>" <?php endif; ?> type="text" name="cant_total" size="5%" class="cant_total" readonly></td>
                </tr>
            </tfoot>
        </table>



        <div class="form-group form-material">
            <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
            <a href="<?php echo e(url('notas-remision')); ?>" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
        </div>
    </div>
</form>

<?php $__env->startSection('scripts'); ?>

<script>
    var codigos = []

    function buscarCodigo(codigo) {
        var sw = false;
        if (codigos.indexOf(codigo) != -1)
            sw = true;
        return sw;
    }

    function numerosTabla() {
        var cant = 0;
        $('.table-detalle tbody tr').each(function(k, v) {

            $(v).find('td:first').html(k + 1)
            cant += parseInt($(v).find('.td-cant').val())


        });
        return cant
    }

    function limpiar() {
        $('.limpiar').val('')
        $('#select3').val('').trigger('change');
        $('#select3').focus()



    }

    function addFila(datos) {
        var fila = '<tr>';
        fila += '<td></td><td class=" text-left   "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="' + datos.cantidad + '"></td><td ><strong class="td-codigo" ">' + datos.codigo + '</strong></td>' +
            '<td>' + datos.titulo + '</td><td>' + datos.tomo + '<td><input type="text" size="27%" name="observacion[]"/><input type="hidden" name="libro_id[]" value="' + datos.id + '"></td>' +
            '<td><button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button></td>' +
            '</tr>';



        $('.table-detalle tbody').append(fila)
        codigos.push(datos.codigo)

        var _credito = (parseInt($('.credito').val()) - parseInt(datos.cantidad));
        $('.credito').val(_credito)
        limpiar();
        $('.visible').show()
        $('.cant_total').val(numerosTabla())
        // console.log(datos)
    }


    function remove(btn) {

        // limpiar();
        let codigo = $(btn).closest('tr').find('.td-codigo').html()
        let cant = $(btn).closest('tr').find('.td-cant').val()
        $(btn).closest('tr').remove()
        _cantfilas = $('.table-detalle tbody tr').length;
        if (_cantfilas <= 0) {
            $('.visible').hide();
        }

        var _credito = (parseInt($('.credito').val()) + parseInt(cant));
        $('.credito').val(_credito)
        $('.cant_total').val(numerosTabla)
        borrarArray(codigo)

    }

    function borrarArray(valor) {
        var index = codigos.indexOf(valor);
        if (index > -1) {
            codigos.splice(index, 1);
            return true;
        }
        return false;

    }

    $(document).ready(function() {
        $("#cantidad").keypress(function(e) {
            if (e.which == 13) {
                $(".btn-add").trigger("click");
            }
        });

        <?php if(isset($remision)): ?>
        $('.table-detalle tbody tr').each(function(k, v) {

            let codigo = $(v).find('.td-codigo').html()
            codigos.push(codigo)
        });
        <?php endif; ?>


        $('.btn-guardar').click(function(_evt) {
            _evt.preventDefault();
            if ($('.datepicker').val() == '') {
                swal('Alerta', 'Debe seleccionar una Fecha', 'warning')

                return false;
            }

            _fecha = $('.datepicker').val()

            $.ajax({
                url: "<?php echo e(url('common/validar-cierre')); ?>",
                data: {
                    fecha: _fecha,
                    modulo: 'ALMACEN'
                },
                dataType: 'json',
                method: 'GET',
                async: false,


            }).done(function(res) {
                if (!res) {
                    swal('Alerta', 'No esta permitido registrar en la fecha seleccionada', 'warning')
                    return false;

                } else {
                    swal({
                            title: "Guardar nota de remision",
                            text: "Revise que todos los campos esten llenados correctamente.",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonClass: "btn-success",
                            confirmButtonText: "Si, Guardar!",
                            cancelButtonText: "Cancelar",
                            closeOnConfirm: false
                        },
                        function() {
                            $('form').submit();
                        });
                }
            }).fail(function() {
                alert('exisitio un error')
            })

        })


        $('.btn-add').click(function(_evt) {
            let titulo = $('.select3').find(":selected").attr("titulo")
            let codigo = $('.select3').find(":selected").attr("codigo")
            let tomo = $('.select3').find(":selected").attr("tomo")
            let id = $('.select3').find(":selected").val()
            let stock = $('.stock').val()
            let cantidad = $('.cantidad').val()
            if (parseInt(cantidad) <= 0 || (parseInt(cantidad) > parseInt(stock))) {
                swal('Alerta', 'No hay suficiente stock', 'warning')
                return false;

            }

            if (buscarCodigo(codigo)) {
                swal('Alerta', 'Este codigo ya se encuentra registrado', 'warning')
                return false;
            }
            if ($('.vendedor').val() == '') {
                swal('Alerta', 'Es necesario seleccionar un vendedor', 'warning')

                return false
            }
            if ($('.credito').val() == '' || parseInt($('.credito').val()) <= 0 || parseInt(cantidad) > parseInt($('.credito').val())) {
                swal('Alerta', 'El vendedor no cuenta con  credito suficiente ', 'warning')

                return false
            }
            let datos = {
                titulo: titulo,
                codigo: codigo,
                tomo: tomo,
                id: id,
                cantidad: cantidad
            }

            addFila(datos)

            $('.select3').select2('open');

        })

        $('.select2').on('select2:selecting', function(e) {

            let cant = numerosTabla()

            let credito = e.params.args.data.element.attributes.credito.value;
            if (parseInt(credito) < parseInt(cant)) {
                swal('Alerta', 'El vendedor no cuenta con credito suficiente para asignarle items', 'warning')

                return false;
            }


            if (parseInt(credito) <= 0 || credito == '' || typeof(credito) == 'undefined') {
                $('.credito').val(0)
            } else {
                $('.credito').val(credito)
            }

        });
        $('.select3').on('select2:selecting', function(e) {

            // let stock =e.params.args.data.element.attributes.stock.value;
            let codigo = e.params.args.data.element.attributes.codigo.value;

            $.ajax({
                url: '<?php echo e(url("common/get-stock")); ?>',
                method: 'get',
                dataType: 'json',
                data: {
                    codigo: codigo
                }

            }).then((stock) => {
                $('.stock').val(stock)

            }).catch((error) => {
                alert('ocurrio un error')
            })



            // if(parseInt(stock)<=0 || stock=='' || typeof(stock)=='undefined'){
            //     $('.stock').val(0)
            // }
            // else{
            //     $('.stock').val(stock)
            // }
        });
        $('.select3').on('select2:select', function(e) {

            $('#cantidad').focus();

        });

        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple: false,
            width: '90%'
        });
        $('.select3').select2({
            placeholder: 'Seleccione una opcion',
            multiple: false,
            width: '90%'
        });

        var select2 = function() {


            $('body .select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple: false,
                width: '90%'
            });

        }




    })
</script>
<?php $__env->stopSection(); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\libros\resources\views/almacen/remision/create_edit.blade.php ENDPATH**/ ?>