@extends('layouts.admin')
@section('title') Produccion Mensual  @stop
@section('titulo') PRODUCCION MENSUAL @stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('/reportes-ventas')}}">Reportes</a></li>
        <li class="breadcrumb-item active">PRODUCCION MENSUAL</li>
    </ol>
@stop
@section('content')



    <div class="nav navbar-nav float-xs-right">
        <form class="form-inline pull-right" method="get" action="{{url('reportes-ventas/produccion-mensual')}}" >
            @include('includes.form-periodo')
            <div class="form-group form-material">
                <button type="submit" name="consulta"  value="consulta" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>
    @if(count($datos)>0)
        <hr>
        <div class="nav navbar-nav float-xs-right">
            <form class="form-inline pull-right" method="post" action="{{url('reportes-ventas/produccion-mensual')}}" >
                {!! csrf_field() !!}

                <input type="hidden" name="mes" value="{{$mes}}">
                <input type="hidden" name="anio" value="{{$anio}}">
                <button name="tipoexportacion" value="excel" class="btn btn-outline-success">EXCEL</button>
                <button name="tipoexportacion" value="pdf" class="btn btn-outline-danger">PDF</button>
            </form>
        </div>
    @endif

    <div class="table-responsive">

        @if(count($datos)>0)
            @include('ventas.reportes.produccion_mensual.tabla')
        @else
            <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>
        @endif
    </div>



@section('scripts')

    <script>

        $(document).ready(function() {


        })
    </script>
@stop


@endsection