@extends('layouts.admin') 
@section('title') Diferidos 
@stop 
@section('titulo') CONTRATOS DIFERIDOS 
@stop {{-- 
@section('libros-opcion')active

@stop--}} 
@section('acciones')
<a href="#modalVendedor" data-toggle="modal" class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>Registrar Contrato</a>
@stop 
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Ventas</li>
    <li class="breadcrumb-item active"><a href="{{url('/diferidos')}}">Contratos Diferidos</a></li>
</ol>




@stop 
@section('content')
    @include('includes.modal-ver')

<div class="col-md-12 nav navbar-nav ">
    <form class="row col-md-12  " method="get" action="{{url('diferidos')}}">


        <div class=" col-md-2 form-group ">

            <select name="tipo" id="" class=" tipo-filtro form-control">
                    <option value="">Seleccione Filtro</option>
                    <option @if(isset($tipo) && $tipo=='mes') selected @endif value="mes">FILTRO POR MES</option>
                    <option @if(isset($tipo) && $tipo=='rango') selected @endif value="rango">FILTRO POR RANGO DE FECHAS</option>
                    <option @if(isset($tipo) && $tipo=='acumulado') selected @endif value="acumulado">FILTRO ACUMULADO</option>
                </select>
        </div>

        <div class="filtro-mes col-md-3" @if(isset($tipo) && $tipo=='mes' ) style="display:block" @else style="display: none" @endif>
            <div class="input-group ">
                {{--<span class="icon md-calendar"></span></label>--}}
                <select name="mes" class="form-control" id="mes">
                        <option value="1"  @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                        <option value="2"  @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                        <option value="3"  @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                        <option value="4"  @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                        <option value="5"  @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                        <option value="6"  @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                        <option value="7"  @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                        <option value="8"  @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                        <option value="9"  @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                        <option value="10"  @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                        <option value="11"  @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                        <option value="12"  @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                    </select>
                <label class="input-group-addon bg-info" for="date">
                        <span class="">De</span></label>
                <select name="anio" id="anio" class="form-control">
                        @for($i=2016; $i<=2030; $i++)
                            <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
            </div>
            {{--
    @include('includes.form-periodo')--}}
        </div>
        <div class="  filtro-rango" @if(isset($tipo) && $tipo=='rango' ) style="display:block" @else style="display: none" @endif>
            <div class="input-group ">
                {{--<span class="icon md-calendar"></span></label>--}}
                <input @if(isset($fecha_ini) ) value="{{$fecha_ini->format('d/m/Y')}}" @endif readonly name="fecha_ini" type="text" class="datepicker input-group-addon form-control">
                <label class="input-group-addon bg-info" for="date">
                        <span class="">hasta</span></label>
                <input @if(isset($fecha_fin) )value="{{$fecha_fin->format('d/m/Y')}}" @endif readonly name="fecha_fin" type="text" class="datepicker input-group-addon form-control">
            </div>

        </div>
        <div class="filtro-acumulado" @if(isset($tipo) && $tipo=='acumulado' ) style="display:block" @else style="display: none"
            @endif>
            <div class="form-group">

                <input type="text" readonly name="fecha_acumulado" value="{{$fecha_acumulado->format('d/m/Y')}}" class="form-control datepicker">
            </div>

        </div>

        <div class="form-group form-material">
            <button type="submit" name="buscar" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>
</div>

<div class="table-responsive">

    <table id="table" class=" data-table table table-hover  table-striped  table-condensed table-inverse">
        <thead>
            <tr>
                <th>ID</th>
                <th>FECHA <br> CONTRATO</th>
                <th>N°<br>CONTRATO</th>
                <th>TIPO VENTA</th>
                <th>MONTO CONTRATO</th>
                <th>TIPO CONTRATO</th>
                <th>VENDEDOR</th>
                <th>CHOFER</th>
                <th>NOMBRE CLIENTE</th>
                <th>APELLIDOS CLIENTE</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            @foreach($datos as $f=>$r)
           <tr @if(isset($_GET[ 'id']) && $_GET[ 'id']==$r->id) class="bg-info" @endif >

                <td width="1%">{{$r->id}}</td>
                <td width="4%">{{$r->fechacontrato->format('d/m/Y')}}</td>
                <td width="5%">{{$r->numcontrato}}</td>
                <td width="1%">{{$r->tipoventa}}</td>
                <td width="3%">{{$r->preciototal}}</td>
                <td width="1%">{{$r->tipocontrato}}</td>
                <td width="15%">{{$r->vendedor->nombre_completo}}</td>
                <td width="15%">{{$r->chofer->nombre_completo}}</td>
                <td width="10%">{{$r->nombres}}</td>
                <td width="10%">{{$r->apellidos}}</td>
                <td width="20%">
                    <div class="btn-toolbar" role="toolbar">

                    <a href="diferidos/{{$r->id}}/ver" id='{{$r->id}}' class="btn-ver btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Ver Contrato"><i class="icon md-open-in-new" aria-hidden="true"></i></a>                        @if($r->terminado==0)
                        <a href="diferidos/{{$r->id}}/editar" class=" btn  btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                        <a href="diferidos/{{$r->id}}/procesar" id="{{$r->id}}" class="btn-procesar btn btn-icon btn-pure btn-success on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>
                        <a href="diferidos/{{$r->id}}/borrar" id="{{$r->id}}" class="btn-borrar btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Borrar"><i class="icon md-delete" aria-hidden="true"></i></a>                        @endif @if($r->terminado==1 ) @if($r->estado!='ALMACEN')
                        <a href="diferidos/{{$r->id}}/editar" class=" btn  btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>

                        <a href="diferidos/{{$r->id}}/registrarventa" class=" btn  btn-icon btn-pure btn-primary on-default edit-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Registrar venta"><i class="icon md-file-text" aria-hidden="true"></i></a>
                        <a href="diferidos/{{$r->id}}/devolucion-create" id="{{$r->id}}" class="btn-devolucion btn  btn-icon btn-pure btn-dark on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Devolucion Contrato"><i class="icon md-refresh-alt" aria-hidden="true"></i></a>
                        <a href="diferidos/{{$r->id}}/baja" id="{{$r->id}}" class="btn-baja btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Dar de baja contrato"><i class="icon md-block" aria-hidden="true"></i></a>                        @endif

                        <button onclick="cargarModalKardex('contrato',{{$r->id}})" class=" btn-verkardex  btn btn-info btn-icon btn-pure btn-dark on-default remove-row waves-effect waves-light waves-round"
                            data-target="#" data-toggle="modal" type="button">K</button> @endif
                    </div>


                    {{--<a href="notas-ingreso/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round"
                        data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>--}}
                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>
    @include('includes.modal-kardex')

<div class="modalVendedor modal fade modal-slide-in-right" id="modalVendedor" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">

            <div class="modal-body">
                <form action="{{url('diferidos/create')}}" method="get" class="form-contrato ">
                    <div class=" row form-group">
                        <div class="col-md-6">
                            <label for="" class="control-label"><strong>Vendedor</strong></label>
                            <select required name="vendedor" id="" class="select2 vendedor form-control">
                                            <option value="">Seleccione Vendedor</option>
                                            @foreach($vendedores as $v)
                                                <option value="{{$v->id}}">{{$v->nombre_completo}}</option>

                                                @endforeach
                                        </select>
                        </div>
                        <div class="col-md-6">
                            <label for="" class="control-label"><strong>Chofer</strong></label>
                            <select required name="chofer" id="" class="chofer select2 form-control">
                                            <option value="">Seleccione Vendedor</option>
                                            @foreach($vendedores as $v)
                                                <option value="{{$v->id}}">{{$v->nombre_completo}}</option>
                                            @endforeach
                                        </select>
                        </div>

                    </div>

                    <div class=" row form-group">

                        <div class="col-md-4">
                            <label for="" class="control-label"><strong>Num contrato</strong></label>
                            <div class="input-group">

                                <div class="input-group">
                                    <span class="input-group-addon"><span class="icon md-file"></span></span>
                                    <input type="text" name="num_contrato" class="solo-enteros num_contrato form-control" placeholder="Num contrato">
                                </div>

                            </div>

                        </div>
                        <div class="col-md-4">
                            <label for="" class="control-label"><strong>Carnet Cliente</strong></label>

                            <div class="input-group">
                                <span class="input-group-addon"><span class="icon md-account-box"></span></span>
                                <input type="text" name="num_carnet" placeholder="Carnet cliente" class="num_carnet form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="" class="control-label"><strong>Fecha Contrato</strong></label>
                            <div class="input-group">
                                <span class="input-group-addon"><span class="icon md-calendar"></span></span>
                                <input type="text" name="fecha" value="{{date('d/m/Y')}}" readonly placeholder="Fecha Contrato" class=" fecha datepicker form-control">
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <button type="submit" class="btn-registrar btn btn-outline-primary btn-block">Registrar</button>
                        <button data-dismiss="modal" class="btn btn-default btn-block">Cancelar</button>
                    </div>

                </form>

            </div>

        </div>
    </div>
</div>

<div class="modal-recibo  modal-primary modal fade fade modal-3d-flip-horizontal show" id="modalVendedor" aria-hidden="true"
    role="dialog">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title"><i class="icon md-wrench"></i> PROCESAR CONTRATO</h4>
                <h6 class="modal-title"></h6>
            </div>

            <div class="modal-body">
                <br>
                <form action="{{url('diferidos/procesar-diferido')}}" method="post" class="form-procesar">
                    {!! csrf_field() !!}
                    <input type="hidden" name="contrato_id" class="contrato-id-diferido">
                    <button class="btn btn-success btn-block btn-procesar-diferido">PROCESAR EL CONTRATO COMO DIFERIDO</button>
                </form>
                <br>

                <button class="btn btn-primary btn-block btn-cuota-ini ">PROCESAR EL CONTRATO COMO VENTA</button>
                <form action="{{url('diferidos/procesar-venta-post')}}" method="POST" style="display: none" class="form-cuota-inicial">
                    <p class="text text-info"><i class="icon md-alert-circle-o"></i> UNA VEZ PROCESADO EL CONTRATO PASARA DE DIFERIDO A CONTRATO DE
                        VENTA.
                    </p>
                    {!! csrf_field() !!}
                    <input type="hidden" name="contrato_id" class="contrato_id">
                    <div class=" row form-group">
                        <div class="col-md-3">
                            <label for="" class="" style="font-size: 0.8em;">M. CUOTA INICIAL</label>
                            <input type="text" name="montoventa" required readonly class="form-control monto-cuota-inicial">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label" style="font-size: 0.8em;">TIPO DOCUMENTO</label>
                            <select name="tipodocventa" id="tipodocventa" class="form-control">
                                <option value="RECIBO" >RECIBO</option>
                                <option value="FACTURA">FACTURA</option>

                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="" class="" style="font-size: 0.8em;">N° RECIBO</label>
                            <input type="text" name="numero" required class="form-control  numero-documento">

                        </div>
                        <div class="col-md-3">
                            <label for="" style="font-size: 0.8em;">NUMERO DE REPORTE</label>
                            <input type="text" name="num_reporte" required class="form-control numero-reporte">

                        </div>

                        <div class="col-md-3">
                            <label for="" style="font-size: 0.8em;">FECHA DE LA VENTA</label>
                            <input type="text" required name="fechaventa" class=" fecha-de-venta form-control datepicker">
                        </div>

                        <div class="col-md-6">
                            <label for="" class="control-label" style="font-size: 0.8em;">NOMBRES</label>
                            <input type="text" name="nombres" required class="form-control nombres  ">

                        </div>
                        <div class="col-md-3">
                            <label for="" class="control-label" style="font-size: 0.8em;">NUMERO CARNET</label>
                            <input type="text" name="ci" required class="form-control carnet ">

                        </div>
                        <div class="col-md-12">
                            <label for="" class="control-label" style="font-size: 0.8em;">OBSERVACION</label>
                            <textarea name="" class="form-control" id="" rows="2"></textarea>

                        </div>

                    </div>


                    <div class="form-group">
                        <button type="submit" class="btn-registrar-cuota  btn btn-outline-primary btn-block"><i class="icon md-check"></i> PROCESAR CONTRATO COMO VENTA</button>
                        <button class="btn-cancelar-cuota btn btn-default btn-block">Cancelar</button>
                    </div>

                </form>

            </div>

        </div>
    </div>
</div>
<div class="modal-faltantes  modal-danger modal fade fade modal-3d-flip-horizontal show" id="modalVendedor" aria-hidden="true"
    role="dialog">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title"><i class="icon md-info"></i> NO SE PUEDE PROCESAR EL CONTRATO FALTAN LOS SIGUIENTES ITEMS EN EL KARDEX DEL
                    CHOFER
                </h4>
                <h6 class="modal-title"></h6>
            </div>

            <div class="modal-body div-faltantes">



            </div>

        </div>
    </div>
</div>













@section('scripts')

<script>

  

    function mostrarFaltantes(datos){
            var fila='<table class="table">'+
                '<tr><th>CODIGO</th><th>TITULO</th><th>CANTIDAD FALTANTE</th></tr>';
            datos.forEach(function(v,k){
                fila+='<tr>'+
                    '<td>'+v.codigo+'</td>'+
                    '<td>'+v.titulo+'</td>'+
                    '<td>'+v.cantidad_faltante+'</td>'+
                    '</tr>';

            })
            fila+='</table>';

            $('.modal-faltantes').find('.div-faltantes').empty()
            $('.modal-faltantes').find('.div-faltantes').append(fila)
            $('.modal-faltantes').modal('show')

        }
        function validarNumContrato(num){
            var deferred=$.ajax({
                url:'./diferidos/validar-contrato/'+num,
                method:'GET',
                async:false,
                dataType:'json',
               })
            return deferred.promise();
        }
        function validarCarnet(num){
            var deferred=$.ajax({
                url:'./diferidos/validar-carnet/'+num,
                method:'GET',
                async:false,
                dataType:'json',
            })
            return deferred.promise();
        }
        function validarCampos(){
            var sw=true;

            if($('.vendedor').val()==''){
                swal('Alerta','Seleccione un vendedor','warning')
                sw=false
            }
            if($('.chofer').val()==''){
                swal('Aleta','Seleccione un Chofer','warning')
                sw=false
            }
            if($('.num_contrato').val()==''){
                swal('Alerta','Ingrese un numero de contrato','warning')
                sw=false
            }
            if($('.num_carnet').val()==''){
                swal('Alerta','Ingrese un numero de carnet valido','warning')
                sw=false
            }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                sw=false
            }
            return sw;
        }


       function ver(id){
            let _url="{!!url('diferidos/"+id+"/ver')!!}"
                  $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
        }

        $(document).ready(function(){
         
           @if(isset($_GET['id']))
          ver({!!$_GET['id']!!})
         @endif
          
            $('.fecha-de-venta').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha.val(),modulo:'VENTAS'},
             dataType:'json',
             method:'GET',
             async:false,
          

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })

            $('.btn-cuota-ini').click(function(){
                $('.form-cuota-inicial').show();
                $('.form-procesar').hide()
                $(this).hide()
            })



                $('.btn-baja').click(function(_evt){
                    _evt.preventDefault();
                    var _id=$(this).attr('id');
                    var _href=$(this).attr('href')


                    swal({
                            title: "Baja de contrato",
                            text: "Este contrato sera anulado. Desea continuar?",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonClass: "btn-danger",
                            confirmButtonText: "Si, Anular!",
                            cancelButtonText:"Cancelar",
                            closeOnConfirm: false
                        },
                        function(){



                            window.location=_href
                        });

                })
            $('.btn-cancelar-cuota').click(function(){
                $('.form-cuota-inicial').hide();
                $('.form-procesar').show();
                $('.btn-cuota-ini ').show();


            })

            $('.btn-procesar').click(function(_evt){
               

                _evt.preventDefault();
                var _id=$(this).attr('id');
                var _href=$(this).attr('href')
                var _url='diferidos/'+_id+'/procesar';

                $.ajax({
                    url:'./diferidos/'+_id+'/validar-disponible',
                    method:'GET',
                    dataType:'json',
                    success:function(res){
                            console.log(res)

                        if(res.status){


                            swal.close();
                            // if(parseFloat(res.credito.cuotainicial)>0){
                                $('.monto-cuota-inicial').val(res.credito.cuotainicial)
                                $('.contrato_id').val(res.credito.contrato_id)
                                $('.contrato-id-diferido').val(res.credito.contrato_id)
                                $('.modal-recibo').modal('show')
                                $('.nombres').val(res.contrato.nombres+' '+ res.contrato.apellidopaterno+' '+res.contrato.apellidomaterno )
                                $('.carnet').val(res.contrato.ci)
                                $('.numero-documento').focus()
                            // }


                        }
                        else{

                            mostrarFaltantes(res.datos)
                        }

                    },
                    error:function(){
                        alert('ocurrio un problema en el servidor');
                    }
                })



            })





            $('.btn-registrar').click(function(_evt){



            _evt.preventDefault()
                 var num_carnet=$('.num_carnet').val()
                 var num_contrato=$('.num_contrato').val()
                 var validate=true;
                var  _fecha=$('.fecha').val()

                // if(num_carnet!='') {
                //     validarCarnet(num_carnet).then(function (data) {
                //         if (data.status) {
                //             swal('Alerta','Este Numero de carnet  corresponde a :'+data.datos.nombre1+' '+data.datos.paterno+' '+data.datos.materno+' y se encuentra la central de riesgo','warning')
                //            return false
                //
                //         }
                //
                //     })
                // }

                if(validarCampos()) {
                    $.ajax({
                        url: './diferidos/validar-contrato/' + num_contrato,
                        method: 'GET',
                        async: false,
                        dataType: 'json',
                        success: function (data) {
                            if (data.status) {
                                swal('Alerta', 'Este Numero de contrato  ya ha sido registrado ', 'warning')
                                return false

                            }
                            else {
                                $.ajax({
                                    url: './diferidos/validar-carnet/' + num_carnet,
                                    method: 'GET',
                                    async: false,
                                    dataType: 'json',
                                    success: function (data) {
                                        if (data.status) {
                                            swal('Alerta', 'Este Numero de carnet  corresponde a :' + data.datos.nombres + ' ' + data.datos.apellidos + ' y se encuentra la central de riesgo', 'warning')
                                            return false

                                        }
                                        else {



         
         $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha,modulo:'VENTAS'},
             dataType:'json',
             method:'GET',
             async:false,
          

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                        return false;
                        
                    }      
                    else{
                                                       $('.form-contrato').submit();

                    }
         }).fail(function(){
             alert('exisitio un error')
         })


                                        }

                                    }

                                })
                            }
                        }
                    })
                }
              

            })
            $('.select2').select2({
                placeholder: 'Seleccione un vendedor',
                multiple:false,
                width:'100%'
            })
            var select2=function(){
                $('body .select2').select2({
                    placeholder: 'Seleccione un vendedor',
                    multiple:false,
                    width:'100%'
                });

            }

            $('.tipo-filtro').change(function(){

                let valor=$(this).val();

                switch(valor){
                    case 'mes': $('.filtro-mes').show(); $('.filtro-acumulado').hide(); $('.filtro-rango').hide(); break;
                    case 'rango': $('.filtro-rango').show(); $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); break;
                    case 'acumulado': $('.filtro-acumulado').show(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); break;
                }

            })

            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
              let _id=$(this).attr('id')

                ver(_id)
            })

            $('.btn-devolucion').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })
        })

</script>

@stop
@endsection