@extends('layouts.admin')
@section('title') ROLES @stop
@section('titulo')ROLES Y PERMISOS DE USUARIO  @stop
@section('menu-usuarios')active open @stop
@section('permisos-opcion')active open @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    <a href="{{url('roles/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar rol de usuario</a>
@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Administracion </li>
        <li class="breadcrumb-item active"><a href="{{url('/roles')}}">Roles y Permisos</a></li>
    </ol>
@stop
@section('content')

    <div class="table-responsive">

        <table  id="table"  class="table table-hover  table-striped " >
            <thead>
            <tr>
                <th>NUMERO</th>
                <th>FECHA <br> REGISTRO</th>
                <th>ROL</th>
                <th>PERMISOS</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($roles as $f=>$r)
                <tr>
                    <td width="1%">{{$r->id}}</td>
                    <td>{{$r->created_at->format('d/m/Y H:i:s')}}</td>
                    <td>{{$r->name}}</td>
                    <td>
                        <ol >
                            @foreach($r->permissions as $k=>$p)
                                <li>{{$p->name}}</li>
                                @endforeach
                        </ol>
                    </td>

                    <td>

                            <a href="roles/{{$r->id}}/edit" class="btn-edit btn btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                            <a href="roles/{{$r->id}}/delete" id="{{$r->id}}"  class="btn-delete btn  btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>

                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true"
         aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">

                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>



@section('scripts')
    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>

        function alerta(id)
        {
            $.ajax({
               url:'./libros/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }
        // function printDiv() {
        //     var printContents = document.getElementById('nota').innerHTML;
        //     var originalContents = document.body.innerHTML;
        //     document.body.innerHTML = printContents;
        //     window.print();
        //     document.body.innerHTML = originalContents;
        // }
        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#nota').printArea(options);
        }



        $(document).ready(function(){
            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).attr('href')


                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara este rol de usuario:",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })
        })

    </script>
@stop


@endsection