@extends('layouts.admin')
    @section('title') REFINANCIAMIENTO @stop
      @section('titulo')  REFINANCIAMIENTO @stop
@section('styles')
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">

@stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item "><a href="{{url('/pagos-cobranza')}}">Refinanciamiento</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

        <form class="form-inline" method="GET" action="{{url('refinanciamiento-cuentas')}}">


            <div class="form-group col-md-4 ">
                <div class="row">
                            <div class="form-row col-md-12">
                            <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"  style="width:150%" class="numcuenta  form-control" >
                            <input type="hidden" name="credito_id" class="credito_id" value=""  >
                            </div>
                    <div class="form-row col-md-12">
                        <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                        <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                    </div>

                </div>
            </div>
            <div class="form-group ">
            <button type="submit" name="buscar"  style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>

@if(isset($credito) && !is_null($credito))
    <hr>
    <div class="table-responsive col-md-10">
      @include('cobranza.includes.detalle-cuenta')

    </div>
    <hr>
    <div class="row">



            <div class="col-md-6 row">
          <div class="col-md-6">
            <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUM RECIBO</td>
                    <td>NUM REPORTE</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                    <td>ACCIONES</td>
                </tr>
                </thead>
                <tbody>
                    @php
                    $saldo=$credito->saldo_inicial;
                    @endphp
                @foreach($pagos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d/m/Y')}}</td>
                        <td align="center">
                            @isset($p->recibo)
                            {{$p->recibo->numero}}
                            @endisset
                        </td>
                        <td>
                            {{$p->num_reporte}}
                        </td>
                        <td align="right">

                            {{$p->monto}}

                        </td>
                        @php $saldo-=$p->monto @endphp
                        <td align="right">{{round($saldo,2)}}</td>
                        <td>
                            <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}" class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">PLAN DE PAGOS</h5>
            <table class="table table-condensed">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>CUOTA</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                </tr>
                </thead>
                <tbody>
                @php $saldo=$credito->saldo;
                        @endphp
                @foreach($cuotas as $p)
                    <tr>
                        <td>{{\Carbon\Carbon::createFromFormat('Y-m-d',$p['fecha'])->format('d/m/Y')}}</td>
                        <td align="center">{{$p['numcuota']}}</td>
                        <td align="right">{{$p['monto']}}</td>
                        <td align="right">{{round($saldo-$p['monto'],2)}}</td>

                    </tr>
                    @php
                    $saldo-=$p['monto'];
                            @endphp
                @endforeach
                </tbody>
            </table>
        </div>
        @if(count($descuentos)>0)

         <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DESCUENTOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUMRECIBO</td>
                    <td>NUMREPORTE</td>
                    <td>MONTO</td>

                </tr>
                </thead>
                <tbody>

                @foreach($descuentos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$p->pago->numrecibo}}</td>
                        <td align="right">{{$p->pago->num_reporte}}</td>
                        <td align="right">{{round($p->monto,2)}}</td>

                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
        @endif

        @if(count($devoluciones)>0)

         <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DEVOLUCIONES</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>TIPO</td>
                <td>MONTO</td>

                </tr>
                </thead>
                <tbody>

                @foreach($devoluciones as $d)
                    <tr>
                        <td>{{$d->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$d->tipo}}</td>
                        <td align="right">{{round($d->monto_devolucion,2)}}</td>

                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
        @endif
            </div>
            <div class="col-md-6">
                    @if($credito->saldo>0)
                    <div class="panel ">

                        <div  class="panel-heading">
                               <h5 class="alert alert-info text-primary text-center">REPROGRAMACION</h5>
                        </div>
                        <div class="panel-body">

                 

                     
                        <form action="{{url('refinanciamiento-cuentas/guardar')}}" method="GET" class="form-refi col-md-10" >
                   <table class=" detalleContrato">
                <tr>
                <td><label>Num Pagos</label><input type="text" class="form-control" value="1" name="numpagos"  id="numero_cuotas" /></td>
                <td><label>Dias de Pago</label><input type="text" class="form-control"  value="30" name="diaspago" id="dias_pago" /></td>
                <td><label>Dias Gracia</label><input type="text" class="form-control" value="0" name="diasgracia"  id="dias_gracia" /></td>
                <td><label>Fecha Inicio</label><input type="text"  id="fecha2"  readonly name="fechainicio" class="datepicker form-control fechas" value="{{date("d/m/Y")}}"/></td>
                <td><label>&nbsp;</label><button  type="button" class="btn btn-success" onclick="verPlanPagos()">Calcular</button></td>
                </tr>
               
                </table>
                <HR />
                <table border="1" cellpadding="0" cellspacing="0" class="table" id="tabla-planpagos">
                <thead>
                <th>NumPago</th>
                <th>Fecha<br/>Vencimiento</th>
                 <th>MontoPago</th>
                </thead>
                <tbody id="campoCuotas"></tbody>
                
                
                </table>
                <input type="hidden" name="saldo" id="saldo_act" value="{{$credito->saldo}}">
                <button  type="button" class=" btn-guardar-refi btn btn-success btn-block " disabled >Guardar</button>
                                <input type="hidden"  name="idcuenta" id="idcuenta" value="{{$credito->id}}"/>
            </form>
        </div>
                </div>
                @else
                <h4 class="alert alert-info"> LA CUENTA NO TIENE SALDO PENDIENTE</h4>
                @endif
                <h5 class="alert alert-info text-primary text-center">DIAS DE PAGO</h5>
            <form action="{{url('refinanciamiento-cuentas/guardar-diaspago')}}" method="get" class="form-diacobro form-inline">
            <div class="form-group">
                <label for="">Dia de Cobro del Mes</label>
                <input type="number" max="31" class=" solo-enteros form-control" name="diaspago">
            <input type="hidden" name="credito_id" value="{{$credito->id}}">
                <button  type="button" class=" btn-guardar-diacobro btn btn-success">Guardar</button>

            </div>
            </form>
            </div>



    </div>
    @endif
@section('scripts')
    <script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>

   

    <script>

        var pagos=[];



function verPlanPagos(){

    
		 
			total_filas_cuotas=0;
	 $("#campoCuotas tr").remove();
	 
	      var f='';
	    fv=$("#fecha2").val();
		nc=$("#numero_cuotas").val();
		dp= $("#dias_pago").val();
		saldo=$("#saldo_act").val();
		dg=$("#dias_gracia").val();
		
				
		
	 
	  $.ajax({
					 
                              type: "GET",
                              url: "{{url('common/plan-pagos')}}",
                              data: {fecha:fv,diasgracia:dg,diaspago:dp,numcuotas:nc,saldo:saldo},
                              dataType: "json",
                              error: function(){
                                   // alert("ERROR EN LA PETICION");
                              },
                              success: function(res){
								  

                                                  if(res.datos.length>0){						
									res.datos.forEach((data , index)=>{

									addRowCuotas(data.numcuota,data.fecha,data.monto);
                                        console.log(data) 
                                    })     
                                                  }
                                                                     
										
						
								
                              }
                  });

                  $('.btn-guardar-refi').attr('disabled',false)
		 }
		  function addRowCuotas(cuota,fecha,monto){
	  
f="<tr><td>"+cuota+"</td><td>"+fecha+"</td><td>"+monto+"</td></tr>";
	
		  
	 $("#campoCuotas").append(f);
	total_filas_cuotas++;
	$("#numfilascuotas").val(total_filas_cuotas);
	  
	  }


        @if(isset($pagos))

                        @foreach($pagos as $p)

                            @isset($p->recibo)
                        pagos.push('{{$p->recibo->numero}}')
                            @endisset


                        @endforeach

                        @endif





        var options = {
             theme:'dark',
            // url: "../common/buscar-cuenta",
            url: "{{url('common/buscar-cuenta')}}",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                maxNumberOfElements: 1000,
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 200
        };

         $('.btn-registrar-descuento').click(function(){
             $(this).hide();
             $('.div-descuento').show()
             $('.monto-descuento').focus()

         })
        $('.btn-cancelar-descuento').click(function(){
            $('.div-descuento').hide()
            $('.btn-registrar-descuento').show()
            $('.monto-descuento').val('')
        })


        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });


    $('.btn-guardar-refi ').click(function(_evt){
            //   evt.preventDefault();
              swal({
                    title: "Refinanciamiento",
                    text: "Se Procesara el refinanciamiento?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Procesar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form-refi').submit()
                });
    }) 

      $('.btn-guardar-diacobro').click(function(_evt){
            //   evt.preventDefault();
              swal({
                    title: "cambiar dia de cobro",
                    text: "Se cambiara el dia de cobro en el mes?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Cambiar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form-diacobro').submit()
                });
    }) 
  


        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();

            let recibo=$('.recibo').val();
            if($('.monto').val()==''){
                swal('Alerta','Ingrese un monto para el pago','warning')
                return false;

            }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }
              console.log(pagos.indexOf(recibo),recibo,pagos)


            if(pagos.indexOf(recibo)!=-1){
                 swal('Alerta','El numero de recibo ya se encuentra registrado','warning')
                return false;
            }


            swal({
                    title: "Registro de Pago",
                    text: "Se registrara el pago?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





    </script>
@stop


@endsection
