@extends('layouts.admin')
@section('title') PAGOS @stop
@section('titulo') REGISTRAR PAGOS @stop
@section('styles')
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">

@stop


@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Cobranza</li>
    <li class="breadcrumb-item "><a href="{{url('/pagos-cobranza')}}">Pagos</a></li>
    <li class="breadcrumb-item active"><a href="{{url('/cuentas')}}">Registrar Pago</a></li>
</ol>
@stop
@section('content')
@include('includes.modal-ver')

<form class="form-inline" method="GET" action="{{url('pagos-cobranza/registrar')}}">


    <div class="form-group col-md-4 ">
        <div class="row">
            <div class="form-row col-md-12">
                <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif
                    placeholder="Criterio de busqueda" style="width:150%" class="numcuenta  form-control">
                <input type="hidden" name="credito_id" class="credito_id" value="">
            </div>
            <div class="form-row col-md-12">
                <label for="">Numero de Cuenta <input type="radio" class=" radio-inline tipo_numero" CHECKED name="tipo"
                        value="numcuenta"></label>
                <label for="">Nombres <input type="radio" class=" radio-inline tipo_apellidos" name="tipo"
                        value="apellidos"></label>
            </div>

        </div>
    </div>
    <div class="form-group ">
        <button type="submit" name="buscar" style="margin-top: -23px;" value="buscar"
            class="btn btn-outline-info waves-effect waves-light waves-round"> <i
                class="icon md-search"></i>Consultar</button>
    </div>
</form>

@if(isset($credito) && !is_null($credito))
<hr>
<div class="table-responsive col-md-10">
    @include('cobranza.includes.detalle-cuenta')

</div>
<hr>
<div class="row">



    <div class="col-md-6 row">
        <div class="col-md-6">
            <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>NUM RECIBO</td>
                        <td>NUM REPORTE</td>
                        <td>MONTO</td>
                        <td>SALDO</td>
                        <td>ACCIONES</td>
                    </tr>
                </thead>
                <tbody>
                    @php
                    $saldo=$credito->saldo_inicial;
                    @endphp
                    @foreach($pagos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d/m/Y')}}</td>
                        <td align="center">
                            @isset($p->recibo)
                            {{$p->recibo->numero}}
                            @endisset
                        </td>
                        <td>
                            {{$p->num_reporte}}
                        </td>
                        <td align="right">

                            {{$p->monto}}

                        </td>
                        @php $saldo-=$p->monto @endphp
                        <td align="right">{{round($saldo,2)}}</td>
                        <td>
                            <div class="btn-group" role="group" aria-label="Basic example">

                                <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}"
                                    class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                                <a href="#modal-{{$p->id}}" data-toggle="modal" class="btn btn-xs btn-primary"><i
                                        class="icon md-edit"></i></a>

                            </div>
                            {{-- <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}" class="btn-eliminar btn btn-xs
                            btn-danger"><i class="icon md-delete"></i></a> --}}

                            <div id="modal-{{$p->id}}" class="modal fade" style="z-index: 10000" role="dialog"
                                aria-labelledby="my-modal-title" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form action="{{url('pagos-cobranza/editar')}}" method="POST">
                                        <input type="hidden" name="id" value="{{$p->id}}">
                                        {{ csrf_field() }}
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="my-modal-title">Editar Pago</h5>
                                                <button class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body ">
                                                <div class="form-group  form-row">
                                                    <div class="col-md-12">
                                                        <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                                                        <input type="text" name="nombres"
                                                            value="@isset($p->recibo->nombres) {{$p->recibo->nombres}} @endisset"
                                                            class="nombres form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group  form-row">
                                                    <div class="col-md-2">
                                                        <label for="">NUM RECIBO</label>
                                                        <input type="text" autofocus
                                                            value="@isset($p->recibo->numero) {{$p->recibo->numero}} @endisset"
                                                            name="numrecibo" class="recibo form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label for="">FECHA RECIBO</label>
                                                        <input type="text" name="fecha"
                                                            value="{{$p->fecha->format('d/m/Y')}}"
                                                            class="fecha datepicker form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label for="">IMPORTE PAGADO</label>
                                                        <input type="text" name="monto" value="{{$p->monto}}"
                                                            class="monto numeroscondecimales form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label for="">N° REPORTE</label>
                                                        <input type="text" name="reporte" value="{{$p->num_reporte}}"
                                                            class="reporte form-control">
                                                    </div>

                                                </div>
                                                <div class="form-group  form-row">
                                                    <div class="col-md-6">
                                                        <label for="">QUIEN COBRO</label>
                                                        <select name="cobrador" class="form-control " id="">
                                                            <option value="">SELECCIONE</option>
                                                            @foreach($cobradores as $c)
                                                            <option value="{{$c->id}}" @if($p->cobrador_id==$c->id)
                                                                selected @endif>{{$c->nombre_completo}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>


                                                    <div class="col-md-6">
                                                        <label for="">OBSERVACIONES</label>
                                                        <textarea name="obs" class="form-control">{{$p->obs}}</textarea>
                                                    </div>
                                                </div>



                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-dark" data-dismiss="modal"
                                                    type="button">Cerrar</button>
                                                <button class="btn btn-primary" type="submit">Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
        </div>
        </td>
        </tr>
        @endforeach
        </tbody>
        </table>

    </div>
    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">PLAN DE PAGOS</h5>
        <table class="table table-condensed">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>CUOTA</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                </tr>
            </thead>
            <tbody>
                @php $saldo=$credito->saldo_inicial;
                @endphp
                @foreach($cuotas as $p)
                <tr>
                    <td>{{\Carbon\Carbon::createFromFormat('Y-m-d',$p['fecha'])->format('d/m/Y')}}</td>
                    <td align="center">{{$p['numcuota']}}</td>
                    <td align="right">{{$p['monto']}}</td>
                    <td align="right">{{round($saldo-$p['monto'],2)}}</td>

                </tr>
                @php
                $saldo-=$p['monto'];
                @endphp
                @endforeach
            </tbody>
        </table>
    </div>
    @if(count($descuentos)>0)

    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">DESCUENTOS</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUMRECIBO</td>
                    <td>NUMREPORTE</td>
                    <td>MONTO</td>

                </tr>
            </thead>
            <tbody>

                @foreach($descuentos as $p)
                <tr>
                    <td>{{$p->fecha->format('d-m-Y')}}</td>
                    <td align="center">{{$p->pago->numrecibo}}</td>
                    <td align="right">{{$p->pago->num_reporte}}</td>
                    <td align="right">{{round($p->monto,2)}}</td>

                </tr>

                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    @if(count($devoluciones)>0)

    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">DEVOLUCIONES</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>TIPO</td>
                    <td>MONTO</td>

                </tr>
            </thead>
            <tbody>

                @foreach($devoluciones as $d)
                <tr>
                    <td>{{$d->fecha->format('d-m-Y')}}</td>
                    <td align="center">{{$d->tipo}}</td>
                    <td align="right">{{round($d->monto_devolucion,2)}}</td>

                </tr>

                @endforeach
            </tbody>
        </table>
    </div>
    @endif
    @if(count($cambio_obras)>0)

    <div class="col-md-6">

        <h5 class="alert alert-warning text-center">CAMBIO OBRAS</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>NUMERO</td>
                    <td>FECHA</td>
                    <td>#INGRESO</td>
                    <td>#EGRESO</td>
                    <td>TIPO SALDO</td>
                    <td>MONTO </td>


                </tr>
            </thead>
            <tbody>

                @foreach($cambio_obras as $c)
                <tr>
                    <td>{{$c->id}}<a href="{{url('cambio-obras/'.$c->id.'/ver')}}"
                            class="btn-ver-nota btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Ver nota "><i class="icon md-open-in-new"
                                aria-hidden="true"></i></a></td>
                    <td>{{$c->fecha->format('d-m-Y')}}</td>
                    <td align="center"><strong>{{$c->numingreso}}<strong>
                    </td>
                    <td align="center"><strong>{{$c->numegreso}}<strong>
                    </td>
                    <td align="center" class=""><strong>{{$c->tipo_saldo}}<strong>
                    </td>
                    <td align="center"><strong>{{$c->monto_tipo_saldo}}</<strong>
                    </td>


                </tr>

                @endforeach
            </tbody>
        </table>
    </div>
    @endif
</div>
<div class="col-md-6">
    @if($credito->saldo>0)
    <form action="{{url('pagos-cobranza/store')}}" method="POST" class="form" style="font-size: 0.9em">
        {!! csrf_field() !!}
        <input type="hidden" name="credito_id" value="{{$credito->id}}">
        <div class="form-group  form-row">
            <div class="col-md-12">
                <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                <input type="text" name="nombres" value="{{$credito->nombre_cliente}}" class="nombres form-control">
            </div>
        </div>
        <div class="form-group  form-row">
            <div class="col-md-2">
                <label for="">NUM RECIBO</label>
                <input type="text" autofocus name="numrecibo" class="recibo form-control">
            </div>
            <div class="col-md-2">
                <label for="">FECHA RECIBO</label>
                <input type="text" name="fecha" class="fecha fecha-recibo datepicker form-control">
            </div>
            <div class="col-md-3">
                <label for="">IMPORTE PAGADO</label>
                <input type="text" name="monto" class="monto-pago numeroscondecimales form-control">
            </div>
            <div class="col-md-2">
                <label for="">N° REPORTE</label>
                <input type="text" name="reporte" class="reporte form-control">
            </div>

        </div>
        <div class="form-group  form-row">
            <div class="col-md-6" style="z-index=-1000">
                <label for="">QUIEN COBRO</label>
                <select name="cobrador" class="form-control select2" id="">
                    <option value="">SELECCIONE</option>
                    @foreach($cobradores as $c)
                    <option value="{{$c->id}}" @if(isset($credito->cobrador) && $credito->cobrador->id==$c->id) selected
                        @endif>{{$c->nombre_completo}}</option>
                    @endforeach
                </select>
            </div>


            <div class="col-md-6">
                <label for="">OBSERVACIONES</label>
                <textarea name="obs" class="form-control"></textarea>
            </div>
        </div>

        <button type="button" class="btn btn-info btn-registrar-descuento"> + Registrar Descuento</button>

        <div class="div-descuento form-row" style="display: none">
            <div class="col-md-12">
                <h5 class="label label-primary text-center"><strong>REGISTRAR DESCUENTO</strong></h5>
            </div>
            <div class="col-md-4">
                <label for="">TIPO DESCUENTO</label>
                <input type="text" READONLY value="PRONTO PAGO" name="tipo_descuento"
                    class="tipo-descuento form-control">
            </div>

            <div class="col-md-2">
                <label for="">MONTO PAGO</label>
                <input type="text" name="monto_descuento" class="monto-descuento  numeroscondecimales form-control">
            </div>
            <div class="col-md-2">
                <label for="">&nbsp;</label>
                <button type="button" class="btn btn-danger btn-cancelar-descuento"
                    style="margin-top: 20px">Cancelar</button>
            </div>

        </div>
        <hr>

        <button type="submit" class="btn btn-guardar btn-primary btn-block"> GUARDAR</button>


    </form>
    @else
    <h4 class="alert alert-info"> LA CUENTA NO TIENE SALDO PENDIENTE</h4>
    @endif
</div>



</div>
@endif
@section('scripts')
<script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>

<script>
    var pagos=[];

        @if(isset($pagos))

                        @foreach($pagos as $p)

                            @isset($p->recibo)
                        pagos.push('{{$p->recibo->numero}}')
                            @endisset


                        @endforeach

                        @endif





        var options = {
             theme:'dark',
            url: "../common/buscar-cuenta",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                maxNumberOfElements: 1000,
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 200
        };

         $('.btn-registrar-descuento').click(function(){
             $(this).hide();
             $('.div-descuento').show()
             $('.monto-descuento').focus()

         })
        $('.btn-cancelar-descuento').click(function(){
            $('.div-descuento').hide()
            $('.btn-registrar-descuento').show()
            $('.monto-descuento').val('')
        })


        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });

            $('.fecha').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha.val(),modulo:'COBRANZA'},
             dataType:'json',
             method:'GET',
             async:false,
        

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })

            $('.btn-ver-nota').click(function(_evt){
            _evt.preventDefault();
            let _url=$(this).attr('href')
            
            $.ajax({
            url:_url,
            method:'GET',
            dataType:'html',
            success:function(res)
            {
            $('.modal-ver').find('.modal-body').empty();
            $('.modal-ver').find('.modal-body').append(res)
            $('.modal-ver').modal('show')
            
            }
            })
            })

        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();
            @isset($credito)
            var saldo=parseFloat({{$credito->saldo}})
          
            @endisset

            var monto =parseFloat($('.monto-pago').val());
                 
            let recibo=$('.recibo').val();
            if($('.monto-pago').val()==''){
                swal('Alerta','Ingrese un monto para el pago','warning')
                return false;

            }
            if($('.fecha-recibo').val()==''){
                swal('Alerta','Ingrese una fecha de recibo','warning')
                return false;

            }
              if(monto>saldo){
                     swal('Alerta','el monto del pago no puede ser mayor al saldo actual','warning')
                        return false;
                   }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }
              console.log(pagos.indexOf(recibo),recibo,pagos)


            if(pagos.indexOf(recibo)!=-1){
                 swal('Alerta','El numero de recibo ya se encuentra registrado','warning')
                return false;
            }


            swal({
                    title: "Registro de Pago",
                    text: "Se registrara el pago?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





</script>
@stop


@endsection