@extends('layouts.admin')
@section('title') PAGOS @stop
@section('titulo')  PAGOS @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    <a href="{{url('pagos-cobranza/registrar')}}"  class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar Pago</a>


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item active"><a href="{{url('/cuentas')}}">Pagos</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <div class="col-md-12 nav navbar-nav ">
        <form class="row col-md-12  " method="get" action="{{url('pagos-cobranza')}}" >


            <div class=" col-md-2 form-group ">

                <select name="tipo" id=""  class=" tipo-filtro form-control">
                    <option value="">Seleccione Filtro</option>
                    <option @if(isset($tipo) && $tipo=='mes') selected @endif value="mes">FILTRO POR MES</option>
                    <option @if(isset($tipo) && $tipo=='rango') selected @endif value="rango">FILTRO POR RANGO DE FECHAS</option>
                    <option @if(isset($tipo) && $tipo=='acumulado') selected @endif value="acumulado">FILTRO ACUMULADO</option>
                    <option @if(isset($tipo) && $tipo=='buscar') selected @endif value="buscar">BUSCAR POR  CUENTA</option>
                </select>
            </div>

            <div class="filtro-mes col-md-3" @if(isset($tipo) && $tipo=='mes') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <select name="mes"  class="form-control" id="mes">
                        <option value="1"  @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                        <option value="2"  @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                        <option value="3"  @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                        <option value="4"  @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                        <option value="5"  @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                        <option value="6"  @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                        <option value="7"  @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                        <option value="8"  @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                        <option value="9"  @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                        <option value="10"  @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                        <option value="11"  @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                        <option value="12"  @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                    </select>
                    <label class="input-group-addon bg-info"for="date">
                        <span class="">De</span></label>
                    <select name="anio" id="anio" class="form-control">
                        @for($i=2016; $i<=2030; $i++)
                            <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
                </div>
                {{--            @include('includes.form-periodo')--}}
            </div>
            <div class="  filtro-rango" @if(isset($tipo) && $tipo=='rango') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <input @if(isset($fecha_ini) ) value="{{$fecha_ini->format('d/m/Y')}}" @endif readonly name="fecha_ini" type="text" class="datepicker input-group-addon form-control">
                    <label class="input-group-addon bg-info" for="date">
                        <span class="">hasta</span></label>
                    <input @if(isset($fecha_fin) )value="{{$fecha_fin->format('d/m/Y')}}" @endif readonly name="fecha_fin" type="text" class="datepicker input-group-addon form-control">
                </div>

            </div>
            <div class="filtro-acumulado" @if(isset($tipo) && $tipo=='acumulado') style="display:block" @else style="display: none" @endif>
                <div class="form-group">

                    <input type="text" readonly name="fecha_acumulado" value="{{$fecha_acumulado->format('d/m/Y')}}" class="form-control datepicker" >
                </div>

            </div>
            <div class="filtro-buscar" @if(isset($tipo) && $tipo=='buscar') style="display:block" @else style="display: none" @endif>
                <div class="form-group">

                    <input type="text" name="numcuenta" value="{{$numcuenta}}" placeholder="numero de cuenta" class="form-control" >
                </div>

            </div>


            <div class="form-group form-material">
                <button type="submit" name="buscar" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>

    <div class="table-responsive">

        <table  id="table"  class=" data-table table table-hover  table-striped  table-condensed table-inverse" >
            <thead>
            <tr>
                <th>ID</th>
                <th>CUENTA</th>
                <th>CLIENTE</th>
                <th>TIPO <BR>DOCUMENTO</th>
                <th>NUM <BR>DOCUMENTO</th>
                <th>FECHA</th>
                <th>MONTO </th>
                <th>NUM REPORTE </th>
           
                <th>COBRADOR</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($datos as $f=>$r)
                <tr>

                    <td  width="1%">{{$r->id}}</td>
                    <td width="5%" align="center" class="text-center">{{$r->credito->numcuenta}}</td>
                    <td  width="25%">{{$r->credito->nombre_cliente}}</td>
                    <td  width="3%">{{$r->tipo_documento}}</td>
                    <td  width="3%">{{$r->numrecibo}}</td>
                    <td width="4%">{{$r->fecha->format('d/m/Y')}}</td>
                    <td width="4%">{{$r->monto}}</td>
                    <td width="4%">{{$r->num_reporte}}</td>
                    <td  width="15%">
                    @if(isset($r->cobrador))
                        {{$r->cobrador->nombre_completo}}
                        @endif
                    </td>
                

                    <td width="20%">
                        <div class="btn-toolbar" role="toolbar">

                            <a href="{{url('pagos-cobranza/delete')}}/{{$r->id}}" class="btn-eliminar btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-close" aria-hidden="true"></i></a>
                        </div>


                        {{--<a href="notas-ingreso/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>--}}
                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@section('scripts')

    <script>




        $(document).ready(function(){

     
         


            $('.select2').select2({
                placeholder: 'Seleccione un vendedor',
                multiple:false,
                width:'100%'
            })
            var select2=function(){
                $('body .select2').select2({
                    placeholder: 'Seleccione un vendedor',
                    multiple:false,
                    width:'100%'
                });

            }

            $('.tipo-filtro').change(function(){

                let valor=$(this).val();

                switch(valor){
                    case 'mes': $('.filtro-mes').show(); $('.filtro-acumulado').hide(); $('.filtro-rango').hide();  $('.filtro-buscar').hide();break;
                    case 'rango': $('.filtro-rango').show(); $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); $('.filtro-buscar').hide(); break;
                    case 'acumulado': $('.filtro-acumulado').show(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); $('.filtro-buscar').hide(); break;
                    case 'buscar': $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); $('.filtro-buscar').show(); break;
                }

            })

         
            $('.btn-eliminar').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                  swal({
                        title: "Esta seguro?",
                        text: "Se eliminara el pago",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        window.location=_url
                    });

             
            })
        })


    </script>
@stop


@endsection