@extends('layouts.admin')
    @section('title') MANTENIMIENTO CUENTAS @stop
      @section('titulo') MANTENIMIENTO CUENTAS @stop
@section('styles')
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">

@stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item "><a href="{{url('/mantenimiento-cuentas')}}">Mantenimiento cuentas</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

        <form class="form-inline" method="GET" action="{{url('mantenimiento-cuentas')}}">


            <div class="form-group col-md-4 ">
                <div class="row">
                            <div class="form-row col-md-12">
                            <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"  style="width:150%" class="numcuenta  form-control" >
                            <input type="hidden" name="credito_id" class="credito_id" value=""  >
                            </div>
                    <div class="form-row col-md-12">
                        <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                        <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                    </div>

                </div>
            </div>
            <div class="form-group ">
            <button type="submit" name="buscar"  style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>

@if(isset($credito) && !is_null($credito))
    <hr>
    <div class="table-responsive col-md-10">
      @include('cobranza.includes.detalle-cuenta')

    </div>
    <hr>
    <div class="row">



            <div class="col-md-6 row">
          <div class="col-md-6">
            <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUM RECIBO</td>
                    <td>NUM REPORTE</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                    <td>ACCIONES</td>
                </tr>
                </thead>
                <tbody>
                    @php
                    $saldo=$credito->saldo_inicial;
                    @endphp
                @foreach($pagos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d/m/Y')}}</td>
                        <td align="center">
                            @isset($p->recibo)
                            {{$p->recibo->numero}}
                            @endisset
                        </td>
                        <td>
                            {{$p->num_reporte}}
                        </td>
                        <td align="right">

                            {{$p->monto}}

                        </td>
                        @php $saldo-=$p->monto @endphp
                        <td align="right">{{round($saldo,2)}}</td>
                        <td>
                            <a href="{{url('pagos-cobranza/delete')}}/{{$p->id}}" class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">PLAN DE PAGOS</h5>
            <table class="table table-condensed">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>CUOTA</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                </tr>
                </thead>
                <tbody>
                @php $saldo=$credito->saldo;
                        @endphp
                @foreach($cuotas as $p)
                    <tr>
                        <td>{{\Carbon\Carbon::createFromFormat('Y-m-d',$p['fecha'])->format('d/m/Y')}}</td>
                        <td align="center">{{$p['numcuota']}}</td>
                        <td align="right">{{$p['monto']}}</td>
                        <td align="right">{{round($saldo-$p['monto'],2)}}</td>

                    </tr>
                    @php
                    $saldo-=$p['monto'];
                            @endphp
                @endforeach
                </tbody>
            </table>
        </div>
        @if(count($descuentos)>0)

         <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DESCUENTOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUMRECIBO</td>
                    <td>NUMREPORTE</td>
                    <td>MONTO</td>

                </tr>
                </thead>
                <tbody>

                @foreach($descuentos as $p)
                    <tr>
                        <td>{{$p->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$p->pago->numrecibo}}</td>
                        <td align="right">{{$p->pago->num_reporte}}</td>
                        <td align="right">{{round($p->monto,2)}}</td>

                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
        @endif

        @if(count($devoluciones)>0)

         <div class="col-md-6">

            <h5 class="alert alert-info text-primary text-center">DEVOLUCIONES</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                <tr style="font-weight: bolder">
                    <td>NUM</td>
                    <td>FECHA</td>
                    <td>TIPO</td>
                     <td>MONTO</td>

                </tr>
                </thead>
                <tbody>

                @foreach($devoluciones as $d)
                    <tr>
                        <TD>{{$d->id}}</TD>
                        <td>{{$d->fecha->format('d-m-Y')}}</td>
                        <td align="center">{{$d->tipo_devolucion}}</td>
                        <td align="right">{{round($d->monto_devolucion,2)}}</td>

                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
        @endif
            </div>
            <div class="col-md-6">
                    @if($credito->saldo>0)

                  
                        <div class="form-group">
                            <div class="col-md-12">
                          
                            <label for="">ACCION</label>
                            <select name="accion" id="" class=" accion form-control">
                                <option value="">SELECCIONE UNA ACCION</option>
                                <option value="DEVOLUCION">DEVOLUCION</option>
                                <option value="CAMBIO">CAMBIO OBRA</option>
                                <option value="RIESGO">CENTRAL RIESGO</option>
                            </select>
                        </div>
                          </div>
         <form action="{{url('mantenimiento-cuentas/procesar')}}" method="POST" class="form-riesgo"  style="display:none">
                                    {{csrf_field()}}
                                    <input type="hidden" name="tipo" value="riesgo">
                                 <input type="hidden" name="credito" value="{{$credito->id}}">
                        <div class="card text-left|center|right card-bordered ">
                      
                          <div class="card-body">
                            <h4 class="card-title text-center text-primary ">CENTRAL RIESGO</h4>
                         
                            <div class="form-group  row">
                              <div  class="col-md-3">

                                    <label for="">FECHA</label>
                                    <input type="text" required class="fechariesgo fechavalidar form-control datepicker"  required name="fechariesgo" id="">
                            <small id="helpId" class="form-text text-muted">Fecha ingreso vencida</small>

                                </div>

                                 <div  class="col-md-6">

                                    <label for="">CONCEPTO</label>
                                    <input type="text"  value="VENTA" required class="conceptoriesgo form-control" name="conceptoriesgo" id="" aria-describedby="helpId" placeholder="">
                                    <small id="helpId" class="form-text text-muted">Concepto de la deuda</small>
                                </div>
                          
                                   <div  class="col-md-3">

                                    <label for="">DOCUMENTO </label>
                                    <select name="documentoriesgo" id="" class="form-control">
                                        <option value="contrato">CONTRATO</option>
                                        <option value="otros">OTROS</option>
                                    </select>
                                </div>
                                  <div  class="col-md-3">

                                    <label for=""> NUMERO</label>
                                 <input type="text" name="numeroriesgo" class="numeroriesgo form-control" required id="">

                                <small id="helpId" class="form-text text-muted">Numero del documento de la deuda</small>
                               </div>
                            </div>
                            <button   type="submit" class="btn guardar-riesgo btn-block btn-success">GUARDAR</button>

                           
                          </div>
                        </div>
                        </form>

                                 <form action="{{url('mantenimiento-cuentas/procesar')}}" method="POST" class="form-devolucion"  style="display:none">
                                    {{csrf_field()}}
                                    <input type="hidden" name="tipo" value="devolucion">
                                 <input type="hidden" name="credito" value="{{$credito->id}}">
                        <div class="card text-left|center|right card-bordered ">
                      
                          <div class="card-body">
                            <h4 class="card-title text-center text-primary ">DEVOLUCION</h4>
                         
                            <div class="form-group  row">
                                {{-- <div  class="col-md-2">

                                    <label for="">NUMERO </label>
                                    <input type="text"  required class="numerodevolucion form-control" name="numerodevolucion" id="" aria-describedby="helpId" placeholder="">
                                    <small id="helpId" class="form-text text-muted">Numero de la  nota de devolucion</small>
                                </div> --}}
                                 <div  class="col-md-2">

                                    <label for="">MONTO</label>
                                    <input type="text"  required class="montodevolucion form-control numeroscondecimales" name="montodevolucion" id="" aria-describedby="helpId" placeholder="">
                                    <small id="helpId" class="form-text text-muted">Monto de la devolucion</small>
                                </div>
                                  <div  class="col-md-3">

                                    <label for="">FECHA</label>
                                    <input type="text" required class="fechadevolucion fechavalidar form-control datepicker"  required name="fechadevolucion" id="">
                            <small id="helpId" class="form-text text-muted">Fecha de la Devolucion</small>

                                </div>
                                   <div  class="col-md-3">

                                    <label for="">TIPO</label>
                                    <select name="tipodevolucion" id="" class="form-control">
                                        <option value="TOTAL">TOTAL</option>
                                        <option value="PARCIAL">PARCIAL</option>
                                    </select>
                                </div>
                                  <div  class="col-md-2">

                                    <label for=""> INGRESO</label>
                                 <input type="text" name="ingresodevolucion" class="ingresodevolucion form-control"  required id="">

                                <small id="helpId" class="form-text text-muted">Numero de la nota de Ingreso</small>
                               </div>
                            </div>
                            <button   type="submit" class="btn guardar-devolucion btn-block btn-success">GUARDAR</button>

                           
                          </div>
                        </div>
                        </form>

                           <form action="{{url('mantenimiento-cuentas/procesar')}}" method="POST" class="form-cambio" style="display:none">
                                    {{csrf_field()}}
                                     <input type="hidden" name="credito" value="{{$credito->id}}">
                                    <input type="hidden" name="tipo" value="cambio">
                        <div class="card text-left|center|right card-bordered ">
                      
                          <div class="card-body">
                            <h4 class="card-title text-center text-primary ">CAMBIO DE OBRA </h4>
                         
                            <div class="form-group  row">
                                {{-- <div  class="col-md-2">

                                    <label for="">NUMERO </label>
                                    <input type="text"  required class="numerocambio form-control" name="numerocambio" id="" aria-describedby="helpId" placeholder="">
                                    <small id="helpId" class="form-text text-muted">Numero de Cambio de obra</small>
                                </div> --}}
                                  
                                 <div  class="col-md-2">

                                    <label for="">MONTO</label>
                                    <input type="text"  required class="montocambio form-control numeroscondecimales " name="montocambio" id="" aria-describedby="helpId" placeholder="">
                                    <small id="helpId" class="form-text text-muted">Monto de la devolucion</small>
                                </div>
                                 <div  class="col-md-3">

                                    <label for="">AFECTA AL SALDO</label>
                                    <select name="afectacambio" id="" class="form-control">
                                        <option value="disminuye">DISMINUYE</option>
                                        <option value="aumenta">AUMENTA</option>
                                    </select>     
                                    <small id="helpId" class="form-text text-muted">El monto, disminuye o aumenta al saldo</small>
                                </div>
                                  <div  class="col-md-3">

                                    <label for="">FECHA</label>
                                    <input type="text" required class="fechacambio fechavalidar form-control datepicker"  required name="fechacambio" id="">
                            <small id="helpId" class="form-text text-muted">Fecha del cambio de Obra</small>

                                </div>
                            </div>
                            <div class="form-group row">
                                  <div  class="col-md-2">

                                    <label for=""> INGRESO</label>
                                 <input type="text" name="ingresocambio" class="form-control"  required  id="">

                                <small id="helpId" class="form-text text-muted">Numero de la nota de Ingreso</small>
                               </div>

                               <div  class="col-md-2">

                                    <label for=""> EGRESO</label>
                                 <input type="text" name="egresocambio" class="form-control"  required  id="">

                                <small id="helpId" class="form-text text-muted">Numero de la nota de Egreso</small>
                               </div>
                            </div>
                            <button   type="submit" class="btn guardar-cambio btn-block btn-success">GUARDAR</button>

                           
                          </div>
                        </div>
                        </form>

                    
               
                @else
                <h4 class="alert alert-info"> LA CUENTA NO TIENE SALDO PENDIENTE</h4>
                @endif
            </div>



    </div>
    @endif
@section('scripts')
    <script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>

    <script>

        var pagos=[];

        var options = {
             theme:'dark',
            url: "{{url('common/buscar-cuenta-antigua')}}",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                maxNumberOfElements: 1000,
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 200
        };

        $('.fechavalidar').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha.val(),modulo:'COBRANZA'},
             dataType:'json',
             method:'GET',
             async:false,
          

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })

        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });


        $('.accion').change(function(){
            let accion=$(this).val()

            if(accion==='DEVOLUCION'){
               $('.form-devolucion').show();
               $('.form-cambio').hide();
               $('.form-riesgo').hide();
            }

             else if(accion==='CAMBIO'){
               $('.form-devolucion').hide();
               $('.form-cambio').show();
                  $('.form-riesgo').hide();
            }

             else if(accion==='RIESGO'){
                    $('.form-riesgo').show();
               $('.form-devolucion').hide();
               $('.form-cambio').hide();
            }
            else{
                $('.form-devolucion').hide();
               $('.form-cambio').hide();
                                 $('.form-riesgo').hide();

            }
        })



        $('.guardar-devolucion').click(function(_evt){
            _evt.preventDefault();

             let monto = $('.montodevolucion').val()
             let numero = $('.numerodevolucion').val()
             let fecha = $('.fechadevolucion').val()
             if(monto=='' || parseFloat(monto)<=0 ){
                 swal('Error','Ingrese un monto','error')
                 return false;
             }

              if(numero==''){
                 swal('Error','Ingrese un numero de devolucion','error')
                 return false;
             }

              if(fecha==''){
                 swal('Error','Ingrese una fecha  de devolucion','error')
                 return false;
             }

            swal({
                    title: "Registro de la Devoluion",
                    text: "Se registrara  la Devolucion?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form-devolucion').submit()
                });
        })


$('.guardar-riesgo').click(function(_evt){
            _evt.preventDefault();

            
             let numero = $('.conceptoriesgo').val()
             let fecha = $('.fechariesgo').val()
           

              if(numero==''){
                 swal('Error','Ingrese un concepto','error')
                 return false;
             }

              if(fecha==''){
                 swal('Error','Ingrese una fecha  ','error')
                 return false;
             }

            swal({
                    title: "Central de riesgo",
                    text: "La cuenta se enviara a la central de riegos?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form-riesgo').submit()
                });
        })
 $('.guardar-cambio').click(function(_evt){
            _evt.preventDefault();

             let monto = $('.montocambio').val()
             let numero = $('.numerocambio').val()
             let fecha = $('.fechacambio').val()
             if(monto=='' || parseFloat(monto)<=0 ){
                 swal('Error','Ingrese un monto','error')
                 return false;
             }

              if(numero==''){
                 swal('Error','Ingrese un numero de Cambio de Obra ','error')
                 return false;
             }

              if(fecha==''){
                 swal('Error','Ingrese una fecha  de Cambio de Obra','error')
                 return false;
             }


            swal({
                    title: "Registro del Cambio de obra",
                    text: "Se registrara  el Cambio de Obra?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form-cambio').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





    </script>
@stop


@endsection
