@extends('layouts.admin')
@section('title') CUENTAS @stop
@section('titulo') CUENTAS @stop
{{--@section('libros-opcion')active @stop--}}
@section('acciones')
{{--<a href="#modalVendedor" data-toggle="modal" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar Contrato</a>--}}
@stop
@section('styles')
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
<link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">
@stop
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Cobranza</li>
    <li class="breadcrumb-item active"><a href="{{url('/cuentas')}}">Cuentas</a></li>
</ol>
@stop
@section('content')
@include('includes.modal-ver')
<div class="col-md-12 nav navbar-nav ">
    <form class="row col-md-12  " method="get" action="{{url('cuentas')}}">
        <div class=" col-md-2 form-group ">
            <select name="tipo" id="" class=" tipo-filtro form-control">
                <option value="">Seleccione Filtro</option>
                <option @if(isset($tipo) && $tipo=='mes' ) selected @endif value="mes">FILTRO POR MES</option>
                <option @if(isset($tipo) && $tipo=='rango' ) selected @endif value="rango">FILTRO POR RANGO DE FECHAS</option>
                <option @if(isset($tipo) && $tipo=='acumulado' ) selected @endif value="acumulado">FILTRO ACUMULADO</option>
                <option @if(isset($tipo) && $tipo=='buscar' ) selected @endif value="buscar">BUSCAR CUENTA</option>
            </select>
        </div>
        <div class="filtro-mes col-md-3" @if(isset($tipo) && $tipo=='mes' ) style="display:block" @else style="display: none" @endif>
            <div class="input-group ">
                {{--<span class="icon md-calendar"></span></label>--}}
                <select name="mes" class="form-control" id="mes">
                    <option value="1" @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                    <option value="2" @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                    <option value="3" @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                    <option value="4" @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                    <option value="5" @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                    <option value="6" @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                    <option value="7" @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                    <option value="8" @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                    <option value="9" @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                    <option value="10" @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                    <option value="11" @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                    <option value="12" @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                </select>
                <label class="input-group-addon bg-info" for="date">
                    <span class="">De</span></label>
                <select name="anio" id="anio" class="form-control">
                    @for($i=2016; $i<=2030; $i++) <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                </select>
            </div>
            {{-- @include('includes.form-periodo')--}}
        </div>
        <div class="  filtro-rango" @if(isset($tipo) && $tipo=='rango' ) style="display:block" @else style="display: none" @endif>
            <div class="input-group ">
                {{--<span class="icon md-calendar"></span></label>--}}
                <input @if(isset($fecha_ini) ) value="{{$fecha_ini->format('d/m/Y')}}" @endif readonly name="fecha_ini" type="text" class="datepicker input-group-addon form-control">
                <label class="input-group-addon bg-info" for="date">
                    <span class="">hasta</span></label>
                <input @if(isset($fecha_fin) )value="{{$fecha_fin->format('d/m/Y')}}" @endif readonly name="fecha_fin" type="text" class="datepicker input-group-addon form-control">
            </div>
        </div>
        <div class="filtro-acumulado" @if(isset($tipo) && $tipo=='acumulado' ) style="display:block" @else style="display: none" @endif>
            <div class="form-group">
                <input type="text" readonly name="fecha_acumulado" value="{{$fecha_acumulado->format('d/m/Y')}}" class="form-control datepicker">
            </div>
        </div>
        <div class="filtro-buscar" @if(isset($tipo) && $tipo=='buscar' ) style="display:block" @else style="display: none" @endif>
            {{-- <div class="form-group">
                    <input type="text" name="numcuenta" value="{{$numcuenta}}" placeholder="numero de cuenta" class="form-control" >
        </div> --}}
        <div class="form-group col-md-12 ">
            <div class="row">
                <div class="form-row col-md-12">
                    <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda" style="width:150%" class="numcuenta  form-control">
                    <input type="hidden" name="credito_id" class="credito_id" value="">
                </div>
                <div class="form-row col-md-12">
                    <label for="">Numero de Cuenta <input type="radio" class=" radio-inline tipo_numero" CHECKED name="tipo-buscar" value="numcuenta"></label>
                    <label for="">Nombres <input type="radio" class=" radio-inline tipo_apellidos" name="tipo-buscar" value="apellidos"></label>
                </div>
            </div>
        </div>
</div>
<div class="form-group form-material">
    <button type="submit" name="buscar" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
</div>
</form>
</div>
@if(count($datos)>0)
<div class="table-responsive">
    <table id="table" class=" data-table table table-hover  table-striped  table-condensed table-inverse">
        <thead>
            <tr>
                <th>ID</th>
                <th>FECHA VENTA</th>
                <th>NUEMRO <BR>CUENTA </th>
                <th>N°<br>CONTRATO</th>
                <th>MONTO CONTRATO</th>
                <th>SALDO ACTUAL</th>
                <th>VENDEDOR / CHOFER</th>
                <th>COBRADOR</th>
                <th>NOMBRE CLIENTE</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            @foreach($datos as $f=>$r)
            <tr>
                <td width="1%">{{$r->id}}</td>
                <td width="4%">{{$r->fechadoc->format('d/m/Y')}}</td>
                <td width="4%">{{$r->numcuenta}}</td>
                <td width="5%" align="center" class="text-center">
                    @isset($r->contrato)
                    {{$r->contrato->numcontrato}}
                    @endisset
                </td>
                <td width="3%">
                    @isset($r->contrato)
                    {{$r->contrato->preciototal}}
                    @endisset
                </td>
                <td width="3%">{{$r->saldo}}</td>
                <td width="15%">
                    @isset($r->contrato)
                    {{$r->contrato->vendedor->nombre_completo}} / {{$r->contrato->chofer->nombre_completo}}
                    @else
                    {{$r->vendedor_nombre}}
                    @endisset
                </td>
                <td width="15%">
                    @if(isset($r->cobrador))
                    {{$r->cobrador->nombre_completo}}
                    @endif
                </td>
                <td width="10%">{{$r->nombre_cliente}}</td>
                <td width="20%">
                    <div class="btn-toolbar" role="toolbar">
                        <a href="cuentas/{{$r->id}}/editar" class="btn-editar btn btn-icon btn-pure btn-warning on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar cuenta"><i class="icon md-edit" aria-hidden="true"></i></a>
                        <a href="cuentas/{{$r->id}}/ver-foto" class="btn-foto btn btn-icon btn-pure btn-primary on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver foto"><i class="icon md-image" aria-hidden="true"></i></a>
                        <a href="cuentas/{{$r->id}}/ver-contrato" class="btn-ver-contrato btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Contrato"><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                        <a href="cuentas/{{$r->id}}/ver-tarjeta" class="btn-tarjeta-cobranza btn btn-icon btn-pure btn-dark on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Tarjeta de cobranza"><i class="icon md-assignment" aria-hidden="true"></i></a>
                        <a href="cuentas/{{$r->id}}/ver-pagos" class="btn-ver-pagos btn btn-icon btn-pure btn-success on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Pagos"><i class="icon md-money" aria-hidden="true"></i></a>
                    </div>
                    {{--<a href="notas-ingreso/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>--}}
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@else
@endif
@section('scripts')
<script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>
<script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>
<script>
    var options = {
        theme: 'dark',
        url: "{{url('/common/buscar-cuenta')}}",
        getValue: function(element) {
            console.log(element);
            return 'Cuenta:' + element.numcuenta + ' Cliente: ' + element.nombre_cliente;
        },
        ajaxSettings: {
            dataType: "json",
            method: "GET",
            data: {
                dataType: "json"
            }
        },
        list: {
            maxNumberOfElements: 1000,
            onSelectItemEvent: function() {
                var value = $(".numcuenta").getSelectedItemData().id;
                $(".credito_id").val(value);
            }
        },
        preparePostData: function(data) {
            let tipo = 'numero';
            if ($('.tipo_apellidos').is(':checked')) {
                tipo = 'apellidos'
            } else {
                tipo = 'numero';
            }
            data.term = $(".numcuenta").val();
            data.tipo = tipo;
            return data;
        },
        requestDelay: 200
    };
    $(document).ready(function() {
        $('.btn-editar').click(function(_evt) {
            _evt.preventDefault()
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
        $('.btn-foto').click(function(_evt) {
            _evt.preventDefault()
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function() {
            $(this).val('')
        });
        $('.btn-baja').click(function(_evt) {
            _evt.preventDefault();
            var _id = $(this).attr('id');
            var _href = $(this).attr('href')
            swal({
                    title: "Baja de contrato",
                    text: "Este contrato sera anulado. Desea continuar?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Anular!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    window.location = _href
                });
        })
        $('.btn-cancelar-cuota').click(function() {
            $('.form-cuota-inicial').hide();
            $('.form-procesar').show();
            $('.btn-cuota-ini ').show();
        })
        $('.select2').select2({
            placeholder: 'Seleccione un vendedor',
            multiple: false,
            width: '100%'
        })
        var select2 = function() {
            $('body .select2').select2({
                placeholder: 'Seleccione un vendedor',
                multiple: false,
                width: '100%'
            });
        }
        $('.tipo-filtro').change(function() {
            let valor = $(this).val();
            switch (valor) {
                case 'mes':
                    $('.filtro-mes').show();
                    $('.filtro-acumulado').hide();
                    $('.filtro-rango').hide();
                    $('.filtro-buscar').hide();
                    break;
                case 'rango':
                    $('.filtro-rango').show();
                    $('.filtro-acumulado').hide();
                    $('.filtro-mes').hide();
                    $('.filtro-buscar').hide();
                    break;
                case 'acumulado':
                    $('.filtro-acumulado').show();
                    $('.filtro-mes').hide();
                    $('.filtro-rango').hide();
                    $('.filtro-buscar').hide();
                    break;
                case 'buscar':
                    $('.filtro-acumulado').hide();
                    $('.filtro-mes').hide();
                    $('.filtro-rango').hide();
                    $('.filtro-buscar').show();
                    break;
            }
        })
        $('.btn-tarjeta-cobranza').click(function(_evt) {
            _evt.preventDefault();
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
        $('.btn-ver-contrato').click(function(_evt) {
            _evt.preventDefault();
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
        $('.btn-ver-pagos').click(function(_evt) {
            _evt.preventDefault();
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
        $('.btn-devolucion').click(function(_evt) {
            _evt.preventDefault();
            let _url = $(this).attr('href')
            $.ajax({
                url: _url,
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').append(res)
                    $('.modal-ver').modal('show')
                }
            })
        })
    })
</script>
@stop
@endsection