@extends('layouts.admin')
@section('title') REGISTRAR CAMBIO DE OBRAS @stop
@section('titulo')  REGISTRAR CAMBIO DE OBRAS @stop
@section('styles')
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">

@stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item "><a href="{{url('/cambio-obras')}}">Cambio Obras</a></li>
        <li class="breadcrumb-item active"><a href="{{url('cambio-obras')}}">Registrar cambio de obras</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <form class="form-inline" method="POST" action="{{url('cambio-obras/create')}}">
        {!! csrf_field() !!}
        <div class="form-group col-md-4">
            <div class="row">
                <div class="form-row col-md-12">
                    <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"  style="width:150%" class="numcuenta  form-control" >
                    <input type="hidden" name="credito_id" class="credito_id" value=""  >
                </div>
                <div class="form-row col-md-12">
                    <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                    <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                </div>

            </div>
        </div>
        <div class="form-group ">
            <button type="submit" name="buscar"  style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>

    @if(isset($credito) && !is_null($credito))
        <hr>
        <div class="table-responsive col-md-10">
            <table class="table table-condensed table-bordered col-md-10"  >
                <tr style="font-weight: bolder">
                    <td class="negrita" ><strong class="negrita">NUMERO CUENTA:</strong>{{$credito->numcuenta}}</td>
                    <td ><strong>NUMERO CONTRATO:</strong>{{$credito->contrato->numcontrato}}</td>
                    <td ><strong>CLIENTE:</strong>{{$credito->contrato->nombre_completo}}</td>
                    <td ><strong>FECHA CONTRATO:</strong>{{$credito->contrato->fechacontrato->format('d/m/Y')}}</td>
                    <td ><strong>FECHA VENTA:</strong>{{$credito->fechadoc->format('d/m/Y')}}</td>
                </tr>
                <tr style="font-weight: bolder">
                    <td >PRECIO DE VENTA: {{$credito->contrato->preciototal}}</td>
                    <td ><strong>NUMERO CUOTAS: </strong>{{$credito->numcuotas}}</td>
                    <td ><strong>MONTO CUOTAS: </strong>{{$credito->montocuotas}}</td>
                    <td ><strong>CUOTA INICIAL: </strong>{{$credito->cuotainicial}}</td>
                    <td   class="bg-dark"><strong>SALDO INICIAL:</strong> {{$credito->saldo}}</td>
                    <td   class="bg-primary"><strong>SALDO ACTUAL:</strong> {{$credito->saldo_actual}}</td>

                </tr>

            </table>

        </div>

        <form action="{{url('cambio-obras/store')}}" method="POST" class="form-cambio" style="font-size: 0.9em">

        <div class="row">
            <div class="col-md-12">
                {!! csrf_field() !!}
                <input type="hidden" name="credito_id" value="{{$credito->id}}">
                <div class="form-group  form-row">
                    <div class="col-md-1">
                        <label for="">FECHA</label>
                        <input type="text"  name="fecha" class="fecha datepicker form-control">
                    </div>

                    <div class="col-md-6">
                        <label for="">OBSERVACIONES</label>
                        <textarea name="obs" class="form-control"></textarea>
                    </div>
                </div>
            </div>


            <div class="col-md-7">

                    <div class="form-row">
                        <div class=" form-group col-md-6 col-sm-12">
                            <label class="form-control-label "><strong>CODIGO</strong></label>
                            <select  id="select3" name="libro_id" class="form-control select3"  >
                                <option value="">Seleccione</option>
                                @foreach($libros as $r)
                                    <option  stock="{{$r->stock}}" codigo="{{$r->codigo}}" titulo="{{$r->titulo}}" tomo="{{$r->tomo}}" precio="{{$r->precio_base}}" value="{{$r->id}}"><strong>{{$r->codigo}} - </strong>{{$r->titulo}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class=" form-group col-md-1 col-sm-4 col-xs-4">
                            <label   class="form-control-label" for=""><strong>Stock</strong></label>
                            <input type="text" readonly  id="stock" class="stock limpiar form-control">
                        </div>

                        <div class=" form-group col-md-2 col-sm-4 col-xs-4">
                            <label   class="form-control-label" for=""><strong>P.UNIT</strong></label>
                            <input type="number"  step="0.0001" id="precio" class="pu limpiar form-control">
                        </div>

                        <div class=" form-group col-md-2 col-sm-4 col-xs-4">
                            <label   class="form-control-label" for=""><strong>CANTIDAD</strong></label>
                            <input type="number"  id="cantidad" class="cantidad limpiar solo-enteros form-control">
                        </div>
                        <div class=" form-group col-md-1 col-sm-1">
                            <label class="form-control-label" for="">&nbsp;</label>
                            <button  id="adicionar" type="button" class="btn-add btn-add btn    btn-outline-success "><i class="icon md-plus"></i></button>
                        </div>

                    </div>

                    <table class="table table-cambio table-condensed table-bordered table-detalle">
                        <thead>
                        <tr style="font-weight: bolder">
                            <td align="center">CANT</td>
                            <td align="center">CODIGO</td>
                            <td align="center">TITULO</td>
                            <td align="right">P.UNIT</td>
                            <td align="center">P.TOTAL</td>
                            <td align="center">CANTIDAD</td>
                            <td align="center">CAMBIO</td>

                        </tr>
                        </thead>
                        <tbody>
                        @foreach($credito->contrato->detalle as $k=>$d)
                            <tr>
                                <td align="center" class="cambio_cant_origen">{{$d->cantidad}}</td>
                                <td class="cambio_codigo">{{$d->codigo}}</td>
                                <td class="cambio_titulo">{{$d->titulo}}</td>
                                <td align="right" class="pu_detalle">
                                    <input type="text" name="cambio_precio_unitario[]" size="5%" class="numeroscondecimales cambio_pu" value="{{$d->precio_unitario}}">

                                </td>
                                <td align="right">
                                    <input type="text" class="cambio_precio_total" size="7" value="{{$d->precio_total}}" readonly>
                                    
                                </td>
                                <td align="center">
                                    <input type="text" name="cambio_cantidad[]"  class="solo-enteros cant_marcar cambio_cant" value="{{$d->cantidad}}" size="3%">

                                </td>
                                <td align="center">
                                    <button   type="button" class="btn-cambiar btn btn-xs btn-primary">Cambiar</button>
                                </td>
                                <input type="hidden" name="cambio_codigo[]" value="{{$d->codigo}}">
                                <input type="hidden" name="cambio_titulo[]" value="{{$d->titulo}}">
                                <input type="hidden" name="cambio_libros_id[]" value="{{$d->libros_id}}" class="cambio_libro_id">
                                <input type="hidden" name="cambio[]" value="0" class="">
                            </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <td></td>
                            <td></td>

                            <td ALIGN="right" colspan="2" style="font-weight: bolder">P.VENTA</td>
                            <td align="right" style="font-weight: bolder" class="precio_venta_total">{{$credito->contrato->preciototal}}</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td></td>

                            <td  ALIGN="right" colspan="2" style="font-weight: bolder">SALDO ACTUAL</td>
                            <td align="right" style="font-weight: bolder"><input  style="font-weight: bolder; text-align: right" type="text"  name="saldo_actual"  size="5%" value="{{$credito->saldo_actual}}" class=" saldo_actual form-control form-control-sm numeroscondecimales"></td>
                            <td></td>
                        </tr>
                        </tfoot>
                    </table>




            </div>
            <div class="col-md-5">
                <h5 class="alert alert-info text-primary text-center">LIBROS QUE SALEN</h5>
                <table class="table table-condensed table-bordered table-ingreso">
                    <thead>
                    <tr style="font-weight: bolder">
                        <td align="center">CANT</td>
                        <td align="center" width="10%">CODIGO</td>
                        <td align="center">TITULO</td>
                        <td align="right">P.UNIT</td>
                        <td align="right">P.TOTAL</td>
                        <td>QUITAR</td>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>


            </div>

        </div>
            <div class="col-md-7">
                <h4 class="alert alert-primary">REPROGRAMAR PLAN DE PAGOS</h4>
                <div class="col-md-7">
                <table class="detalleContrato">
                    <tr>
                        <td><label>Numero Pagos</label><input type="text"  class="form-control form-control-sm" name="numcuotas" value="1"  id="numero_cuotas" /></td>
                        <td><label>Dias de Pago</label><input type="text" class="form-control form-control-sm"  name="diaspago" value="30" id="dias_pago" /></td>
                        {{--<td><label>Dias Gracia</label><input type="text" class="form-control form-control-sm" value="0"  id="dias_gracia" /></td>--}}
                        <td><label>Fecha Inicio</label><input type="text"  id="fecha2" class="datepicker form-control form-control-sm" name="fechacuotas" value="<?php echo date("d/m/Y")?>"/></td>
                        <td><label>&nbsp;</label><button type="button" class="btn  btn-sm btn-outline-info"  onclick="verPlanPagos();">CALCULAR </button></td>
                    </tr>

                </table>

                <table  class="table table-bordered " id="tabla-planpagos">
                    <thead>
                    <td>NUM PAGO</td>
                    <td>FECHA<br/>VENCIMIENTO</td>
                    <td>MONTO PAGO</td>
                    </thead>
                    <tbody id="campoCuotas"></tbody>


                </table>
                </div>

            </div>
            <hr>
            <button type="submit" class="btn-guardar btn btn-success btn-block"><i class="icon md-archive"></i>GUARDAR</button>
        </form>
    @endif
@section('scripts')
    <script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.min.js')}}"></script>

    <script>

        var codigos=[]
        var options = {
            theme:'dark',

            url: function(cuenta) {
                return "../common/buscar-cuenta";
            },

            getValue: function(datos) {



                return 'CUENTA:'+datos.numcuenta+'-'+datos.nombre_cliente;
            },
            list: {
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value).trigger("change");
                }
            },


            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },

            preparePostData: function(data) {

                data.term = $(".numcuenta").val();
                data.tipo='numero'
                if($('.tipo_numero').is(':checked')){
                    data.tipo='numero'

                }
                else if($('.tipo_apellidos').is(':checked')){
                    data.tipo='apellidos'

                }
                data.cuenta = $(".numcuenta").val();
                return data;
            },

            requestDelay: 400
        };

        $(".numcuenta").easyAutocomplete(options);

        function buscarCodigo(codigo){
            var sw=false;
            if(codigos.indexOf(codigo)!=-1)
                sw=true;
            return sw;
        }

        function addFilaCambio(datos,sw=false){


       var fila=' <tr>'+
            '<td align="center" class="cambio_cant_origen">'+datos.cantidad+'</td>'+
                '<td class="cambio_codigo">'+datos.codigo+'</td>'+
                '<td class="cambio_titulo">'+datos.titulo+'</td>'+
                '<td align="right" class="pu_detalle">'+
                '<input type="text" name="cambio_precio_unitario[]" size="5%" class="numeroscondecimales cambio_pu" value="'+datos.precio+'">'+
                '</td>'+
           '<td align="right">'+
           '<input type="text" class="cambio_precio_total" size="7" value="'+(parseFloat(datos.precio)*parseInt(datos.cantidad)).toFixed(2)+'" readonly>'+
           '</td>'+
                '<td align="center">'+
                '<input type="text" name="cambio_cantidad[]"  class="solo-enteros cant_marcar cambio_cant" value="'+datos.cantidad+'" size="3%">'+
                '</td>'+
                '<td align="center">';
                  if(!sw) {
                   fila+='<button   type="button" class="btn-cambio_borrar btn btn-xs btn-danger">Borrar</button>'
                  }
                  else{
                      fila+=' <button   type="button" class="btn-cambiar btn btn-xs btn-primary">Cambiar</button>';
                  }
            fila+='</td>'+
                '<input type="hidden" name="cambio_codigo[]" value="'+datos.codigo+'">'+
                 '<input type="hidden" name="cambio_titulo[]" value="'+datos.titulo+'">'+
                '<input type="hidden" name="cambio_libros_id[]" value="'+datos.id+'" class="cambio_libro_id">'+
                 '<input type="hidden" name="cambio[]" value="1" >'+

                '</tr>';

            $('.table-cambio tbody').append(fila)
            recalcularVenta()
            // $('.visible').show()
            // $('.cant_total').val(numerosTabla().cant)
            // $('.precio_total').val(numerosTabla().pt)

        }

        function recalcularVenta(){
            var precioventa_actual=parseFloat($('.precio_venta_total').html())
            var saldo_actual=parseFloat($('.saldo_actual').val())

            var sum=0;

            $('.table-cambio tbody>tr').each(function (k,v){
                 let cant=$(v).find('.cambio_cant_origen').html()
                 let precio=$(v).find('.cambio_pu').val()
                 let precio_total=$(v).find('.cambio_precio_total')
                let aux=parseInt(cant)*parseFloat(precio)
                precio_total.val(aux.toFixed(2))
                sum+=aux

            })
            let diff=precioventa_actual-sum;

            $('.precio_venta_total').html(sum.toFixed(2))
            if(diff<=0){
            $('.saldo_actual').val((saldo_actual+Math.abs(diff)).toFixed(2))
            }
            else{
                $('.saldo_actual').val((saldo_actual-Math.abs(diff)).toFixed(2))

            }

        }
        function verPlanPagos(){

            total_filas_cuotas=0;
            $("#campoCuotas tr").remove();

            var f='';
            fv=$("#fecha2").val();
            nc=$("#numero_cuotas").val();
            dp= $("#dias_pago").val();
            mt=$("#saldofin").val();
            dg=$("#dias_gracia").val();

            $.ajax({

                type: "GET",
                url: "../common/plan-pagos",
                data: {
                    fecha:fv,
                    numcuotas:nc,
                    diaspago:dp,
                    montopago:mt,
                    diasgracia:0,
                    saldo:$('.saldo_actual').val()
                },
                dataType: "json",
                error: function(){
                    alert('ocurrio un error')
                },
                success: function(data){
                  data.datos.forEach(function(v,k){
                      addRowCuotas(v.numcuota,v.fecha,v.monto);

                      console.log(v)
                  })



                }
            });
        }
        function addRowCuotas(cuota,fecha,monto){

            f="<tr><td><input type='text' size=5 name='numcuota[]' value='"+cuota+"'></td><td><input type='text' size=10 name='fechacuota[]' value='"+fecha+"'></td><td><input type='text' size=8 name='montocuota[]'  readonly id='montocuota' value='"+monto+"'></td></tr>";


            $("#campoCuotas").append(f);
            total_filas_cuotas++;
            $("#numfilascuotas").val(total_filas_cuotas);

        }

        $(document).ready(function(){

                $('.fecha').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha.val(),modulo:'COBRANZA'},
             dataType:'json',
             method:'GET',
             async:false,
          

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })

            $('.btn-guardar').click(function(_evt){
               _evt.preventDefault()
                let saldo=parseFloat($('.saldo_actual').val())
                if($('.fecha').val()==''){
                    swal('Alerta','Ingrese una fecha','warning')
                    $(this).focus()
                    return false;
                }

                if(saldo<0){
                   swal('Alerta','El saldo no puede ser meno a cero','warning')
                    return false;
                }
                if(saldo>0){
                   let filas=$('#campoCuotas tr').length
                  if(filas<=0){
                      swal('Alerta','Debe reprogramar  el plan de pagos','warning')
                      return false;
                  }
                }
                swal({
                        title: "Esta seguro?",
                        text: "Se procesara  el cambio de obra. revise bien todo el formulario",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                       $('.form-cambio').submit()
                    });
            })


            $('.numcuenta').click(function(){
               $(this).val('')
            })

            $('body').on('change','.cambio_pu',function(){
                recalcularVenta()
            })

            $('body').on('click','.btn-cambio_borrar',function(){
                $(this).closest('tr').remove()
                recalcularVenta()
            })
            $('body').on('click','.btn-cambiar',function(){
                let fila=$(this).closest('tr')
                let cant=fila.find('.cambio_cant').val();
                let cant_origen=fila.find('.cambio_cant_origen').html();

                let codigo=fila.find('.cambio_codigo').html();
                let titulo=fila.find('.cambio_titulo').html();
                let libro_id=fila.find('.cambio_libro_id').val();
                let pu=fila.find('.cambio_pu').val();
                let precio_total= fila.find('.cambio_precio_total').val();
                let nueva_fila='<tr>'+
                    '<td align="center" class="td_cantidad">'+cant+'</td>'+
                    '<td >'+codigo+'</td>'+
                    '<td >'+titulo+'</td>'+
                    '<td align="right">'+
                    '<input type="text" name="precio_unitario_ingreso[]" size="5%" class="numeroscondecimales ingreso_pu" value="'+pu+'">'+
                    '</td>'+
                    '<td align="right">'+
                    '<input type="text"  readonly name="total_ingreso[]"  class="solo-enteros cant_marcar ingreso_total" value="'+precio_total+'" size="3%">'+
                    '</td>'+
                    '<td align="center">'+
                    '<button   type="button" class="btn-quitar btn btn-xs btn-danger">Quitar</button>'+
                    '<input type="hidden" class="ingreso_codigo" name="codigo_ingreso[]" value="'+codigo+'">'+
                    '<input type="hidden" class="ingreso_cantidad" name="cantidad_ingreso[]" value="'+cant+'">'+
                    '<input type="hidden" class="ingreso_titulo" name="titulo_ingreso[]" value="'+titulo+'">'+
                    '<input type="hidden" class="ingreso_libro_id" name="libros_id_ingreso[]" value="'+libro_id+'" >'+
                    '</td>'+

                    '</tr>';

                $('.table-ingreso tbody').append(nueva_fila);
                if(parseInt(cant)>=parseInt(cant_origen)){
                    fila.remove()
                }
                else{
                    fila.find('.cambio_cant_origen').html(cant)
                }
                recalcularVenta()
            })
            $('body').on('click','.btn-quitar',function(){
                let fila=$(this).closest('tr')
              let datos={
                  cantidad:$(fila).find('.ingreso_cantidad').val(),
                  codigo:$(fila).find('.ingreso_codigo').val(),
                  titulo:$(fila).find('.ingreso_titulo').val(),
                  precio:$(fila).find('.ingreso_pu').val(),
                  id:$(fila).find('.ingreso_libro_id').val(),
              }
              addFilaCambio(datos,true)
                $(this).closest('tr').remove()
            })



            $('.table-ingreso').on('click','.btn-quitar',function(){

            })

            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let stock =$('.select3').find(":selected").attr("stock")
                let precio=$('.pu').val()
                let id =$('.select3').find(":selected").val()
                let cantidad=$('.cantidad').val()
                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if(cantidad=='' || parseInt(cantidad)<=0){
                    swal('Alerta','Ingrese una cantidad valida','warning')
                    return false;
                }
                if(precio=='' || parseInt(precio)<=0){
                    swal('Alerta','Ingrese una precio valido','warning')
                    return false;
                }

                if(parseInt(cantidad)>parseInt(stock)){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;
                }
                var precio_total=(parseInt(cantidad)*parseFloat(precio)).toFixed(2);
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad,
                    precio:precio,
                    precio_total:precio_total
                }

                addFilaCambio(datos)
                // $('.select3').select2('open');
            })
            $('.select3').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });
            $('.select3').on('select2:selecting', function(e) {
                let pu =e.params.args.data.element.attributes.precio.value;
                let stock =e.params.args.data.element.attributes.stock.value;


                if(parseInt(pu)<=0 || pu=='' || typeof(pu)=='undefined'){
                    $('.pu').val(0)
                }
                else{
                    $('.pu').val(pu)
                }
                $('#stock').val(stock)


            });

            $('.select3').on('select2:select', function(e) {
                $('#cantidad').focus();
            });

        })



    </script>
@stop


@endsection