@extends('layouts.admin')
@section('title') CIERRES APERTURAS @stop
@section('titulo')CIERRES APERTURAS @stop
@section('acciones')
    <button class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo Periodo</button>

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Cierres aperturass</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    @include('cierres.create_edit')
    <div class="modales">
    </div>

    <div style="font-size: 11px" class=" col-lg-12 table-responsive">

        <table  id="table"  class="table table-hover  table-striped " >
            <thead>
            <tr>
                <th>NUM</th>
                <th>MODULO</th>
                <th>MES/AÑO</th>
                <th>ESTADO</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($datos as $k=>$r)
                <tr>
                    <td>{{$k+1}}</td>
                    <td>{{$r->modulo}}</td>
                    <td>{{\App\Helper\Helper::mes($r->mes)}}/{{$r->anio}}</td>
                    <td>{{$r->estado}}</td>
                   
                    <td>
                        <a href="cierres/{{$r->id}}/edit" class=" btn-edit btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                        <a href="cierres/{{$r->id}}/delete" class="btn-delete btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

@section('scripts')

    <script>

        $(document).ready(function(){

            $('.btn-edit').click(function(_evt){
              _evt.preventDefault();
              let url=$(this).attr('href')
               $.ajax({
                url:url,
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                   
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })
            })


             $('.btn-delete').click(function(_evt){
              _evt.preventDefault();
              let _href=$(this).attr('href')
                  swal({
                        title: "Esta seguro?",
                        text: "Se eliminara este registro!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });
            
            
            })



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }







            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })


        })

        $('#table').dataTable({

              "lengthMenu": [ [50, 100, 300, 500, -1], [50, 100, 300, 500, "Todos"] ],
        'iDisplayLength': -1,
        "aaSorting": []

        })
    </script>
@stop


@endsection