@extends('layouts.admin')
@section('title')Catalogo @stop
@section('titulo')CATALOGO @stop

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('/reportes-almacen/')}}">Reportes</a></li>
        <li class="breadcrumb-item active">CATALOGO</li>
    </ol>
@stop
@section('content')

    @if(count($libros)>0)
        <div class="btn-group col-md-2 float-right " role="group" >
            <a href="{{url('reportes-almacen/catalogo/excel')}}" class="btn btn-outline-success">EXCEL</a>
            <a href="{{url('reportes-almacen/catalogo/pdf')}}" class="btn btn-outline-danger">PDF</a>

        </div>

        </div>
    @endif
 @include('almacen.reportes.tabla-catalogo')

@section('scripts')

    <script>

        function alerta(id)
        {
            // var id=$(this).attr('id')


            $.ajax({
               url:'./libros/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }



        $(document).ready(function(){



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara el item de los registros!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })



            $('body .btn-edit').on('click',function(){
                alert('')



                var id=$(this).attr('id')


                $.ajax({
                   url:'./libros/'+id+'/edit',
                    method:'GET',
                    dataType:'html',
                    success:function(res){
                        $('.modales').empty();
                        $('.modales').append(res)
                        $('.modal-edit').modal('show')
                        select2();
                    },
                    error:function(){
                        alert('ocurrio un error')
                    }
                })
            })
        })


    </script>
@stop


@endsection