@extends('layouts.admin')
@section('title')kardex Vendedor @stop
@section('titulo')KAREX  DEL VENDEDOR / RESUMEN CARGOS @stop
@section('menu-kardex')active open @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
{{--    <a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nueva Remision</a>--}}


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('/kardex')}}">Kardex Vendedor / Resumen de Cargos </a></li>
    </ol>
@stop
@section('content')

    <div class="nav navbar-nav col-md-6">
        <form class="form-inline " method="get" action="{{url('kardex/cargosvendedores')}}" >
            @include('includes.form-periodo')

            <div class="form-group form-material">
                <button type="submit" name="consulta" value="consulta" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>

    </div>

    @if(count($vendedores)>0)
    <table class="table table-responsive">
          <thead>
        <tr>
        <th>Vendedores</th>    
        <th>Cargos</th>    
        <th>Diferidos</th>    
        <th>Acciones</th>    
        </tr>      
        
        </thead>    
        <tbody>
            @foreach($vendedores as $k=>$v)
            @php 
            $vendedor=\App\Vendedor::find($k);
            @endphp
         <tr>
         <td>{{$vendedor->nombre_completo}}</td>     
         <td>
             @if(isset($v[0])&& $v[0]['estado']=='Remitido'){{$v[0]['suma']}} @endif
             @if(isset($v[1])&& $v[1]['estado']=='Remitido'){{$v[1]['suma']}} @endif
            
            </td>
         <td>
            @if(isset($v[0])&& $v[0]['estado']=='Diferido'){{$v[0]['suma']}} @endif
             @if(isset($v[1])&& $v[1]['estado']=='Diferido'){{$v[1]['suma']}} @endif
            
            
            </td>
        
         {{-- <td>{{$vendedores->where('estado','Remitido')}}</td> --}}
         <td><a href="{{url('kardex/pasar-cargos/'.$mes.'/'.$anio.'/'.$k.'')}}" class="btn btn-primary btn-xs btn-pasar" ><i class="icon md-arrow-right"></i>Pasar los cargos</a></td>     
        </tr>   
            
            @endforeach
        </tbody>    
    </table>

    @else
    <h4 class="text">NO SE ENCONTRARON DATOS</h4>
    @endif



   
    <div class="modal-ver modal fade modal-slide-in-right" tabindex="-1" style="z-index:99999 !important;"  role="dialog" aria-labelledby="myModalLabel" data-backdrop="false" style="background-color: rgba(0, 0, 0, 0.5);">
        <div class="modal-dialog" role="document">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">
                             <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>



@section('scripts')
    <script>

        $(document).ready(function(){
   $('.btn-pasar').click(function (_evt) {
                _evt.preventDefault();
                var _href=$(this).attr('href')
                swal({
                        title: "Esta seguro?",
                        text: "Se pasaran todos los libros remitidos como cargos al siguiente mes.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        window.location=_href

                    });

            })
           
            });




    </script>
@stop


@endsection