<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facade;
use Illuminate\Support\Facades\DB;


class Vendedor extends Model
{
    protected  $table='vendedores';
    protected  $fillable=[
        'codigo',
        'nombres',
        'apellidos',
        'carnet',
        'telefono',
        'email',
        'direccion',
        'estatus',
        'nacionalidad',
        'tipo_documento',
        'supervisor',
        'credito',
        'tipocomisioncredito',
        'valorcomisioncredito',
        'tipocomisioncontado',
        'valorcomisioncontado'
    ];
    public $timestamps=false;

    public function getNombreCompletoAttribute(){
        return $this->nombres.' '.$this->apellidos;
    }

    public static function permitirPasarCargos($mes,$anio,$vendedor)
    {
        $sw=true;
        $sql=DB::table('acciones')
        ->where('operario_id',$vendedor)
        ->where('accion','pasarcargos')
        ->where('mes',$mes)
        ->where('anio',$anio)
        ->where('estado',1)
        ->where('modulo','ALMACEN')
        ->first();

        if(!is_null($sql)){
            $sw=false;
        }

        return $sw;

    }

    public function  getCreditoDisponibleAttribute(){

        $sql=Kardex::where('vendedor_id',$this->id)
                     ->whereIn('cargo',['0','1'])
                     ->where('estado','Remitido')
                     ->count('id');
        $credito_disponible=$this->credito-$sql;
        return $credito_disponible;

    }

    public function supervisornombre(){
    return $this->belongsTo(Vendedor::class,'supervisor');
    }


}
