<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Recibo extends Model
{
  protected $table='recibos';
  protected $fillable=[
        'monto',
        'fecha',
        'descripcion',
        'nombres',
        'numero',
        'model_id',
        'model_type',
        'cinit',

  ];
  public $dates=['fecha'];
    public function setFechaAttribute($fecha)
    {
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public static function pagosCuotaInicial($pago_id){
        $sql=self::where('model_type','pagos')
            ->where('model_id',$pago_id)
            ->first();
        return $sql;
    }
}
