<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class NotasRemision extends Model
{
    protected $table='remision';
    protected  $fillable=[
        'fecha',
        'vendedor_id',
        'estado',
        'cant_total',
        'almacen_id',
        'user_id',
        'obs',

    ];
    protected $dates=['fecha'];


    public function vendedor(){
        return $this->belongsTo(Vendedor::class,'vendedor_id');
    }

    public function borrarKardex(){
        return true;
    }
    public function setFechaAttribute($fecha){
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }


    public function getEstadoAttribute(){
        switch($this->attributes['estado']){
            case 'G': return 'CREADO'; break;
            case 'T': return 'PROCESADO'; break;
            case 'A': return 'ANULADO'; break;
        }

}
    public function  user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function detalle(){
        return $this->hasMany(DetalleRemision::class,'remision_id')->orderBy('codigo','ASC');
    }


}
