<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class NotasIngreso extends Model
{
    protected $table='ingreso';
    protected $fillable=[
        'recibe',
        'envia',
        'fecha',
        'concepto',
        'cant_total',
        'estado',
        'precio_total',
        'user_id',
        'almacen_id',
        'terminado',
        'moneda',
        'valor_cambio',
        'obs',
        'glosa'
    ];
    protected  $dates=['fecha'];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function getEstadoAttribute()
    {
        switch ($this->attributes['estado']) {
            case 'G':
                return 'CREADO';
                break;
            case 'T':
                return 'PROCESADO';
                break;
            case 'A':
                return 'ANULADO';
                break;
        }
    }
    public function setFechaAttribute($fecha){
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public function detalle(){
        return $this->hasMany(DetalleIngreso::class,'ingreso_id')->orderBy('codigo','ASC');
    }


}
