<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class Kardex extends Model
{
    protected $table = 'kardexvendedor';
    protected $fillable = [
        'fecha_remision',
        'remision_id',
        'devolucion_id',
        'fecha_devolucion',
        'cod_libro',
        'titulo_libro',
        'estado',
        'num_contrato',
        'reg_ventas',
        'nombres_cliente',
        'vendedor_id',
        'tomo_libro',
        'libro_id',
        'almacen_id',
        'contrato_id',
        'cargo',
        'traspaso',
        'traspaso_id',
        'fechakardex',
    ];

    protected $dates = [
        'fechakardex',
        'fecha_devolucion',
        'fecha_remision'
    ];
    public $timestamps = false;

    public function libro()
    {
        return $this->belongsTo(Libro::class, 'libro_id');
    }
    public function contrato()
    {
        return $this->belongsTo(Contrato::class, 'contrato_id');
    }
    public function vendedor()
    {
        return $this->belongsTo(Vendedor::class, 'vendedor_id');
    }
    public function traspaso()
    {
    }
    public function remision()
    {
        return $this->belongsTo(NotasRemision::class, 'remision_id');
    }
    public function devolucion()
    {
        return $this->belongsTo(NotasDevolucion::class, 'devolucion_id');

    }

    public function setFechakardexAttribute($fecha)
    {
        $this->attributes['fechakardex'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }
    public function setFechaDevolucionAttribute($fecha)
    {
        $this->attributes['fecha_devolucion'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }
    static function validarDisponiblesRemision(NotasRemision $remision)
    {
        $kardex = self::where('remision_id', $remision->id)
            ->whereIn('estado', ['Devuelto', 'DevueltoObras', 'Venta', 'Diferido', 'Traspaso'])
            ->get()
            ->count();
        return $kardex;
    }

    static function asignarDevolucion($codigo, $cantidad, NotasDevolucion $devolucion)
    {

        $result = true;
        $filas_kardex = Kardex::select('cod_libro', 'fechakardex', 'fecha_remision', 'id')
            ->where('vendedor_id', $devolucion->vendedor_id)
            ->where('cod_libro', $codigo)
            ->whereMonth('fechakardex', '=', $devolucion->fecha->month)
            ->whereYear('fechakardex', '=', $devolucion->fecha->year)
            ->whereIn('estado', ['Remitido'])
            ->whereIn('cargo', [1, 0])
            // ->where('traspaso',0)
            ->orderBy('fecha_remision', 'ASC')
            ->take($cantidad)
            ->get();

            // return dd($filas_kardex->toArray(),count($filas_kardex));



        if (count($filas_kardex) > 0) {

            foreach ($filas_kardex as $f) {
                $kardex = Kardex::find($f->id);
                $kardex->fecha_devolucion = $devolucion->fecha->format('d/m/Y');
                $kardex->devolucion_id = $devolucion->id;
                $kardex->estado = 'Devuelto';
                $kardex->save();

            }
        } else {
            $result = false;
        }
        return $result;


    }

    static function asignarVentaDirecta(Contrato $contrato)
    {

        try {
            if (isset($contrato)) {

                foreach ($contrato->detalle as $d) {

                    $result = true;
                    $filas_kardex = Kardex::select('cod_libro', 'fechakardex', 'fecha_remision', 'id')
                        ->where('vendedor_id', $contrato->idchofer)
                        ->where('cod_libro', $d->codigo)
                        ->whereMonth('fechakardex', '=', $contrato->fechacontrato->month)
                        ->whereYear('fechakardex', '=', $contrato->fechacontrato->year)
                        ->where('estado', 'Remitido')
                        ->whereIn('cargo', [1, 0])
                        ->take($d->cantidad)
                        ->orderBy('fecha_remision', 'ASC')
                        ->get();

                    if (count($filas_kardex) > 0 && count($filas_kardex) == $d->cantidad) {

                        if ($contrato->idchofer == $contrato->idvendedor) {

                            foreach ($filas_kardex as $f) {
                                $kardex = Kardex::find($f->id);
                                $kardex->num_contrato = $contrato->numcontrato;
                                $kardex->estado = 'Venta';
                                $kardex->contrato_id = $contrato->id;
                                $kardex->save();

                            }
                        } else {
                            foreach ($filas_kardex as $f) {
                                $kardex = Kardex::find($f->id);
                                $k2 = $kardex->replicate();
                                $kardex->num_contrato = $contrato->numcontrato;
                                $kardex->estado = 'Venta';
                                $kardex->contrato_id = $contrato->id;
                                $kardex->vendedor_id = $contrato->idvendedor;
                                $kardex->save();


                                $k2->estado = 'Traspaso';
                                $k2->num_contrato = $contrato->numcontrato;
                                $k2->contrato_id = $contrato->id;
                                $k2->traspaso = 1;
                                $k2->save();

                            }

                        }
                    } else {
                        $result = false;
                        break;

                    }
                }



            }
        } catch (\Exception $e) {

            // DB::rollBack();
            $result = false;
            return dd($e);
        }
        return $result;

    }

    static function asignarVentaDirecta2(Contrato $contrato, $numcuenta)
    {

        try {
            DB::beginTransaction();
            if (isset($contrato)) {

                Kardex::where('contrato_id', $contrato->id)
                    ->where('vendedor_id', $contrato->idvendedor)
                    ->update([
                        'estado' => 'Venta',
                        'reg_ventas' => $numcuenta

                    ]);

                DB::commit();
                return true;
            }
        } catch (\Exception $e) {
            DB::rollBack();

            return false;
        }


    }


    static function asignarVenta(Contrato $contrato)
    {

        $result = true;
        try {
            DB::beginTransaction();
            $filas_kardex = Kardex::where('vendedor_id', $contrato->idvendedor)
                ->where('contrato_id', $contrato->id)
                ->where('num_contrato', $contrato->numcontrato)
                ->whereIn('cargo', [0, 1])
                ->update([
                    'estado' => 'Venta',
                    'reg_ventas' => $contrato->credito->num_cuenta,

                ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            $result = false;
        }

        return $result;


    }

    static function asignarDiferido($codigo, $cantidad, Contrato $contrato)
    {

        try {
            \DB::beginTransaction();
            // return dd($contrato,$codigo,$cantidad);
            $result = true;
            $filas_kardex = Kardex::select('cod_libro', 'fechakardex', 'fecha_remision', 'id')
                ->where('vendedor_id', $contrato->idchofer)
                ->where('cod_libro', $codigo)
                ->whereMonth('fechakardex', '=', $contrato->fechacontrato->month)
                ->whereYear('fechakardex', '=', $contrato->fechacontrato->year)
                ->where('estado', 'Remitido')
                ->whereIn('cargo', [1, 0])
                ->take($cantidad)
                ->orderBy('fecha_remision', 'ASC')
                ->get();


            if (count($filas_kardex) > 0) {

                if ($contrato->idchofer == $contrato->idvendedor) {

                    foreach ($filas_kardex as $f) {
                        $kardex = Kardex::find($f->id);
                        $kardex->num_contrato = $contrato->numcontrato;
                        $kardex->estado = 'Diferido';
                        $kardex->contrato_id = $contrato->id;
                        $kardex->save();

                    }
                } else {
                   
                    foreach ($filas_kardex as $f) {
                        $kardex = Kardex::find($f->id);
                        $k2 = $kardex->replicate();
                        $kardex->num_contrato = $contrato->numcontrato;
                        $kardex->estado = 'Diferido';
                        $kardex->contrato_id = $contrato->id;
                        $kardex->vendedor_id = $contrato->idvendedor;
                        $kardex->save();


                        $k2->estado = 'Traspaso';
                        $k2->num_contrato = $contrato->numcontrato;
                        $k2->contrato_id = $contrato->id;
                        $k2->traspaso = 1;
                        $k2->save();

                    }

                }
            } else {
                
                $result = false;
            }
            DB::commit();
            return $result;

        } catch (\Exception $e) {

            // return dd($e);
            DB::rollBack();

            return false;
        }


    }
    public static function kardexDocumento($tipo, $id)
    {
        $tipo_documento = '';
        $numero = '';
        switch ($tipo) {
            case 'contrato':
                $datos = Kardex::where('contrato_id', $id)->orderBy('cod_libro', 'ASC')->get();
                $tipo_documento = 'CONTRATO';
                $numero = $id;
                break;
            case 'devolucion':
                $datos = Kardex::where('devolucion_id', $id)
                    ->whereIn('estado', ['Devuelto', 'DevueltoObras'])
                    ->orderBy('cod_libro', 'ASC')->get();
                $tipo_documento = 'DEVOLUCION';
                $numero = $id;
                break;
            case 'remision':
                $datos = Kardex::where('remision_id', $id)
                    // ->where('estado', 'Remitido')
                    ->orderBy('cod_libro', 'ASC')->get();
                $tipo_documento = 'REMISION';
                $numero = $id;
                break;
        }
        $totales = [];

        if (count($datos) > 0) {
            $sum_remision = 0;
            $sum_devolucion = 0;
            $sum_diferidos = 0;
            $sum_traspaso = 0;
            $sum_ventas = 0;
            foreach ($datos as $f) {
                switch ($f->estado) {
                    case 'Remitido':
                        $sum_remision++;
                        break;
                    case 'Devuelto':
                        $sum_devolucion++;
                        break;
                    case 'DevueltoObras':
                        $sum_devolucion++;
                        break;
                    case 'Diferido':
                        $sum_diferidos++;
                        break;
                    case 'Traspaso':
                        $sum_traspaso++;
                        break;
                    case 'Venta':
                        $sum_ventas++;
                        break;
                }
            }
            $totales = [
                'sum_remision' => $sum_remision,
                'sum_devolucion' => $sum_devolucion,
                'sum_diferidos' => $sum_diferidos,
                'sum_traspaso' => $sum_traspaso,
                'sum_ventas' => $sum_traspaso,
                'total' => $sum_ventas + $sum_traspaso + $sum_diferidos + $sum_devolucion + $sum_remision
            ];

        }
        return ['datos' => $datos, 'totales' => $totales, 'tipo_documento' => $tipo_documento, 'numero' => $numero];
    }

    public static function kardexVendedor($vendedor_id, $mes, $anio)
    {
        $datos = self::where('vendedor_id', $vendedor_id)
            ->whereMonth('fechakardex', '=', $mes)
            ->whereYear('fechakardex', '=', $anio)
            ->orderBy('fechakardex', 'ASC')
            ->get();
        $totales = [];

        if (count($datos) > 0) {
            $sum_remision = 0;
            $sum_devolucion = 0;
            $sum_diferidos = 0;
            $sum_traspaso = 0;
            $sum_ventas = 0;
            foreach ($datos as $f) {
                switch ($f->estado) {
                    case 'Remitido':
                        $sum_remision++;
                        break;
                    case 'Devuelto':
                        $sum_devolucion++;
                        break;
                    case 'DevueltoObras':
                        $sum_devolucion++;
                        break;
                    case 'Diferido':
                        $sum_diferidos++;
                        break;
                    case 'Traspaso':
                        $sum_traspaso++;
                        break;
                    case 'Venta':
                        $sum_ventas++;
                        break;
                }
            }
            $totales = [
                'sum_remision' => $sum_remision,
                'sum_devolucion' => $sum_devolucion,
                'sum_diferidos' => $sum_diferidos,
                'sum_traspaso' => $sum_traspaso,
                'sum_ventas' => $sum_traspaso,
                'total' => $sum_ventas + $sum_traspaso + $sum_diferidos + $sum_devolucion + $sum_remision
            ];

        }
        return ['datos' => $datos, 'totales' => $totales];
    }
    public static function pasarCargos($vendedor_id, $mes, $anio)
    {

        try {
            DB::beginTransaction();
            $mes_sig = $mes + 1;
            $anio_sig = $anio;
            if ($mes == 12) {
                $mes_sig = 1;
                $anio_sig = $anio + 1;
            }
            $fecha_sig = '1/' . $mes_sig . '/' . $anio_sig;
            $datos = self::where('vendedor_id', $vendedor_id)
                ->whereMonth('fechakardex', '=', $mes)
                ->whereYear('fechakardex', '=', $anio)
                ->whereIn('cargo', [0, 1])
                ->whereIn('estado', ['Remitido', 'Diferido']);


            if (count($datos->get()) > 0) {
                $filas = [];
                foreach ($datos->get() as $d) {
                    $d->fechakardex = $fecha_sig;
                    $d->cargo = 1;
                    $d->id = null;
                    $filas[] = $d->toArray();
                }

                Kardex::insert($filas);
                $datos->update(['cargo' => 2]);
            }

            DB::table('acciones')->insert([
                'accion' => 'pasarcargos',
                'operario_id' => $vendedor_id,
                'modulo' => 'ALMACEN',
                'mes' => $mes,
                'anio' => $anio,
                'estado' => 1,

            ]);



            DB::commit();
        } catch (\Exception $e) {
//            return dd($e);
            DB::rollBack();
            return false;

        }
        return true;



    }


    static function CargosVendedorDevolucion($vendedor_id, $mes, $anio)
    {
        $libros = [];
        $kardex = Kardex::selectRaw('COUNT(cod_libro) as cont,cod_libro')
            ->where('vendedor_id', $vendedor_id)
            ->whereMonth('fechakardex', '=', $mes)
            ->whereYear('fechakardex', '=', $anio)
            ->whereIn('estado', ['Remitido'])
            ->whereIn('cargo', [1, 0])
            ->join('libros as l', 'l.codigo', '=', 'kardexvendedor.cod_libro')
            ->groupBy('cod_libro')
            ->get()
            ->toArray();
        if (count($kardex) > 0) {
            foreach ($kardex as $k => $v) {
                $libro = Libro::getDatosCodigo($v['cod_libro']);
                if (!is_null($libro)) {
                    $libros[] = [
                        'codigo' => $v['cod_libro'],
                        'cantidad' => $v['cont'],
                        'tomo' => $libro->tomo,
                        'titulo' => $libro->titulo,
                        'id' => $libro->id,
                        'precio_base' => $libro->precio_base


                    ];
                }
            }
        }
        return $libros;
    }

    public static function cargosVendedor($mes, $anio, $id)
    {

        $fecha_ant = Carbon::createFromDate($anio, $mes, 1)->addDays(-1);

        $datos = [];
        $libros = Kardex::select('cod_libro')
            ->where('vendedor_id', $id)
            ->whereMonth('fechakardex', '=', $mes)
            ->whereYear('fechakardex', '=', $anio)
            ->where('estado', '!=', 'A')
            ->whereIn('cargo', [0, 1, 2])
            ->groupBy('cod_libro')->get();
        foreach ($libros as $r) {


            $titulo = Libro::select('titulo')->where('codigo', $r->cod_libro)->first()->titulo;
            if (!$titulo) {
                $titulo = 'SIN TITULO';
            }

            $remision_ant = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $fecha_ant->month)
                ->whereYear('fechakardex', $fecha_ant->year)
                ->where('vendedor_id', $id)
//                                ->whereIn('estado',['Remitido','Cargo'])
                ->whereIn('cargo', [0, 1])

                ->count('id');
        //    $cubiertos_ant=Kardex::where('cod_libro',$r->cod_libro)
        //        ->whereMonth('fechakardex',$fecha_ant->month)
        //        ->whereYear('fechakardex',$fecha_ant->year)
        //        ->where('vendedor_id',$id)

        //        ->whereIn('estado',['Devuelto','Diferido','Venta','DevueltoObras','traspaso'])
        //        ->whereIn('cargo',[0,2])
        //        ->count('id');

            $cubiertos_ant = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $fecha_ant->month)
                ->whereYear('fechakardex', $fecha_ant->year)
                ->where('vendedor_id', $id)
                ->whereIn('estado', ['Remitido', 'Diferido'])
                ->whereIn('cargo', [0, 1])
                ->count('id');




            $remision_act = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $mes)
                ->whereYear('fechakardex', $anio)
                ->where('vendedor_id', $id)
            //    ->where('estado','Remitido')
                ->whereIn('cargo', [0, '1'])

                ->count('id');
            $devolucion_act = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $mes)
                ->whereYear('fechakardex', $anio)
                ->where('vendedor_id', $id)
                ->whereIn('estado', ['Devuelto', 'DevueltoObras'])

                ->count('id');
            $diferido_act = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $mes)
                ->whereYear('fechakardex', $anio)
                ->where('vendedor_id', $id)
                ->where('estado', 'Diferido')
            //    ->whereIn('cargo',[0,1])
                ->count('id');
            $venta_act = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $mes)
                ->whereYear('fechakardex', $anio)
                ->where('vendedor_id', $id)
                ->where('estado', 'Venta')

                ->count('id');
            $traspaso_act = Kardex::where('cod_libro', $r->cod_libro)
                ->whereMonth('fechakardex', $mes)
                ->whereYear('fechakardex', $anio)
                ->where('vendedor_id', $id)
                ->where('estado', 'Traspaso')

                ->count('id');


            $saldo_ant = $cubiertos_ant;
            $total_cubrir = $saldo_ant + $remision_act;
            $total_cubiertos = $devolucion_act + $diferido_act + $venta_act + $traspaso_act;
            $saldo_cierre = $total_cubrir - $total_cubiertos;

            $datos[] = [
                'codigo' => $r->cod_libro,
                'titulo' => $titulo,
                'cargo_ant' => $saldo_ant,
                'remisiones' => $remision_act,
                'total_cubrir' => $total_cubrir,
                'devoluciones' => $devolucion_act,
                'traspasos' => $traspaso_act,
                'facturados' => $venta_act,
                'diferidos' => $diferido_act,
                'total_cubiertos' => $total_cubiertos,
                'saldo_cierre' => $saldo_cierre

            ];




        }
        return Collection::make($datos)->sortby('codigo');

    }
//    public function setFechaRemisionAttribute($fecha){
////        $this->attributes['fecha_remision']=Carbon::createFromFormat('d/m/Y',$fecha);
//        $this->attributes['fecha_remision']='2018-01-01';
//    }

}
