<?php
namespace App\Http\Controllers;
use App\cobrador;
use App\Contrato;
use App\DetalleContrato;
use App\Helper\Helper;
use App\Vendedor;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use  Excel;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\AgendaVentasExport;
use App\Exports\PlanillaVentasPorOrganizacionExport;
use App\Exports\PlanillaGeneralVentasExport;
use App\Exports\CuadroProduccionVentasExport;
use App\Exports\ComportamientoVentasExport;
use App\Exports\RelacionObrasVendidasExport;
use App\Exports\ComisionesVentaExport;
class ReporteVentasController extends Controller
{
    public function agenda(Request $request)
    {
        //            return dd($request->all());
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $mes = date('m');
        $anio = date('Y');
        $filtro = 'MES';
        $acumulado = Carbon::now();
        $fecha_ref = Carbon::now();
        $datos = [];
        $vendedor = 0;
        if (!is_null($request->consultar)) {
            // return dd($request->all());
            $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
            $fecha_ref = Carbon::createFromFormat('d/m/Y', $request->fecha_ref);
            $acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
            $mes = $request->mes;
            $anio = $request->anio;
            $filtro = $request->filtro;
            $vendedor = $request->vendedor;
            // return dd($filtro);
            $datos = Contrato::agenda($fecha_ini, $fecha_fin, $fecha_ref, $vendedor, $mes, $anio, $acumulado, $filtro);
            //         return dd($datos);
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $nombrearchivo = 'cobro-cuotas';
                if ($vendedor != 0) {
                    $nombre_vendedor = Vendedor::find($vendedor)->nombre_completo;
                }
                $detalles = [
                    'fecha_ini' => $fecha_ini->format('d-m-Y'),
                    'fecha_fin' => $fecha_fin->format('d-m-Y'),
                    'fecha_ref' => $fecha_ref->format('d-m-Y'),
                    'vendedor' => $vendedor,
                    'mes' => Helper::mes($mes),
                    'anio' => $anio,
                    'acumulado' => $acumulado->format('d-m-Y'),
                    'filtro' => $filtro
                ];
                if ($tipo == 'excel') {
                    return \Excel::download(new AgendaVentasExport($datos, $detalles), 'agenda-ventas.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('ventas.reportes.agenda.agenda-exportar', [
                        'datos' => $datos,
                        'estilos' => true,
                        'detalles' => $detalles
                    ]);
                    $pdf->setPaper('a4', 'portrait');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        return view('ventas.reportes.agenda.agenda', [
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_ref' => $fecha_ref,
            'mes' => $mes,
            'anio' => $anio,
            'filtro' => $filtro,
            'fecha_acumulado' => $acumulado,
            'datos' => $datos,
            'vendedores' => $vendedores,
            'vendedor' => $vendedor
        ]);
    }
    public function planillaProduccion(Request $request)
    {
        $datos = [];
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $vendedor_id = 0;
        $cobrador_id = 0;
        $filtro = 'MES';
        $tipo = 'DIFERIDO';
        $table = DB::table('view_contrato_credito');
        if ($request->consultar == 'consultar') {
            $mes = $request->mes;
            $anio = $request->anio;
            $fecha_ini = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            $fecha_fin = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
            $fecha_acumulado = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
            $vendedor_id = $request->vendedor;
            $cobrador_id = $request->cobrador;
            $filtro = $request->filtro;
            $tipo = $request->tipo;
            if ($request->filtro == "MES" && $request->tipo == "CREDITO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', $mes)->whereYear('fechadoc', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "DIFERIDO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechacontrato', $mes)->whereYear('fechacontrato', $anio)->where('tipocontrato', 'DIFERIDO')->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTADO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', $mes)->whereYear('fechadoc', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTCRED" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', $mes)->whereYear('fechadoc', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTCRED" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereMonth('fechadoc', $mes)->whereYear('fechadoc', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTCRED" && $request->cobrador != "" && $request->vendedor != "")
                $datos = $table->whereMonth('fechadoc', $mes)->whereYear('fechadoc', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('cobrador_id', $cobrador_id)->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CREDITO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "DIFERIDO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTADO" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTCRED" && $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CREDITO" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "DIFERIDO" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->where('idvendedor', $vendedor_id)->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTADO" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTCRED" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CREDITO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "DIFERIDO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->where('cobrador_id', $cobrador_id)->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTADO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "RANGO" && $request->tipo == "CONTCRED" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CREDITO" &&  $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA'])->where('tipoventa', 'credito')->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "DIFERIDO" &&  $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechacontrato', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTADO" &&  $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTCRED" &&  $request->cobrador == "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['credito', 'contado'])->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CREDITO" &&  $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "DIFERIDO" &&  $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechacontrato', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->where('idvendedor', $vendedor_id)->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTADO" &&  $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTCRED" &&  $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['credito', 'contado'])->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CREDITO" &&  $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "DIFERIDO" &&  $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechacontrato', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->where('tipocontrato', 'DIFERIDO')->where('cobrador_id', $cobrador_id)->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTADO" &&  $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "ACUMULADO" &&  $request->tipo == "CONTCRED" &&  $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereBetween('fechadoc', ['2017-01-01', $fecha_acumulado->format('Y-m-d')])->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['credito', 'contado'])->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CREDITO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CREDITO" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'credito')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "DIFERIDO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechacontrato', '=', $mes)->whereYear('fechacontrato', '=', $anio)->where('tipocontrato', 'DIFERIDO')->where('cobrador_id', $cobrador_id)->orderBy('numcontrato', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "DIFERIDO" && $request->cobrador == "" && $request->vendedor != "") {
                $datos = $table->whereMonth('fechacontrato', '=', $mes)->whereYear('fechacontrato', '=', $anio)->where('tipocontrato', 'DIFERIDO')->where('idvendedor', $vendedor_id)->orderBy('numcontrato', 'ASC')->get();
            }
            if ($request->filtro == "MES" && $request->tipo == "DIFERIDO" && $request->cobrador != "" && $request->vendedor != "") {
                $datos = $table->whereMonth('fechacontrato', '=', $mes)->whereYear('fechacontrato', '=', $anio)->where('tipocontrato', 'DIFERIDO')->where('idvendedor', $vendedor_id)->where('cobrador_id', $cobrador_id)->orderBy('numcontrato', 'ASC')->get();
            }
            if ($request->filtro == "MES" && $request->tipo == "CONTADO" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTADO" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTCRED" && $request->cobrador != "" && $request->vendedor == "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('cobrador_id', $cobrador_id)->orderBy('numcuenta', 'ASC')->get();
            if ($request->filtro == "MES" && $request->tipo == "CONTCRED" && $request->cobrador == "" && $request->vendedor != "")
                $datos = $table->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('tipoventa', ['contado', 'credito'])->where('idvendedor', $vendedor_id)->orderBy('numcuenta', 'ASC')->get();
        }
        if (isset($request->tipoexportacion)) {
            $nombrearchivo = 'planilla_de_produccion';
            $detalles = [
                'mes' => $request->mes,
                'anio' => $request->anio,
                'fecha_ini' => $request->fecha_ini,
                'fecha_fin' => $request->fecha_fin,
                'fecha_acumulado' => $request->fecha_acumulado,
                'vendedor_id' => $request->vendedor,
                'cobrador_id' => $request->cobrador,
                'filtro' => $request->filtro,
                'tipo' => $request->tipo,
            ];
            if ($request->tipoexportacion == 'excel') {
                // header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
                // header("content-disposition: attachment;filename=PlanillaProduccion.xls");
                return \Excel::download(new PlanillaGeneralVentasExport($datos, $detalles),  $nombrearchivo . '.xlsx');
            }
            if ($request->tipoexportacion == 'pdf') {
                //                return dd($datos);
                $pdf = PDF::loadView('ventas.reportes.planilla_produccion.exportar', [
                    'datos' => $datos,
                    'detalles' => $detalles,
                    'estilos' => true,
                ]);
                $pdf->setPaper([0, 0, 650, 750], 'landscape');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('ventas.reportes.planilla_produccion.index', [
            'datos' => $datos,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
            'vendedor_id' => $vendedor_id,
            'cobrador_id' => $cobrador_id,
            'filtro' => $filtro,
            'tipo' => $tipo
        ]);
    }
    public function index()
    {
        return view('ventas.reportes.index');
    }
    public function comisionesOrganizacion(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        $vendedor = 0;
        $datos = [];
        if (isset($request->consultar)) {
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            if ($vendedor == '') {
                // return $request->mes;
                $sql = Contrato::selectRaw('Sum(preciototal) as precioventa,COUNT(cre.id) as cantcred , sum(cre.cuotainicial) as cuotainicial, sum(cre.valorcomisionable) as preciobasico,contratos.idvendedor, CONCAT_WS(" ",ven.nombres,ven.apellidos) as nombres, sum(cre.montocomision) as comision, sum(cre.cuentacomision) as cuentacomision')
                    ->join('credito as cre', 'cre.contrato_id', '=', 'contratos.id')
                    ->join('vendedores as  ven', 'ven.id', '=', 'contratos.idvendedor')
                    ->where('cre.numcuenta', '!=', '')
                    ->WhereMonth('cre.fechadoc', '=', $request->mes)
                    ->WhereYear('cre.fechadoc', '=', $request->anio)
                    ->groupBy('contratos.idvendedor', 'nombres')
                    ->get();
            } else {
                $sql = Contrato::selectRaw('Sum(preciototal) as precioventa, sum(cre.cuotainicial) as cuotainicial, COUNT(cre.id) as cantcred, sum(cre.valorcomisionable) as preciobasico,contratos.idvendedor, CONCAT_WS(" ",ven.nombres,ven.apellidos) as nombres,sum(cre.montocomision) as comision, sum(cre.cuentacomision) as cuentacomision')
                    ->join('credito as cre', 'cre.contrato_id', '=', 'contratos.id')
                    ->join('vendedores as  ven', 'ven.id', '=', 'contratos.idvendedor')
                    ->where('contratos.idvendedor', $vendedor)
                    ->where('cre.numcuenta', '!=', '')
                    ->WhereMonth('cre.fechadoc', '=', $request->mes)
                    ->WhereYear('cre.fechadoc', '=', $request->anio)
                    ->groupBy('contratos.idvendedor', 'nombres')
                    ->get();
            }
            //           return dd($sql->toArray());
            foreach ($sql as $k => $v) {
                //    $cantidad=DetalleContrato::selectRaw('cantidad')
                //        ->join('contratos as  c','c.id','=','contrato_id')
                //        ->join('credito as cre','cre.contrato_id','=','c.id')
                //     //    ->whereIn('c.tipocontrato',['VENTA','CUENTA'])
                //        ->where('cre.numcuenta','!=','')
                //        ->WhereMonth('cre.fechadoc','=',$request->mes)
                //        ->WhereYear('cre.fechadoc','=',$request->anio)
                //       ->where('c.idvendedor',$v->idvendedor)
                //        ->sum('cantidad');
                $cantidad = $v->cantcred;
                //    return dd($cantidad);
                $porcentaje = ($v->comision * 100) / $v->precioventa;
                $totalcomision = ($v->precioventa * $porcentaje) / 100;
                $total_pagar = $totalcomision - $v->cuentacomision;
                $datos[] = [
                    'vendedor' => $v->nombres,
                    'cantidad' => $cantidad,
                    'precioventa' => $v->precioventa,
                    'cuotainicial' => $v->cuotainicial,
                    'dsctolibros' => '',
                    'dsctodevo' => '',
                    'preciobasico' => $v->preciobasico,
                    'porcentaje' => $porcentaje,
                    'totalcomision' => $totalcomision,
                    'cuentacomision' => $v->cuentacomision,
                    'anticipo' => '',
                    'totalporpagar' => $total_pagar
                ];
            }
            if (isset($request->tipoexportacion)) {
                $nombrearchivo = 'Comisiones_Organizacion_' . $mes . '_' . $anio;
                if ($vendedor != '') {
                    $vendedor = Vendedor::find($vendedor)->nombre_completo;
                }
                $detalles = [
                    'mes' => Helper::mes($mes),
                    'anio' => $anio,
                    'venderor' => $vendedor
                ];
                if ($request->tipoexportacion == 'excel') {
                    return \Excel::download(new ComisionesVentaExport(Collection::make($datos), $detalles), $nombrearchivo . '.xlsx');
                }
                if ($request->tipoexportacion == 'pdf') {
                    $pdf = PDF::loadView('ventas.reportes.comisiones_organizacion.exportar', [
                        'datos' => Collection::make($datos),
                        'detalles' => $detalles,
                        'estilos' => true,
                    ]);
                    $pdf->setPaper([0, 0, 650, 750], 'landscape');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        return view('ventas.reportes.comisiones_organizacion.index', [
            'datos' => Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'vendedor' => $vendedor
        ]);
    }
    public function produccionDiaria(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        if (isset($request->consultar)) {
            $mes = $request->mes;
            $anio = $request->anio;
            $table = DB::table('view_contrato_credito');
            $sql = "SELECT idvendedor, COUNT(numcuenta) as cont, SUM(preciototal) as ptotal, SUM(valorcomisionable) as comision, SUM(cuotainicial) as cuota ,fechadoc FROM view_contrato_credito GROUP BY idvendedor,fechadoc,tipocontrato HAVING (tipocontrato='VENTA' or tipocontrato='CUENTA' or tipocontrato='DEVUELTO-COBRANZA') AND (Month(fechadoc)='" . $mes . "'  AND YEAR(fechadoc)= '" . $anio . "')";
            //            $sql="SELECT idvendedor, COUNT(numcuenta) as cont, SUM(preciototal) as ptotal, SUM(valorcomisionable) as comision, SUM(cuotainicial) as cuota ,fechacontrato FROM view_contrato_credito GROUP BY idvendedor,fechacontrato,tipocontrato HAVING (tipocontrato='DIFERIDO' or tipocontrato='CUENTA') AND (fechacontrato BETWEEN '".$fecha_ini->format('Y-m-d')."'  AND '".$fecha->format('Y-m-d')."')";
            $datos = Collection::make(DB::select($sql))->groupBy('idvendedor');
            //            return dd($datos);
        }
        if (isset($request->tipoexportacion)) {
            $nombrearchivo = 'Produccion diaria_' . $mes . '_' . $anio;
            if ($request->tipoexportacion == 'excel') {
                // header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
                // header("content-disposition: attachment;filename=" . $nombrearchivo . ".xls");
                return \Excel::download(new PlanillaVentasPorOrganizacionExport($datos, $mes, $anio),  $nombrearchivo . '.xlsx');
            }
            if ($request->tipoexportacion == 'pdf') {
                $pdf = PDF::loadView('ventas.reportes.produccion_diaria.exportar', [
                    'datos' => $datos,
                    'mes' => $mes,
                    'anio' => $anio,
                    'estilos' => true,
                ]);
                $pdf->setPaper([0, 0, 650, 750], 'landscape');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('ventas.reportes.produccion_diaria.index', [
            'mes' => $mes,
            'anio' => $anio,
            'datos' => $datos
        ]);
    }
    public function produccionOrganizacion(Request $request)
    {
        // return dd($request->all());
        $fecha_ini = \Carbon\Carbon::now();
        $fecha_fin = \Carbon\Carbon::now();
        $datos = [];
        $filtro = 'MES';
        $mes = date('m');
        $anio = date('Y');
        if (isset($request->consulta) && $request->consulta == 'consulta') {
            $filtro = $request->filtro;
            $mes = $request->mes;
            $anio = $request->anio;
            $table = DB::table('view_contrato_credito');
            $fecha_ini = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            $fecha_fin = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
            if ($filtro == 'RANGO') {
                $sql = $table->select('idvendedor')
                    ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->whereIn('tipocontrato', ['DIFERIDO', 'VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                    ->distinct()
                    ->get();
            } elseif ($filtro == 'MES') {
                $sql = $table->select('idvendedor')
                    ->whereMonth('fechacontrato', '=', $mes)
                    ->whereYear('fechacontrato', '=', $anio)
                    ->whereIn('tipocontrato', ['DIFERIDO', 'VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                    ->distinct()
                    ->get();
            }
            if (count($sql) > 0) {
                foreach ($sql as $r) {
                    $vendedor = Vendedor::find($r->idvendedor);
                    if ($filtro == 'RANGO') {
                        $cant_efectivos = DB::table('view_contrato_credito')->selectRaw('COUNT(numcontrato) as cantidad')
                            ->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                            ->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->count('numcontrato');
                        $sum_efectivos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as monto')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                            ->whereBetween('fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->sum('preciototal');
                        $cant_diferidos = DB::table('view_contrato_credito')->where('tipocontrato', 'DIFERIDO')
                            ->whereBetween('fechacontrato', ['2013-01-01', $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->count();
                        $sum_diferidos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as monto')->whereIn('tipocontrato', ['DIFERIDO'])
                            ->whereBetween('fechacontrato', ['2013-01-01', $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->sum('preciototal');
                    } elseif ($filtro == 'MES') {
                        $cant_efectivos = DB::table('view_contrato_credito')->selectRaw('COUNT(numcontrato) as cantidad')
                            ->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                            ->whereMonth('fechadoc', '=', $mes)
                            ->whereYear('fechadoc', '=', $anio)
                            ->where('idvendedor', $r->idvendedor)
                            ->count('numcontrato');
                        $sum_efectivos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as monto')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])
                            ->whereMonth('fechadoc', '=', $mes)
                            ->whereYear('fechadoc', '=', $anio)
                            ->where('idvendedor', $r->idvendedor)
                            ->sum('preciototal');
                        $cant_diferidos = DB::table('view_contrato_credito')
                            ->where('tipocontrato', 'DIFERIDO')
                            ->whereBetween('fechacontrato', ['2013-01-01', $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->count();
                        $sum_diferidos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as monto')->whereIn('tipocontrato', ['DIFERIDO'])
                            ->whereBetween('fechacontrato', ['2013-01-01', $fecha_fin->format('Y-m-d')])
                            ->where('idvendedor', $r->idvendedor)
                            ->sum('preciototal');
                    }
                    $datos[] = [
                        'idvendedor' => $r->idvendedor,
                        'vendedor' => $vendedor->nombre_completo,
                        'cant_efectivo' => $cant_efectivos,
                        'sum_efectivos' => $sum_efectivos,
                        'cant_diferidos' => $cant_diferidos,
                        'sum_diferidos' => $sum_diferidos,
                        'total_contratos' => $cant_diferidos + $cant_efectivos,
                        'total_monto' => $sum_diferidos + $sum_efectivos,
                    ];
                }
                $datos = Collection::make($datos);
            }
        }
        if (isset($request->tipoexportacion)) {
            $nombrearchivo = 'CuadroProduccionVentas' . $fecha_ini->format('d-m-Y') . '_' . $fecha_fin->format('d-m-Y');
            $detalles = [
                'mes' => Helper::mes($mes),
                'anio' => $anio,
                'fecha_ini' => $fecha_ini->format('d-m-Y'),
                'fecha_fin' => $fecha_fin->format('d-m-Y'),
                'filtro' => $filtro
            ];
            if ($request->tipoexportacion == 'excel') {
                // header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
                // header("content-disposition: attachment;filename=" . $nombrearchivo . ".xls");
                return \Excel::download(new CuadroProduccionVentasExport($datos, $detalles), $nombrearchivo . '.xlsx');
            }
            if ($request->tipoexportacion == 'pdf') {
                $pdf = PDF::loadView('ventas.reportes.produccion_organizacion.exportar', [
                    'datos' => $datos,
                    'detalles' => $detalles,
                    'estilos' => true,
                ]);
                $pdf->setPaper('A4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('ventas.reportes.produccion_organizacion.index', [
            'fecha_ini' => $fecha_ini->format('d/m/Y'),
            'fecha_fin' => $fecha_fin->format('d/m/Y'),
            'mes' => $mes,
            'anio' => $anio,
            'datos' => $datos,
            'filtro' => $filtro
        ]);
    }
    public function produccionMensual(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        if (isset($request->consulta)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }
        return view('ventas.reportes.produccion_mensual.index', [
            'mes' => $mes,
            'anio' => $anio,
            'datos' => $datos
        ]);
    }
    public function comportamientoVentas(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        if (isset($request->consulta) && $request->consulta == 'consulta') {
            $mes = $request->mes;
            $anio = $request->anio;
            $contratos_contado = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('tipoventa', 'contado')->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_contado->total)) {
                $total_contado = 0;
            } else
                $total_contado = $contratos_contado->total;
            $cant_contado = $contratos_contado->cuentas;
            $contratos_dos_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('numcuotas', 2)->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_dos_pagos->total)) {
                $total_dos_pagos = 0;
            } else
                $total_dos_pagos = $contratos_dos_pagos->total;
            $cant_dos_pagos = $contratos_dos_pagos->cuentas;
            $contratos_cuatro_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('numcuotas', [3, 4])->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_cuatro_pagos->total)) {
                $total_cuatro_pagos = 0;
            } else
                $total_cuatro_pagos = $contratos_cuatro_pagos->total;
            $cant_cuatro_pagos = $contratos_cuatro_pagos->cuentas;
            $contratos_seis_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('numcuotas', [5, 6])->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_seis_pagos->total)) {
                $total_seis_pagos = 0;
            } else
                $total_seis_pagos = $contratos_seis_pagos->total;
            $cant_seis_pagos = $contratos_seis_pagos->cuentas;
            $contratos_ocho_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('numcuotas', [7, 8])->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_ocho_pagos->total)) {
                $total_ocho_pagos = 0;
            } else
                $total_ocho_pagos = $contratos_ocho_pagos->total;
            $cant_ocho_pagos = $contratos_ocho_pagos->cuentas;
            $contratos_diez_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('numcuotas', [9, 10])->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_diez_pagos->total)) {
                $total_diez_pagos = 0;
            } else
                $total_diez_pagos = $contratos_diez_pagos->total;
            $cant_diez_pagos = $contratos_diez_pagos->cuentas;
            $contratos_doce_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->whereIn('numcuotas', [11, 12])->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_doce_pagos->total)) {
                $total_doce_pagos = 0;
            } else
                $total_doce_pagos = $contratos_doce_pagos->total;
            $cant_doce_pagos = $contratos_doce_pagos->cuentas;
            $contratos_resto_pagos = DB::table('view_contrato_credito')->selectRaw('SUM(preciototal) as total,COUNT(numcuenta) as cuentas')->whereIn('tipocontrato', ['VENTA', 'CUENTA', 'DEVUELTO-COBRANZA'])->where('numcuotas', '>', 12)->whereMonth('fechadoc', '=', $mes)->whereYear('fechadoc', '=', $anio)->first();
            if (is_null($contratos_resto_pagos->total)) {
                $total_resto_pagos = 0;
            } else
                $total_resto_pagos = $contratos_resto_pagos->total;
            $cant_resto_pagos = $contratos_resto_pagos->cuentas;
            $total_monto = $total_contado + $total_dos_pagos + $total_cuatro_pagos + $total_seis_pagos + $total_ocho_pagos + $total_diez_pagos + $total_doce_pagos + $total_resto_pagos;
            $total_cantidad = $cant_contado + $cant_dos_pagos + $cant_cuatro_pagos + $cant_seis_pagos + $cant_ocho_pagos + $cant_diez_pagos + $cant_doce_pagos + $cant_resto_pagos;
            $por_total_contado = ($total_contado > 0) ? round(($total_contado * 100) / $total_monto, 2) : 0;
            $por_cant_contado = ($cant_contado > 0) ? round(($cant_contado * 100) / $total_cantidad, 2) : 0;
            $por_total_dos = ($total_dos_pagos > 0) ? round(($total_dos_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_dos = ($cant_dos_pagos > 0) ? round(($cant_dos_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_cuatro = ($total_cuatro_pagos > 0) ? round(($total_cuatro_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_cuatro = ($cant_cuatro_pagos > 0) ? round(($cant_cuatro_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_seis = ($total_seis_pagos > 0) ? round(($total_seis_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_seis = ($cant_seis_pagos > 0) ? round(($cant_seis_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_ocho = ($total_ocho_pagos > 0) ? round(($total_ocho_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_ocho = ($cant_ocho_pagos > 0) ? round(($cant_ocho_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_diez = ($total_diez_pagos > 0) ? round(($total_diez_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_diez = ($cant_diez_pagos > 0) ? round(($cant_diez_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_doce = ($total_doce_pagos > 0) ? round(($total_doce_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_doce = ($cant_doce_pagos > 0) ? round(($cant_doce_pagos * 100) / $total_cantidad, 2) : 0;
            $por_total_resto = ($total_resto_pagos > 0) ? round(($total_resto_pagos * 100) / $total_monto, 2) : 0;
            $por_cant_resto = ($cant_resto_pagos > 0) ? round(($cant_resto_pagos * 100) / $total_cantidad, 2) : 0;
            $datos = Collection::make([
                'monto_contado' => $total_contado,
                'cuotas_contado' => $cant_contado,
                'por_total_contado' => $por_total_contado,
                'por_cant_contado' => $por_cant_contado,
                'total_dos_pagos' => $total_dos_pagos,
                'cant_dos_pagos' => $cant_dos_pagos,
                'por_total_dos' => $por_total_dos,
                'por_cant_dos' => $por_cant_dos,
                'total_cuatro_pagos' => $total_cuatro_pagos,
                'cant_cuatro_pagos' => $cant_cuatro_pagos,
                'por_total_cuatro' => $por_total_cuatro,
                'por_cant_cuatro' => $por_cant_cuatro,
                'total_seis_pagos' => $total_seis_pagos,
                'cant_seis_pagos' => $cant_seis_pagos,
                'por_total_seis' => $por_total_seis,
                'por_cant_seis' => $por_cant_seis,
                'total_ocho_pagos' => $total_ocho_pagos,
                'cant_ocho_pagos' => $cant_ocho_pagos,
                'por_total_ocho' => $por_total_ocho,
                'por_cant_ocho' => $por_cant_ocho,
                'total_diez_pagos' => $total_diez_pagos,
                'cant_diez_pagos' => $cant_diez_pagos,
                'por_total_diez' => $por_total_diez,
                'por_cant_diez' => $por_cant_diez,
                'total_doce_pagos' => $total_doce_pagos,
                'cant_doce_pagos' => $cant_doce_pagos,
                'por_total_doce' => $por_total_doce,
                'por_cant_doce' => $por_cant_doce,
                'total_resto_pagos' => $total_resto_pagos,
                'cant_resto_pagos' => $cant_resto_pagos,
                'por_total_resto' => $por_total_resto,
                'por_cant_resto' => $por_cant_resto,
                'total_monto' => $total_monto,
                'total_cantidad' => $total_cantidad
            ]);
        }
        if (isset($request->tipoexportacion)) {
            $nombrearchivo = 'Comportamiento_ventas_' . Helper::mes($mes) . '_' . $anio;
            $periodo = Helper::mes($mes) . '/' . $anio;
            if ($request->tipoexportacion == 'excel') {
                return \Excel::download(new ComportamientoVentasExport($datos, $periodo), $nombrearchivo . '.xlsx');
            }
            if ($request->tipoexportacion == 'pdf') {
                $pdf = PDF::loadView('ventas.reportes.comportamiento_ventas.exportar', [
                    'datos' => $datos,
                    'periodo' => $periodo,
                    'estilos' => true,
                ]);
                $pdf->setPaper('A4', 'landscape');
                return $pdf->download($nombrearchivo);
            }
        }
        return view('ventas.reportes.comportamiento_ventas.index', [
            'mes' => $mes,
            'anio' => $anio,
            'datos' => $datos
        ]);
    }
    public function relacionVendidas(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        if (isset($request->consulta) && $request->consulta == 'consulta') {
            $mes = $request->mes;
            $anio = $request->anio;
            $datos = Contrato::join('credito as c', 'c.contrato_id', '=', 'contratos.id')
                ->join('detalle_contrato as dc', 'dc.contrato_id', '=', 'contratos.id')
                ->join('libros as l', 'l.codigo', '=', 'dc.codigo')
                ->whereIn('contratos.tipocontrato', ['CUENTA', 'VENTA', 'DEVUELTO-COBRANZA'])
                ->whereMonth('c.fechadoc', '=', $mes)
                ->whereYear('c.fechadoc', '=', $anio)
                ->selectRaw('SUM(dc.cantidad) as cantidad, dc.codigo as codigo  , l.precio_base as precio_base ,l.titulo as titulo')
                ->groupBy('codigo', 'precio_base', 'titulo')
                ->orderBy('codigo', 'ASC')
                ->get();
        }
        if (isset($request->tipoexportacion)) {
            $nombrearchivo = 'Relacion_obras_vendidas_' . Helper::mes($mes) . '_' . $anio;
            $periodo = Helper::mes($mes) . '/' . $anio;
            if ($request->tipoexportacion == 'excel') {
                return \Excel::download(new RelacionObrasVendidasExport($datos, $periodo),  $nombrearchivo . '.xlsx');
            }
            if ($request->tipoexportacion == 'pdf') {
                $pdf = PDF::loadView('ventas.reportes.relacion_vendidas.exportar', [
                    'datos' => $datos,
                    'periodo' => $periodo,
                    'estilos' => true,
                ]);
                $pdf->setPaper('A4', 'portrait');
                return $pdf->download($nombrearchivo);
            }
        }
        return view('ventas.reportes.relacion_vendidas.index', [
            'mes' => $mes,
            'anio' => $anio,
            'datos' => $datos
        ]);
    }
}
