<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class RefinanciamientoController extends Controller
{
    //

    public function guardarRefinanciamiento(Request $request){

        // return dd($request->all());

          try{
              $credito=\App\Credito::findOrFail($request->idcuenta);

              $credito->numcuotas=$request->numpagos;
              $credito->montocuotas=round($request->saldo/$request->numpagos,2);
              $credito->fechacuotas=$request->fechainicio;
              $credito->dias=$request->diaspago;
              $credito->save();

              session()->flash('success','El refinanciamiento se proceso correctamente');
          }
            catch(\Exception $e){
           session()->flash('error','Ocurrio un error');

               return dd($e); 

            }
            return back();

    }

    public function cambiarDiaCobro(Request $request){

        // return dd($request->all());

          try{
              $credito=\App\Credito::findOrFail($request->credito_id);

              $credito->diacobrar=$request->diaspago;
            
              $credito->save();

              session()->flash('success','El dia de cobro se cambio  correctamente');
          }
            catch(\Exception $e){
           session()->flash('error','Ocurrio un error');

               return dd($e); 

            }
            return back();

    }

public function index(Request $request){
   if(isset($request->buscar)){

    $credito=\App\Credito::where('id',$request->credito_id)->first();
    
        $cuotas = \App\Helper\Helper::planPagos($credito->fechacuotas, 0, $credito->numcuotas * $credito->dias, $credito->numcuotas, $credito->saldo);
         $cobradores=\App\cobrador::orderBy('nombres','ASC')->get();
           $pagos=\App\Pago::where('model_type','pago-cobranza')
          ->where('model_id',$request->credito_id)
            ->orderBy('fecha','ASC')
            ->get();

         $descuentos=\App\Descuento::where('credito_id',$credito->id)->orderBy('fecha','ASC')->get();
         $devoluciones=\App\DevolucionObras::where('procedencia','COBRANZA')->where('num_cuenta',$credito->numcuenta)->orderBy('fecha','ASC')->get();

        return view('cobranza.refinanciamiento.index',[
            'credito'=>$credito,
            'pagos'=>$pagos,
            'cuotas'=>$cuotas,
            'cobradores'=>$cobradores,
            'criterio'=>$request->numcuenta,
            'tipo'=>$request->tipo,
            'descuentos'=>$descuentos,
            'devoluciones'=>$devoluciones

        ]);

            }

            return view('cobranza.refinanciamiento.index');
        }
                
    
}
