<?php

namespace App\Http\Controllers;

use App\CambioObra;
use App\cobrador;
use App\Contrato;
use App\Credito;
use App\Descuento;
use App\Helper\Helper;
use App\Pago;
use App\Recibo;
use Carbon\Carbon;
use App\CierreApertura;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class PagoCobranzaController extends Controller
{
    public function registrar(Request $request)
    {


        if (isset($request->buscar)) {

            $credito = Credito::where('id', $request->credito_id)->first();
            // if($credito->contrato_id=='' ){
            //     Session::flash('info','Este contrato no esta facturado');
            //     return redirect()->back();
            // }
            $pagos = Pago::where('model_type', 'pago-cobranza')
                ->where('model_id', $request->credito_id)
                ->orderBy('fecha', 'ASC')
                ->get();
            $cuotas = Helper::planPagos($credito->fechacuotas, 0, $credito->numcuotas * $credito->dias, $credito->numcuotas, $credito->saldo_inicial);
            $cobradores = cobrador::orderBy('nombres', 'ASC')->get();

            $descuentos = Descuento::where('credito_id', $credito->id)->orderBy('fecha', 'ASC')->get();
            $devoluciones = \App\DevolucionObras::where('procedencia', 'COBRANZA')->where('num_cuenta', $credito->numcuenta)->orderBy('fecha', 'ASC')->get();
            $cambios_obras = CambioObra::where('credito_id', $credito->id)->where('estado', 'PROCESADO')->orderBy('fecha', 'desc')->get();

            return view('cobranza.pagos.registrar', [
                'credito' => $credito,
                'pagos' => $pagos,
                'cuotas' => $cuotas,
                'cobradores' => $cobradores,
                'criterio' => $request->numcuenta,
                'tipo' => $request->tipo,
                'descuentos' => $descuentos,
                'devoluciones' => $devoluciones,
                'cambio_obras' => $cambios_obras

            ]);
        }

        return view('cobranza.pagos.registrar');
    }
    public function registrarPost(Request $request)
    {

        $credito = Credito::where('id', $request->credito_id)->first();

        $pagos = Pago::where('model_type', 'pago-cobranza')
            ->where('model_id', $request->credito_id)
            ->orderBy('fecha', 'ASC')
            ->get();
        $cuotas = Helper::planPagos($credito->fechacuotas, 0, $credito->numcuotas * $credito->dias, $credito->numcuotas, $credito->saldo);
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();

        $descuentos = Descuento::where('credito_id', $credito->id)->orderBy('fecha', 'ASC')->get();
        $devoluciones = \App\DevolucionObras::where('procedencia', 'COBRANZA')->where('num_cuenta', $credito->numcuenta)->orderBy('fecha', 'DESC')->get();
        $cambios_obras = CambioObra::where('credito_id', $credito->id)->where('estado', 'PROCESADO')->orderBy('fecha', 'desc')->get();
        return view('cobranza.pagos.registrar', [
            'credito' => $credito,
            'pagos' => $pagos,
            'cuotas' => $cuotas,
            'cobradores' => $cobradores,
            'criterio' => $request->numcuenta,
            'tipo' => $request->tipo,
            'descuentos' => $descuentos,
            'devoluciones' => $devoluciones,
            'cambio_obras' => $cambios_obras

        ]);
    }
    public function index(Request $request)
    {
        $tipo = 'mes';
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $numcuenta = '';
        $datos = [];

        if ($request->buscar == 'buscar') {

            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {

                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Pago::where('model_type', 'pago-cobranza')
                    ->whereMonth('fecha', '=', $request->mes)
                    ->whereYear('fecha', '=', $request->anio)
                    ->orderBy('created_at', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Pago::where('model_type', 'pago-cobranza')
                    ->whereBetween('fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('created_at', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Pago::where('model_type', 'pago-cobranza')
                    ->whereBetween('fecha', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('created_at', 'DESC')->get();
            }
            if ($request->tipo == 'buscar') {

                $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                    ->where('c.numcuenta', $request->numcuenta)->get();
            }
        } else {



            $datos = Pago::where('model_type', 'pago-cobranza')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->orderBy('created_at', 'DESC')->get();
        }
        return view('cobranza.pagos.index', [
            'datos' => $datos,
            'tipo' => $tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
            'numcuenta' => $numcuenta
        ]);
    }
    public function store(Request $request)
    {

        // return dd($request->all());
        try {
            $sql = Pago::where('model_type', 'pago-cobranza')
                ->where('model_id', $request->credito_id)
                ->where('numrecibo', $request->numrecibo)
                ->get();

            if (!is_null($sql) && count($sql) > 0) {
                Session::flash('warning', 'El recibo ' . $request->numrecibo . ' ya  se encuentra registrado');

                return back();
            }

            DB::beginTransaction();
            $p = new Pago();
            $p->fecha = $request->fecha;
            $p->num_reporte = $request->reporte;
            $p->estado = 'T';
            $p->numrecibo = $request->numrecibo;
            $p->terminado = 1;
            $p->obs = $request->obs;
            $p->model_type = 'pago-cobranza';
            $p->model_id = $request->credito_id;
            $p->tipo_documento = 'RECIBO';
            $p->cobrador_id = $request->cobrador;
            $p->monto = $request->monto;
            $p->save();

            $recibo = new Recibo();
            $recibo->monto = $request->monto;
            $recibo->fecha = $request->fecha;
            $recibo->descripcion = 'PAGO CUOTA DE CREDITO';
            $recibo->nombres = $request->nombres;
            $recibo->numero = $request->numrecibo;
            $recibo->model_id = $p->id;
            $recibo->model_type = 'pagos';
            $recibo->save();
            $monto_descuento = 0;

            if ($request->monto_descuento != '') {
                $descuento = new Descuento();
                $descuento->monto = $request->monto_descuento;
                $descuento->fecha = $p->fecha;
                $descuento->credito_id = $request->credito_id;
                $descuento->tipo = $request->tipo_descuento;
                $descuento->pago_id = $p->id;
                $descuento->save();
                $monto_descuento = $descuento->monto;
            }


            $credito = Credito::find($request->credito_id);

            $credito->saldo = $credito->saldo - $p->monto - $monto_descuento;

            if ($credito->saldo <= 0) {

                $ultimo_pago = Pago::where('model_id', $credito->id)
                    ->where('model_type', 'pago-cobranza')
                    ->orderBy('fecha', 'DESC')->first();

                $credito->fecha_terminado = $ultimo_pago->fecha;
                $credito->save();


                if (isset($descuento) && $descuento->monto > 0) {

                    $credito->tipo_terminado = 'pronto-pago';
                    $credito->id_terminado = $descuento->id;
                } else {
                    $credito->tipo_terminado = 'pago';
                    $credito->id_terminado = $ultimo_pago->id;
                }


                $credito->estado = 'T';
                $credito->fecha_terminado = $ultimo_pago->fecha;
                $credito->save();
            }
            $credito->save();


            DB::commit();
            Session::flash('success', 'El pago se registro exitosamente');
        } catch (\Exception $e) {

            return dd($e);
            DB::rollBack();
            Session::flash('error', 'ocurrio un error al registrar el pago. Intente nuevamente porfavor ');
        }
        // return redirect('pagos-cobranza/registrar/'.$credito->numcuenta);
        // return redirect('pagos-cobranza?mes='.$p->fecha->month.'&anio='.$p->fecha->year.'&tipo=mes');
        return back();
    }

    public function destroy(Pago $pago)
    {


        $fecha = $pago->fecha;
        $sql = CierreApertura::where('modulo', 'COBRANZA')
            ->where('mes', $fecha->month)
            ->where('anio', $fecha->year)
            ->first();
        // return dd($sql);



        if (!is_null($sql) && $sql->estado == 'CERRADO') {
            Session::flash('warning', 'EL mes esta cerrado , no se puede eliminar');
            return back();
        }





        try {
            DB::beginTransaction();
            if (isset($pago->recibo)) {
                $pago->recibo()->delete();
            }

            $descuento = Descuento::where('pago_id', $pago->id)->get();
            $monto_desc = 0;

            if (count($descuento) > 0) {
                $descuento->delete();
                $monto_desc = $descuento->sum('monto');
            }

            $credito = Credito::find($pago->model_id);
            $credito->saldo = $credito->saldo + ($pago->monto + $monto_desc);

            if ($credito->saldo > 0) {
                $credito->estado = 'C';
                $credito->fecha_terminado = null;
            }

            $credito->save();
            $pago->delete();
            DB::commit();
            Session::flash('success', 'El pago se elimino correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error.Intentelo nuevmanete por favor');
        }
        return back();
    }

    public function editar(Request $request)
    {
        // return dd($request->all());
        $pago = Pago::find($request->id);


        $fecha = $pago->fecha;
        $monto = 0;
        if ($request->monto != '') {
            $monto = $request->monto;
        }
        $recibo = null;
        $sql = CierreApertura::where('modulo', 'COBRANZA')
            ->where('mes', $fecha->month)
            ->where('anio', $fecha->year)
            ->first();


        if (!is_null($sql) && $sql->estado == 'CERRADO') {
            Session::flash('warning', 'EL mes esta cerrado , no se puede editar');
            return back();
        }

        try {
            DB::beginTransaction();
            if (!is_null($pago->recibo)) {
                $recibo = $pago->recibo;
            } else {
                $recibo = new Recibo();
                $recibo->model_id = $pago->id;
                $recibo->model_type = 'pagos';
            }
            $recibo->fecha = $request->fecha;
            $recibo->monto = $request->monto;
            $recibo->nombres = $request->nombres;
            $recibo->numero = $request->numrecibo;
            $recibo->save();



            $credito = Credito::find($pago->model_id);
            $credito->saldo = ($credito->saldo + $pago->monto) - $monto;

            $pago->monto = $monto;
            $pago->fecha = $request->fecha;
            $pago->obs = $request->obs;
            $pago->cobrador_id = $request->cobrador;
            $pago->num_reporte = $request->reporte;
            $pago->save();


            // $credito->saldo=$credito->saldo-$monto;

            if ($credito->saldo > 0) {
                $credito->estado = 'C';
                $credito->fecha_terminado = null;
            }

            $credito->save();

            DB::commit();
            Session::flash('success', 'El pago se elimino correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            return dd($e);
            Session::flash('error', 'Ocurrio un error.Intentelo nuevamente por favor');
        }
        return back();
    }
}