<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;

class MantenimientoCuentasController extends Controller
{


    public function procesar(Request $request)
    {
    // return dd($request->all());

        $credito = \App\Credito::find($request->credito);
        if ($request->tipo == 'devolucion') {

            $sql = \App\DevolucionObras::find($request->numerodevolucion);

            if (!is_null($sql)) {

                session()->flash('error', 'El numero de Devolucion ya se encuentra registrado');
                return back();
            } else {
                try {
                    \DB::beginTransaction();

                    $dev = new \App\DevolucionObras();
                    // $dev->id = $request->numerodevolucion;
                    $dev->fecha = $request->fechadevolucion;
                    $dev->num_cuenta = $credito->numcuenta;
                    $dev->estado = 'PROCESADO';
                    $dev->tipo_devolucion = $request->tipodevolucion;
                    $dev->user_id = auth()->user()->id;
                    $dev->ingreso_id = $request->ingresodevolucion;
                    $dev->procedencia = 'COBRANZA';
                    $dev->monto_devolucion = $request->montodevolucion;
                    $dev->cuenta_antigua = 1;
                    $dev->save();
                    $credito->saldo = $credito->saldo - $request->montodevolucion;

                    if ($credito->saldo <= 0) {
                        $credito->estado = 'T';
                        $credito->fecha_terminado = $dev->fecha;
                        $credito->tipo_terminado = 'devolucion';
                        $credito->id_terminado = $dev->id;
                    }
                    $credito->save();

                    \DB::commit();
                    session()->flash('success', 'La devolucion se proceso correctamente ');
                    return redirect()->back();


                } catch (\Exception $e) {
                    \DB::rollBack();
                    return dd($e);
                    session()->flash('danger', ' Ocurrio un error en el servidor ');
                }
            }

        } elseif ($request->tipo == 'cambio') {

            $sql = \App\CambioObra::find($request->numerocambio);

            if (!is_null($sql)) {

                session()->flash('error', 'El numero de Cambio de Obra ya se encuentra registrado');
                return back();
            } else {
                try {
                    \DB::beginTransaction();

                    $cambio = new \App\CambioObra();
                    // $cambio->id = $request->numerocambio;
                    $cambio->fecha = $request->fechacambio;
                    $cambio->estado = 'PROCESADO';
                    $cambio->numingreso = $request->ingresocambio;
                    $cambio->numegreso = $request->egresocambio;
                    $cambio->terminado = 1;
                    $cambio->credito_id = $credito->id;
                    $cambio->monto = $request->montocambio;
                    $cambio->cuentaantigua = 1;
                    $cambio->user_id = auth()->user()->id;

                                   $cambio->save();

                

                    if ($request->afectacambio == 'disminuye') {

                        $credito->saldo = $credito->saldo - $request->montocambio;
                        $cambio->tipo_saldo = 'DISMINUYE';
                        $cambio->monto_tipo_saldo = $credito->saldo - $cambio->saldo;
                    }
                     else if ($request->afectacambio == 'aumenta') {

                        $credito->saldo = $credito->saldo + $request->montocambio;
                        $cambio->tipo_saldo = 'AUMENTA';
                        $cambio->monto_tipo_saldo = $cambio->saldo - $credito->saldo;

                      
                    }
                    $cambio->save();

                    if ($credito->saldo <= 0) {
                        // return dd($request->fechacambio);
                        $credito->estado = 'T';
                        $credito->fecha_terminado = Carbon::createFromFormat('d/m/Y',$request->fechacambio)->format('Y-m-d');
                        $credito->tipo_terminado = 'cambioObra';
                        $credito->id_terminado = $cambio->id;
                    }
                    $credito->save();

                    \DB::commit();
                    session()->flash('success', 'El cambio de Obra se proceso correctamente ');
                    return redirect()->back();

                } catch (\Exception $e) {
                    \DB::rollBack();
                    return dd($e);
                    session()->flash('danger', ' Ocurrio un error en el servidor ');
                }
            }
        } elseif ($request->tipo == 'riesgo') {
            try {
                \DB::beginTransaction();

                $d = new \App\Deudor();

                if (isset($credito->contrato)) {
                    $d->nombres = $credito->contrato->nombres;
                    $d->apellidos = $credito->contrato->apellidopaterno . ' ' . $credito->contrato->apellidomaterno;

                    $d->num_documento = $credito->contrato->ci;
                    $d->num_doc_deuda = $credito->contrato->numcontrato;
                } else {

                    $d->nombres = $credito->nombre_cliente;
                }
                $d->tipo_documento = 'CI';


                $d->tipo_operacion = 'VENTA';

                $d->monto_original_deuda = $credito->saldo_inicial;
                $d->concepto = $request->conceptoriesgo;
                $d->tipo_doc_deuda = $request->documentoriesgo;
                $d->estado = 'A';

                $d->saldo_deuda_vencida = $credito->saldo;
                $d->saldo_deuda_vigente = $credito->saldo;
                $d->cobrador = $credito->cobrador_id;
                $fecha = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fechariesgo)->format('Y-m-d');

                $d->fecha_ingreso_vencida = $fecha;
                $d->credito_id = $credito->id;
                $d->save();

                $credito->saldo = 0;
                $credito->estado = 'I';
                $credito->fecha_terminado = $fecha;
                $credito->tipo_terminado = 'riesgo';
                $credito->id_terminado = $d->id;
                $credito->save();


                \DB::commit();
                session()->flash('success', 'El cliente se ha registrado en la central de riesgo');
                return redirect()->back();


            } catch (\Exception $e) {
                \DB::rollBack();
                return dd($e);
                session()->flash('danger', 'Ocurrio un error en el servidor');

            }

        }
    }

    public function index(Request $request)
    {

        // return dd($request->all());

        if (isset($request->buscar)) {

            $credito = \App\Credito::where('id', $request->credito_id)->first();

            $pagos = \App\Pago::where('model_type', 'pago-cobranza')
                ->where('model_id', $request->credito_id)
                ->orderBy('fecha', 'ASC')
                ->get();
            $cuotas = \App\Helper\Helper::planPagos($credito->fechacuotas, 0, $credito->numcuotas * $credito->dias, $credito->numcuotas, $credito->saldo);
            $cobradores = \App\cobrador::orderBy('nombres', 'ASC')->get();

            $descuentos = \App\Descuento::where('credito_id', $credito->id)->orderBy('fecha', 'ASC')->get();
            $devoluciones = \App\DevolucionObras::where('procedencia', 'COBRANZA')
            ->where('num_cuenta', $credito->numcuenta)->orderBy('fecha', 'ASC')->get();

            return view('cobranza.mantenimiento.index', [
                'credito' => $credito,
                'pagos' => $pagos,
                'cuotas' => $cuotas,
                'cobradores' => $cobradores,
                'criterio' => $request->numcuenta,
                'tipo' => $request->tipo,
                'descuentos' => $descuentos,
                'devoluciones' => $devoluciones

            ]);

        }

        return view('cobranza.mantenimiento.index');

    }

}
