<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use App\Kardex;
use App\Libro;
use App\Vendedor;
use Illuminate\Contracts\Session\Session;
use Illuminate\Http\Request;
use  Excel;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Support\Collection;

class KardexController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     * 
     * 
     * 
     * 
     */


    public function cargosVendedores(Request $request)
    {

        $fecha = \Carbon\Carbon::now();
        $anio = date('Y');
        $mes = date('m');
        // return dd($request->all());
        if (isset($request->consulta) && $request->consulta == 'consulta') {
            $mes = $request->mes;
            $anio = $request->anio;
            // return dd('ad');
        }


        $vendedores = Kardex::SelectRaw('Count(id) as suma,vendedor_id, estado')
            ->whereMonth('fechakardex', '=', $mes)
            ->whereYear('fechakardex', '=', $anio)
            ->whereIn('cargo', ['0', '1'])
            ->whereIn('estado', ['Remitido', 'Diferido'])

            ->groupBy('vendedor_id', 'estado')
            ->get();
        // 
        //    return dd($vendedores->groupBy('vendedor_id')->toArray());


        //    return dd($mes,$anio);
        return view('almacen.kardex.cargosvendedores', [
            'vendedores' => $vendedores->groupBy('vendedor_id'),
            'anio' => $anio,
            'mes' => $mes
        ]);
    }
    public function resumenCargos(Request $request)
    {
 
        $query2 = Kardex::select('estado', 'vendedor_id', 'cod_libro', 'titulo_libro')
            ->where('estado', 'Remitido')
            ->where('vendedor_id', $request->id)
            ->where('cargo', '!=', 2)
            ->get();
        $datos = [];
        foreach ($query2->sortBy('cod_libro')->groupBy('cod_libro')->toArray() as $l => $k) {

            $libro = Libro::where('codigo', $l)->first();
            $datos[] = [
                'codigo' => $l,
                'titulo' => $libro->titulo,
                'volumen' => $libro->tomo,
                'cantidad' => count($k)
            ];
        }
        return view('almacen.kardex.resumen_cargos', [
            'datos' => Collection::make($datos),
            'vendedor' => Vendedor::find($request->id)
        ]);
    }
    public function index(Request $request)
    {

        //    return dd($request->all());
        $mes = date('m');
        $anio = date('Y');

        $vendedor = 0;
        $nombre_vendedor = '';
        $datos = [];
        $periodo = Helper::mes($mes) . '-' . $anio;
        //dd($periodo);
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        $pasar_cargos = true;
        if (isset($request->vendedor)) {
            $mes = $request->mes;
            $anio = $request->anio;
            $vendedor = $request->vendedor;
            $nombre_vendedor = Vendedor::find($vendedor)->nombre_completo;
            $kardex = Kardex::kardexVendedor($vendedor, $mes, $anio);
            $pasar_cargos = Vendedor::permitirPasarCargos($mes, $anio, $vendedor);

            if ($mes == 12) {
                $mes = 1;
            }
            //    else{
            // 	   $mes++;
            //    }

            return  view('almacen.kardex.index', [
                'datos' => $kardex['datos'],
                'vendedores' => $vendedores,
                'anio' => $anio,
                'mes' => $mes,
                'vendedor' => $vendedor,
                'totales' => $kardex['totales'],
                'nombre_vendedor' => $nombre_vendedor,
                'periodo' => $periodo,
                'sw' => true,
                'pasarcargos' => $pasar_cargos

            ]);
        }

        return  view('almacen.kardex.index', [

            'vendedores' => $vendedores,
            'anio' => $anio,
            'mes' => $mes,
            'vendedor' => $vendedor,
            'datos' => $datos,
            'pasarcargos' => $pasar_cargos,
            'nombre_vendedor' => $nombre_vendedor




        ]);
    }
    public function pasarCargos($mes, $anio, $vendedor_id)
    {
        $query = Kardex::pasarCargos($vendedor_id, $mes, $anio);

        if ($query) {
            \Illuminate\Support\Facades\Session::flash('success', 'El proceso se completo correctamente');
        } else {
            \Illuminate\Support\Facades\Session::flash('error', 'Ocurrio un error en el servidor');
        }

        //   return redirect('kardex?mes='.$mes.'&anio='.$anio.'&vendedor='.$vendedor_id);
        return redirect()->back();
    }
    public function exportar($tipo, $mes, $anio, $vendedor_id)
    {
        $vendedor = Vendedor::find($vendedor_id);
        $nombre_vendedor = $vendedor->nombre_completo;


        $nombrearchivo = 'kardex-' . $vendedor->nombre_completo . '-' . $mes . $anio;
        $periodo = Helper::mes($mes) . '-' . $anio;
        $kardex = Kardex::kardexVendedor($vendedor_id, $mes, $anio);
        if ($tipo == 'excel') {

            \Excel::create($nombrearchivo, function ($excel) use ($kardex, $nombre_vendedor, $periodo) {
                $excel->setTitle('Data Export');
                $excel->setCreator('OCIS')->setCompany('HGF Limited');
                $excel->setDescription('Data export from OCIS');

                $excel->sheet('kardex', function ($sheet) use ($kardex, $nombre_vendedor, $periodo) {




                    $sheet->setWidth('A', 80);
                    $sheet->setWidth('B', 10);
                    $sheet->setWidth('C', 10);
                    $sheet->setWidth('D', 10);
                    $sheet->setWidth('E', 70);
                    $sheet->setWidth('F', 7);
                    $sheet->setWidth('G', 7);
                    $sheet->setWidth('H', 35);
                    $sheet->setWidth('I', 5);
                    $sheet->setWidth('J', 10);
                    $sheet->setWidth('K', 10);
                    $sheet->setWidth('L', 10);
                    $sheet->setWidth('M', 16);

                    $sheet->loadView(
                        'almacen.kardex.reportekardex',
                        [
                            'datos' => $kardex['datos'],
                            'totales' => $kardex['totales'],
                            'estilos' => false,
                            'nombre_vendedor' => $nombre_vendedor,
                            'periodo' => $periodo
                        ]
                    );
                });
            })->download('xlsx');
        } elseif ($tipo == 'pdf') {

            $pdf = PDF::loadView('almacen.kardex.reportekardex', [
                'datos' => $kardex['datos'],
                'totales' => $kardex['totales'],
                'estilos' => true,
                'nombre_vendedor' => $nombre_vendedor,
                'periodo' => $periodo
            ]);
            $pdf->setPaper('a4', 'landscape');
            // $pdf->setPaper([0, 0,650, 750], 'landscape');
            //            $pdf->output();
            //            $dom_pdf = $pdf->getDomPDF();
            //            $pdf->set_paper(array(0,0,1000,3000));

            //            return $pdf->download('saldos_socios.pdf');

            return $pdf->stream($nombrearchivo);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
}
