<?php

namespace App\Http\Controllers;

use App\Contrato;
use App\DetalleDevolucion;
use App\DetalleRemision;
use App\DevolucionObras;
use App\Kardex;
use App\Libro;
use App\NotasDevolucion;
use App\NotasRemision;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class DevolucionObrasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DevolucionObras  $devolucionObras
     * @return \Illuminate\Http\Response
     */
    public function show(DevolucionObras $devolucionObras)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DevolucionObras  $devolucionObras
     * @return \Illuminate\Http\Response
     */
    public function edit(DevolucionObras $devolucionObras)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DevolucionObras  $devolucionObras
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DevolucionObras $devolucionObras)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DevolucionObras  $devolucionObras
     * @return \Illuminate\Http\Response
     */
    public function destroy(DevolucionObras $devolucionObras)
    {
        //
    }

      public function devolucionVentasAlmacen(){


        $devoluciones=DevolucionObras::where('estado','almacen')
                                      ->where('procedencia','VENTAS')
                                     ->orderBy('fecha','DESC')->get();
        return view('almacen.devolucionobras.devolucionventas',[
            'devoluciones'=>$devoluciones
        ]);

      }


      public function devolucionVentasVer(DevolucionObras $devolucion){

        return view('ventas.includes.nota_devolucionventa',[
            'dev'=>$devolucion
        ]);

      }

       public function devolucionVentasVerNotas(DevolucionObras $devolucion)
       {
           # code...

           

           return view('ventas.devolucion_diferidos.ver_notas2',[
                'devolucion'=>$devolucion,
            'contrato'=>$devolucion->contrato,
            'vendedor'=>$devolucion->contrato->vendedor
           ]);
       }

      public function devolucionVentas(Request $request){

          $mes = date('m');
          $anio = date('Y');
          $datos = [];
          if (isset($request->mes)) {
              $mes = $request->mes;
              $anio = $request->anio;

          }
          $datos = DevolucionObras::whereMonth('fecha', '=', $mes)
              ->whereYear('fecha', '=', $anio)
              ->where('procedencia', 'VENTAS')
              ->orderBy('fecha', 'ASC')
              ->get();


          return view('ventas.devolucion_diferidos.index',[
              'devoluciones'=>$datos,
              'mes'=>$mes,
              'anio'=>$anio,

          ]);



      }

      public function devolucionStore(Request $request){

        // return dd($request->all());

      
          try{
              DB::beginTransaction();

                  $dev=new NotasDevolucion();


              $dev->fecha=$request->fecha;
              $dev->cant_total=$request->cant_total;
              $dev->estado='T';
              $dev->vendedor_id=$request->vendedor_id;
              $dev->almacen_id=0;
              $dev->user_id=Auth::user()->id;
              $dev->obs=$request->obs;
              $dev->terminado=1;
              $dev->numcontrato=$request->numcontrato;
              $dev->tipo='DEVOLUCION VENTA';
              $dev->save();




              $contrato=Contrato::find($request->contrato_id);
              $contrato->tipocontrato='DEVUELTO';
              $contrato->estado='DEVUELTO';
              $contrato->save();
              $devolucionObras=DevolucionObras::find($request->devolucion_id);
              $devolucionObras->ingreso_id=$dev->id;
              $devolucionObras->estado='PROCESADO';
              $devolucionObras->num_contrato=$contrato->numcontrato;
              $devolucionObras->save();

              Kardex::where('contrato_id',$contrato->id)
                      ->where('vendedor_id',$contrato->idvendedor)
                  ->update([
                      'estado'=>'DevueltoObras',
                      'fecha_devolucion'=>$dev->fecha->format('Y-m-d'),
                      'devolucion_id'=>$dev->id,
                  ]);


//                 return dd($request->libro_id);
              foreach($request->libro_id as $k=>$v){

                  $detalle=new DetalleDevolucion();
                  $libro=Libro::find($v);
            if (!is_null($libro)) {
                  $detalle->cantidad=$request->cant[$k];
                  $detalle->codigo=$libro->codigo;
                  $detalle->titulo=$libro->titulo;
                  $detalle->volumen=$libro->tomo;
                  $detalle->obs=$request->observacion[$k];
                  $detalle->libro_id=$v;
                  $detalle->devolucion_id=$dev->id;
                  $detalle->save();
                  $libro->stock=$libro->stock+$detalle->cantidad;
                  $libro->save();
                }

              }

              if( $devolucionObras->tipo_devolucion=='PARCIAL'){
                  $datos_kardex=[];
                  $remision=new NotasRemision();
                   $remision->fecha=$devolucionObras->fecha_remision->format('d/m/Y');
                   $remision->vendedor_id=$devolucionObras->contrato->idvendedor;
                   $remision->estado='T';
                   $remision->cant_total=$request->remision_cant_total;
                   $remision->user_id=Auth::user()->id;
                   $remision->obs=$request->remision_obs;
                   $remision->save();

             

                   foreach ($request->remision_detalle_codigo as $k=>$v){

                           $d= new DetalleRemision();
                          $d->obs=$request->remision_obs_detalle[$k];
                           $d->cantidad=$request->remision_detalle_cantidad[$k];
                           $d->remision_id=$remision->id;
                           $d->libro_id=$request->remision_detalle_libro_id[$k];
                           $d->codigo=$v;
                           $d->titulo=$request->remision_detalle_titulo[$k];
                           $d->volumen=$request->remision_detalle_volumen[$k];
                           $d->save();

                            $libro=Libro::find($d->libro_id);


                                if(!is_null($libro)){
                                        // DB::rollBack();
                                        $new_stock=$libro->stock-$d->cantidad;
                                        
                                        $libro->stock=$new_stock;
                                        // return dd('aca estoy',  $libro,$d->cantidad, $libro->stock, $new_stock);
                                    $libro->save();
                                }

                             


                       for($i=0; $i<$d->cantidad; $i++){
                           $datos_kardex[]=[

                               'fecha_remision'=>$remision->fecha->format('Y-m-d'),
                               'remision_id'=> $remision->id,
                               'cod_libro'=>$d->codigo,
                               'titulo_libro'=>$d->titulo,
                               'estado'=>'Remitido',
                               'vendedor_id'=>$remision->vendedor_id,
                               'tomo_libro'=>$d->volumen,
                               'libro_id'=>$d->libro_id,
                               'cargo'=>0,
                               'traspaso'=>0,
                               'fechakardex'=>$remision->fecha->format('Y-m-d')
                           ];
                       }

                   }
                  Kardex::insert($datos_kardex);
              }

              DB::commit();
              Session::flash('success','La nota de devolucion de registro correctamente.');


          }
          catch (\Exception $e){
              return dd($e);

              DB::rollBack();
              Session::flash('error','Ocurrio un error inesperado.');

          }

//          return redirect('notas-devolucion?mes='.$dev->fecha->format('m').'&anio='.$dev->fecha->format('Y'));
          return redirect('almacen/devolucion-ventas');


      }

      public function devolucionCreate(DevolucionObras $devolucion){


        return view('almacen.devolucionobras.create_devolucion',[
           'devolucion'=>$devolucion,
            'contrato'=>$devolucion->contrato,
            'vendedor'=>$devolucion->contrato->vendedor

        ]);

      }

      public function devolucionVentasDelete(DevolucionObras $devolucion){
        try{

            // return dd($devolucion);
            $devolucion->detalle()->delete();
            $contrato=$devolucion->contrato;
            $contrato->estado='procesado';
            $contrato->save();
            $devolucion->delete();

            Session::flash('success','La devolucion se elimino correctamente');
        }
        catch (\Exception $e){
            Session::flash('error','Ocurrio un Error al eliminar la devolucion');

        }
        return  redirect('devolucion-contratos?mes='.$devolucion->fecha->month.'&anio='.$devolucion->fecha->year);
      }


      public function rechazarDeVentas(DevolucionObras $devolucion){


        try{
            DB::beginTransaction();

           $devolucion->estado='VENTAS';
           $devolucion->save();
           $contrato=Contrato::find($devolucion->contrato_id);
           if($contrato){
           $contrato->estado='DEVOLUCION VENTA';
           $contrato->save();
           }
             
            DB::commit();
            session()->flash('success','El contrato se envio  a Ventas para su revision');

            
        }
        catch(Exception $e){
            DB::rollBack();
            session()->flash('warning','Ocurrio un error en el servidor');
            
        }
        return redirect()->back();


      }
}
