<?php
namespace App\Http\Controllers;
use App\cobrador;
use App\Contrato;
use App\Credito;
use App\Referencias;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Validator;
class CuentaController extends Controller
{
    public function cambiarMontoCuotas()
    {
        // return dd('asdcasd');
        $sql = Credito::where('estado', 'C')->select('montocuotas', 'numcuotas', 'saldo_inicial', 'id')->get();
        foreach ($sql as $row) {
            $monto_cuotas = ceil($row->saldo_inicial / $row->numcuotas);
            $row->update([
                'montocuotas' => $monto_cuotas
            ]);
        }
        return dd('cambiado');
    }
    public function editar(Credito $credito)
    {
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        return view('cobranza.cuentas.editar', [
            'credito' => $credito,
            'cobradores' => $cobradores,
        ]);
    }
    public function editarPost(Request $request)
    {
        if (auth()->user()->can('editar cobranza')) {
            // return dd($request->all());
            try {
                $credito = Credito::find($request->credito_id);
                $credito->fechadoc = $request->fechadoc;
                $credito->valor_venta = $request->valor_venta;
                $credito->numcuotas = $request->numcuotas;
                $credito->montocuotas = $request->montocuotas;
                $credito->nombre_cliente = strtoupper($request->nombre_cliente);
                $credito->cuotainicial = $request->cuota_inicial;
                $credito->saldo_inicial = $request->saldo_inicial;
                $credito->saldo = $request->saldo;
                $credito->diacobrar = $request->diacobrar;
                $credito->cobrador_id = $request->cobrador;
                $credito->save();
            } catch (\Exception $e) {
                return dd($e);
                Session::flash('error', 'Ocurrio un error inesperado');
            }
        } else {
            try {
                $credito = Credito::find($request->credito_id);
                $credito->cobrador_id = $request->cobrador;
                $credito->save();
                Session::flash('success', 'Los cambios se guardaron correctamente');
            } catch (\Exception $e) {
                Session::flash('error', 'Ocurrio un error inesperado');
            }
        }
        return redirect('cuentas?tipo=mes&mes=' . $credito->fechadoc->month . '&anio=' . $credito->fechadoc->year . '&buscar=buscar');
    }
    public function  index(Request $request)
    {
        $tipo = 'buscar';
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $numcuenta = '';
        $datos = [];
        if ($request->buscar == 'buscar') {
            
            $tipo = $request->tipo;
            if ($request->tipo =='mes') {
                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Credito::leftjoin('contratos as c', 'c.id', '=', 'credito.contrato_id')
                    //  ->Where('credito.estado','C')
                    ->whereMonth('credito.fechadoc', '=', $request->mes)
                    ->whereYear('credito.fechadoc', '=', $request->anio)
                    ->select(
                        'credito.numcuenta',
                        'credito.fechadoc',
                        'credito.id',
                        'credito.contrato_id',
                        'credito.saldo',
                        'credito.cobrador_id',
                        'credito.nombre_cliente',
                        'credito.vendedor_nombre'
                    )
                    ->orderBy('credito.fechadoc', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Credito::leftjoin('contratos as c', 'c.id', '=', 'credito.contrato_id')
                    //  ->where('credito.estado','C')
                    ->whereBetween('credito.fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->select(
                        'credito.numcuenta',
                        'credito.fechadoc',
                        'credito.id',
                        'credito.contrato_id',
                        'credito.saldo',
                        'credito.cobrador_id',
                        'credito.nombre_cliente',
                        'credito.vendedor_nombre'
                    )
                    ->orderBy('credito.fechadoc', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Credito::leftjoin('contratos as c', 'c.id', '=', 'credito.contrato_id')
                    // ->where('credito.estado','C')
                    ->whereBetween('credito.fechadoc', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->select(
                        'credito.numcuenta',
                        'credito.fechadoc',
                        'credito.id',
                        'credito.contrato_id',
                        'credito.saldo',
                        'credito.cobrador_id',
                        'credito.nombre_cliente',
                        'credito.vendedor_nombre'
                    )
                    ->orderBy('credito.fechadoc', 'DESC')->get();
            }
            if ($request->tipo == 'buscar') {
                $datos = Credito::leftjoin('contratos as c', 'c.id', '=', 'credito.contrato_id')
                    //   ->where('credito.estado','C')
                    ->select(
                        'credito.numcuenta',
                        'credito.fechadoc',
                        'credito.id',
                        'credito.contrato_id',
                        'credito.saldo',
                        'credito.cobrador_id',
                        'credito.nombre_cliente',
                        'credito.vendedor_nombre'
                    )
                    ->where('credito.id', $request->credito_id)->get();
            }
        } else {
            $datos = Credito::leftjoin('contratos as c', 'c.id', '=', 'credito.contrato_id')
                ->where('credito.estado', 'C')
                ->whereMonth('credito.fechadoc', '=', $mes)
                ->whereYear('credito.fechadoc', '=', $anio)
                ->select(
                    'credito.numcuenta',
                    'credito.fechadoc',
                    'credito.id',
                    'credito.contrato_id',
                    'credito.saldo',
                    'credito.cobrador_id',
                    'credito.nombre_cliente',
                    'credito.vendedor_nombre'
                )
                ->orderBy('credito.fechadoc', 'DESC')
                ->get();
        }
        return view('cobranza.cuentas.index', [
            'datos' => $datos,
            'tipo' => $tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
            'numcuenta' => $numcuenta
        ]);
    }
    public function verTarjetaCobranza(Credito $credito)
    {
        //        return dd($credito->toArray());
        return view('cobranza.includes.tarjeta_cobranza', [
            'credito' => $credito
        ]);
    }
    public function verContrato(Credito $credito)
    {
        // return dd($credito->contrato);
        if ($credito->tiene_contrato == 0) {
            return "<h2 class='alert alert-info text-center'>NO TIENE CONTRATO</h2>";
        }
        return view('ventas.diferidos.ver', [
            'contrato' => $credito->contrato
        ]);
    }
    public function verPagos(Credito $credito)
    {
        return view('cobranza.includes.ver_pagos', [
            'credito' => $credito
        ]);
    }
    public function descargarfoto($foto)
    {
        $imagen = storage_path('imagenes/contratos/' . $foto);
        return response()->download($imagen);
    }
    public function referencias(Request $request)
    {
        $credito = null;
        $ref = null;
        if (isset($request->credito_id)) {
            $credito = Credito::find($request->credito_id);
        }
        if (isset($credito->ref)) {
            $ref = $credito->ref;
        }
        $imagen = "";
        if (!is_null($credito) && $credito->foto != '') {
            $imagen = Storage::disk('public')->get('contratos/' . $credito->foto);
        }
        return view('cobranza.referencias.index', [
            'credito' => $credito,
            'ref' => $ref,
            'imagen' => $imagen
        ]);
    }
    public function referenciasStoreImage(Request $request)
    {
        $post = $request->all();
        if (!$request->file("foto")) {
            session()->flash('error', 'No se selecciono ningun archivo');
            return redirect()->back();
        }
        $validator = Validator::make($request->all(), [
            'foto' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        if ($validator->fails()) {
            session()->flash('error', 'La imagen es muy grande o no tiene el formato requerido');
            return redirect()->back();
        }
        try {
            $credito = Credito::find($request->credito_id);
            $image = $request->file('foto');
            $filename  = $credito->numcuenta . '.' . $image->getClientOriginalExtension();
            $path = Storage::disk('public')->putFileAs('contratos', $request->file('foto'), $filename);
            $credito->foto = $filename;
            $credito->save();
            session()->flash('success', 'La imagen se guardo correctamente');
            return redirect('referencias')->with($request);
        } catch (\Exception $e) {
            session()->flash('error', 'Ocurrio un error');
            return redirect()->back();
        }
    }
    public function verFoto(Credito $credito)
    {
        $imagen = "";
        if (!is_null($credito) && $credito->foto != '') {
            $imagen = Storage::disk('public')->get('contratos/' . $credito->foto);
        }
        return view('cobranza.includes.fotos', ['credito' => $credito, 'imagen' => $imagen]);
    }
    public function referenciasStore(Request $request)
    {
        try {
            // return dd($request->all());
            $sql = Referencias::where('credito_id', $request->credito_id)->first();
            if (!is_null($sql)) {
                $ref = $sql;
            } else {
                $ref = new Referencias();
            }
            $credito = Credito::find($request->credito_id);
            $credito->nombre_cliente = $request->nombres_titular . ' ' . $request->apellidopaterno_titular . ' ' . $request->apellidomaterno_titular;
            $credito->save();
            $contrato = $credito->contrato;
            if (!is_null($contrato)) {
                $contrato->nombres = $request->nombres_titular;
                $contrato->apellidopaterno = $request->apellidopaterno_titular;
                $contrato->apellidomaterno = $request->apellidomaterno_titular;
                $contrato->save();
            }
            $ref->edad = $request->edad;
            $ref->expedidoci = $request->expedidoci;
            $ref->direccion = $request->direccion;
            $ref->dir_num = $request->dir_num;
            $ref->telf = $request->telf;
            $ref->cel = $request->cel;
            $ref->barrio = $request->barrio;
            $ref->zona = $request->zona;
            $ref->email = $request->email;
            $ref->centrotrabajo = $request->centrotrabajo;
            $ref->cargoocupa = $request->cargoocupa;
            $ref->antiguedad = $request->antiguedad;
            $ref->direcciontrabajo = $request->direcciontrabajo;
            $ref->numtrabajo = $request->numtrabajo;
            $ref->telftrabajo = $request->telftrabajo;
            $ref->barriotrabajo = $request->barriotrabajo;
            $ref->zonatrabajo = $request->zonatrabajo;
            $ref->nombrescoyuge = $request->nombrescoyuge;
            $ref->ciconyuge = $request->ciconyuge;
            $ref->celconyuge = $request->celconyuge;
            $ref->trabajoconyuge = $request->trabajoconyuge;
            $ref->ocupacionconyuge = $request->ocupacionconyuge;
            $ref->antiguedadconyuge = $request->antiguedadconyuge;
            $ref->dirtrabajoconyuge = $request->dirtrabajoconyuge;
            $ref->numdirtrabajoconyuge = $request->numdirtrabajoconyuge;
            $ref->telftrabajoconyuge = $request->telftrabajoconyuge;
            $ref->barriotrabajoconyuge = $request->barriotrabajoconyuge;
            $ref->zonatrabajoconyuge = $request->zonatrabajoconyuge;
            $ref->nombrehijos1 = $request->nombrehijos1;
            $ref->colegiohijos1 = $request->colegiohijos1;
            $ref->cursohijos1 = $request->cursohijos1;
            $ref->nombrehijos2 = $request->nombrehijos2;
            $ref->colegiohijos2 = $request->colegiohijos2;
            $ref->cursohijos2 = $request->cursohijos2;
            $ref->credito_id = $request->credito_id;
            $ref->nombresgarante = $request->nombresgarante;
            $ref->celgarante = $request->celgarante;
            $ref->telfgarante = $request->telfgarante;
            $ref->dirgarante = $request->dirgarante;
            $ref->numgarante = $request->numgarante;
            $ref->zonagarante = $request->zonagarante;
            $ref->trabajogarante = $request->trabajogarante;
            $ref->barriotrabajogarante = $request->barriotrabajogarante;
            $ref->credito_id = $request->credito_id;
            $ref->save();
            Session::flash('success', 'LAS REFERENCIAS SE GUARDARON CORRECTAMENTE');
        } catch (\Exception $e) {
            return dd($e);
            Session::flash('error', 'OCURRIO UN ERRROR');
        }
        return redirect()->back();
    }
}
