<?php
namespace App\Http\Controllers;
use App\Contrato;
use App\Credito;
use App\Libro;
use App\Kardex;
use App\CierreApertura;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class CommonController extends Controller
{
    public function getStock(Request $request)
    {
        $sql = Libro::where('codigo', $request->codigo)->select('stock')->first();
        $stock = 0;
        if (!is_null($sql)&& !is_null($sql->stock)) {
            $stock = $sql->stock;
        }
        return response()->json($stock, 200);
    }
    public function regularizacionInventario()
    {
        $fecha = Carbon::now();
        $query = Libro::RegularizacionInventario($fecha);
        return back(); 
    }
    public function validarCierre(Request $request)
    {
        $result = true;
        $fecha = \Carbon\Carbon::createFromFormat('d/m/Y', $request->fecha);
        $sql = CierreApertura::where('modulo', $request->modulo)
            ->where('mes', $fecha->month)
            ->where('anio', $fecha->year)
            ->first();
        // return dd($sql);
        if (is_null($sql)) {
            $result = false;
        } else {
            if ($sql->estado == 'CERRADO') {
                $result = false;
            }
        }
        return response()->json($result);
    }
    public function calcularPlanPagos(Request $request)
    {
        try {
            // return dd($request->all());
            $fecha = Carbon::createFromFormat('d/m/Y', $request->fecha)->format('Y-m-d');
            $di = "P" . $request->diasgracia . "D";
            $fecha = new \DateTime($fecha);
            $fecha->add(new \DateInterval($di));
            $fechaprimerpago = $fecha->format("Y-m-d");
            $intervalodias = round($request->diaspago / $request->numcuotas, 0);
            $fecha2 = new \DateTime($fechaprimerpago);
            $cadena1 = [];
            for ($i = 0; $i < $request->numcuotas; $i++) {
                $cadena2 = [];
                $j = 1;
                $f = $intervalodias * $j;
                $di = "P" . $f . "D";
                $fecha2->add(new \DateInterval($di));
                $cadena2["numcuota"] = ($i + 1) . "/" . $request->numcuotas;
                $cadena2["fecha"] = $fecha2->format('d/m/Y');
                $cadena2["monto"] = round($request->saldo / $request->numcuotas, 2);
                $cadena[$i] = $cadena2;
                $j++;
            }
            return response()->json([
                'datos' => $cadena,
                'status' => true
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'datos' => [],
                'error' => $e,
                'status' => false
            ], 500);
        }
    }
    public function verKardex($tipo, $id)
    {
        $datos = Kardex::kardexDocumento($tipo, $id);
        $vista = view('almacen.kardex.tabla-kardex', [
            'tipo_documento' => $datos['tipo_documento'],
            'numero' => $datos['numero'],
            'datos' => $datos['datos'],
            'totales' => $datos['totales']
        ])->render();
        return response()->json([
            'datos' => $vista,
            'tipo_doc' => $datos['tipo_documento'],
            'numero' => $datos['numero'],
            //             'totales'=>$datos['totales']
        ]);
        //        return view('almacen.kardex.tabla-kardex',[
        //            'tipo_documento'=>$datos['tipo_documento'],
        //            'numero'=>$datos['numero'],
        //            'datos'=>$datos['datos'],
        //             'totales'=>$datos['totales']
        //        ]);
    }
    public function buscarCuenta(Request $request)
    {
        if ($request->tipo == 'numero') {
            $cuentas = Credito::whereIn('estado', ['C', 'T'])
                //  ->where('numcuenta', 'like', '%' . $request->term. '%' )
                //  ->where('numcuenta', 'LIKE', '' . $request->term. '%' )
                ->where('numcuenta', $request->term)
                ->select('id', 'nombre_cliente', 'numcuenta')
                ->get();
        }
        if ($request->tipo == 'apellidos') {
            $cuentas = Credito::where('nombre_cliente', 'like',  $request->term . '%')
                ->select('id', 'nombre_cliente', 'numcuenta')
                ->get();
        }
        return response()->json($cuentas->toArray());
    }
    public function buscarCuentaAntigua(Request $request)
    {
        if ($request->tipo == 'numero') {
            $cuentas = Credito::whereIn('estado', ['C', 'T'])
                //  ->where('numcuenta', 'like', '%' . $request->term. '%' )
                ->where('numcuenta', $request->term)
                // ->where('tiene_contrato', 0 )
                ->select('id', 'nombre_cliente', 'numcuenta')
                ->get();
        }
        if ($request->tipo == 'apellidos') {
            $cuentas = Credito::where('nombre_cliente', 'like', '%' . $request->term . '%')
                //    ->where('tiene_contrato', 0 )    
                ->select('id', 'nombre_cliente', 'numcuenta')
                ->get();
        }
        if ($request->tipo == 'carnet') {
            $cuentas = Credito::where('nombre_cliente', 'like', '%' . $request->term . '%')
                //    ->where('tiene_contrato', 0 )    
                ->select('id', 'nombre_cliente', 'numcuenta')
                ->get();
        }
        return response()->json($cuentas->toArray());
    }
    public function buscarDeudor(Request $request)
    {
        // return dd($request->all());
        if ($request->tipo == 'numero') {
            $deudores = \App\Deudor::join('credito as c', 'c.id', '=', 'deudores.credito_id')
                //  ->where('numcuenta', 'like', '%' . $request->term. '%' )
                ->where('c.numcuenta',  $request->term)
                // ->where('tiene_contrato', 0 )
                ->selectRaw('deudores.id,CONCAT_WS(" ",deudores.nombres,deudores.apellidos) as nombres ,deudores.credito_id,num_doc_deuda')
                ->get();
        }
        if ($request->tipo == 'apellidos') {
            $deudores = \App\Deudor::where('apellidos', 'LIKE', '' . $request->term . '%')
                ->selectRaw('id,CONCAT_WS(" ",nombres,apellidos)as nombres,num_doc_deuda,credito_id')
                ->get();
        }
        if ($request->tipo == 'carnet') {
            $deudores = \App\Deudor::where('num_documento', $request->term)
                ->selectRaw('id,CONCAT_WS(" ",nombres,apellidos)as nombres,num_doc_deuda,credito_id')
                ->get();
        }
        // return response()->json([
        //     'datos'=>$deudores->ToArray(),
        //     'tipo'=>$request->tipo,
        // ]);
        return response()->json($deudores->toArray());
    }
    function verNota(Request $request)
    {
        if ($request->tipo == 'N.INGRESO') {
            $ingreso = \App\NotasIngreso::find($request->numero);
            return view('almacen.partials.nota_ingreso', [
                'ingreso' => $ingreso
            ]);
        } elseif ($request->tipo == 'N.EGRESO') {
            $egreso = \App\NotasEgreso::find($request->numero);
            return view('almacen.partials.nota_egreso', [
                'egreso' => $egreso
            ]);
        } elseif ($request->tipo == 'N.REMISION') {
            $remision = \App\NotasRemision::find($request->numero);
            return view('almacen.partials.notaremision', [
                'remision' => $remision
            ]);
        } elseif ($request->tipo == 'N.DEVOLUCION') {
            $devolucion = \App\NotasDevolucion::find($request->numero);
            return view('almacen.partials.nota_devolucion', [
                'dev' => $devolucion
            ]);
        } elseif ($request->tipo == 'DIFERIDO' || $request->tipo == 'VENTA') {
            $contrato = Contrato::where('numcontrato', $request->numero)->first();
            return view('ventas.diferidos.ver', [
                'contrato' => $contrato
            ]);
        }
    }
}