<?php

namespace App\Http\Controllers;

use App\cobrador;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use  Excel;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\CobradoresListaExport;


class CobradorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $datos=cobrador::orderBy('apellidos','ASC')->get();

       

          if (isset($request->tipoexportacion)) {

                $tipo = $request->tipoexportacion;

                $nombrearchivo = 'Cobradores';
               

            

             if ($tipo == 'excel') {
                 $cobradores= \Illuminate\Support\Collection::make($datos);
                return \Excel::download(new CobradoresListaExport($cobradores), 'cobradores.xlsx');


                    // \Excel::create($nombrearchivo, function ($excel) use ($datos) {
                    //     $excel->sheet('kardex', function ($sheet) use ($datos) {
                    //         $sheet->loadView('cobradores.exportar', [
                    //                 'cobradores' => \Illuminate\Support\Collection::make($datos),
                    //                 'estilos' => false,
                                   

                    //             ]
                    //         );
                    //     });
                    // })->download('xlsx');
                } elseif ($tipo == 'pdf') {

                    $pdf = PDF::loadView('cobradores.exportar', [
                        'cobradores' => \Illuminate\Support\Collection::make($datos),
                        'estilos' => true,
                       
                    ]);
                    $pdf->setPaper('a4', 'portrait');

                    return $pdf->stream($nombrearchivo);
                }
            } 
        return view('cobradores.index',[
            'cobradores'=>$datos
        ]);
    
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try{
            if(isset($request->id))
            {
                $c=cobrador::find($request->id);
            }
            else{
            $c=new cobrador();
                }
       $c->nombres=$request->nombres;
   $c->apellidos=$request->apellidos;
   $c->codigo=substr($request->nombres,0,1).substr($request->apellidos,0,1).'-'.\Illuminate\Support\Str::random(4);
   $c->carnet=$request->carnet;
   $c->telefono=$request->telefono;
   $c->email=$request->email;
   $c->direccion=$request->direccion;
   $c->estatus=$request->estado;
   $c->nacionalidad=$request->nacionalidad;
   $c->tipo_documento=$request->tipo_documento;
   $c->save();
   Session::flash('success','El cobrador se guardo correctamente');
        }
        catch (\Exception $e){
            Session::flash('error','Ocurrio un error inesperado');

        }
        return redirect('cobradores');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(cobrador $cobrador)
    {
        return view('cobradores.create_edit',[
            'cobrador'=>$cobrador
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(cobrador $cobrador)
    {
        try{
            $cobrador->delete();
            Session::flash('success','Se elimino el cobrador correctamente');
        }
        catch (\Exception $e){
            Session::flash('error','Ocurrio un error al eliminar el cobrador');

        }
        return redirect('cobradores');
    }
}
