<?php

namespace App\Http\Controllers;

use App\CambioObra;
use App\Credito;
use App\DetalleCambioObra;
use App\DetalleEgreso;
use App\DetalleIngreso;
use App\Helper\Helper;
use App\Libro;
use App\NotasEgreso;
use App\NotasIngreso;
use App\Pago;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class CambioObraController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $tipo = 'mes';
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $numcuenta = '';
        $datos = [];

        if ($request->buscar == 'buscar') {

            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {

                $mes = $request->mes;
                $anio = $request->anio;
                $datos = CambioObra::whereMonth('fecha', '=', $request->mes)
                    ->whereYear('fecha', '=', $request->anio)
                    ->orderBy('fecha', 'DESC')->get();

            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = CambioObra::whereBetween('fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('fecha', 'DESC')->get();

            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = CambioObra::whereBetween('fecha', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('fecha', 'DESC')->get();
            }
//            if($request->tipo=='buscar'){
//
//                $datos=CambioObra::where('procedencia','cobranza')
//                    ->where('id',$request->numcuenta)->get();
//            }
        } else {
            $datos = CambioObra::whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->orderBy('fecha', 'DESC')
                ->get();
        }

        return view('cobranza.cambios.index', [
            'datos' => $datos,
            'tipo' => $tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);

    }

    public function create()
    {
        return view('cobranza.cambios.create_edit');

    }

    public function createPost(Request $request)
    {
        $credito = Credito::where('id', $request->credito_id)->with('contrato')->first();
        $libros = Libro::orderBy('codigo', 'ASC')->get();

        if (!isset($credito->contrato)) {
            Session::flash('info', 'Esta cuenta no tiene contrato registrado');
            return redirect()->back();
        }


        if ($credito->contrato->tipocontrato != 'VENTA') {
            Session::flash('info', 'Este     contrato no esta facturado');
            return redirect()->back();
        }
        $pagos = Pago::where('model_type', 'pago-cobranza')
            ->where('model_id', $request->credito_id)
            ->orderBy('fecha', 'ASC')
            ->get();
        $cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);

        return view('cobranza.cambios.create_edit', [
            'credito' => $credito,
            'pagos' => $pagos,
            'cuotas' => $cuotas,
            'criterio' => $request->numcuenta,
            'tipo' => $request->tipo,
            'libros' => $libros
        ]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $sql = CambioObra::where('credito_id', $request->credito_id)
                ->where('estado', 'ALMACEN')
                ->first();
            if (!is_null($sql) || $sql) {
                Session::flash('info', 'Ya existe un cambio de obra, esparando hacer procesado en almacen');
                return redirect()->back();
            }

            \DB::beginTransaction();
            $cambio = new CambioObra();
            $cambio->fecha = $request->fecha;
            $cambio->estado = 'ALMACEN';
            $cambio->terminado = 0;
            $cambio->saldo = $request->saldo_actual;
            $cambio->credito_id = $request->credito_id;
            $cambio->numcuotas = $request->numcuotas;
            $cambio->fechacuotas = $request->fechacuotas;
            $cambio->dias_pago = $request->diaspago;
            $cambio->obs = $request->obs;
            $cambio->user_id = Auth::user()->id;
            $cambio->save();
            foreach ($request->cambio as $k => $v) {
                $detalle = new DetalleCambioObra();
                $detalle->libro_id = $request->cambio_libros_id[$k];
                $detalle->cantidad = $request->cambio_cantidad[$k];
                $detalle->precio_unit = $request->cambio_precio_unitario[$k];
                $detalle->cambioobra_id = $cambio->id;
                $detalle->codigo = $request->cambio_codigo[$k];
                $detalle->titulo = $request->cambio_titulo[$k];
                if ($v == 1) {
                    $detalle->tipo = 'e';
                    $detalle->cambio = 1;
                } else {
                    $detalle->tipo = 'c';
                    $detalle->cambio = 0;
                }
                $detalle->save();

            }
            foreach ($request->libros_id_ingreso as $k => $v) {
                $detalle = new DetalleCambioObra();
                $detalle->libro_id = $v;
                $detalle->cantidad = $request->cantidad_ingreso[$k];
                $detalle->precio_unit = $request->precio_unitario_ingreso[$k];
                $detalle->cambioobra_id = $cambio->id;
                $detalle->codigo = $request->codigo_ingreso[$k];
                $detalle->titulo = $request->titulo_ingreso[$k];

                $detalle->tipo = 'i';
                $detalle->cambio = 1;

                $detalle->save();

            }
            DB::commit();
            Session::flash('success', 'EL cambio de obra se registro correctamente');
        } catch (\Exception $e) {
            return dd($e);
            Session::flash('error', 'Ocurrio un error al guardar el cambio de obra');

            DB::rollBack();
            return redirect()->back();
        }

        return redirect('cambio-obras?mes=' . $cambio->fecha->month . '&anio=' . $cambio->fecha->year . 'tipo=mes');



    }

    public function verNota(CambioObra $cambio)
    {
        return view('cobranza.cambios.nota', [
            'cambio' => $cambio
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CambioObra  $cambioObra
     * @return \Illuminate\Http\Response
     */
    public function show(CambioObra $cambioObra)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CambioObra  $cambioObra
     * @return \Illuminate\Http\Response
     */
    public function edit(CambioObra $cambioObra)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CambioObra  $cambioObra
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CambioObra $cambioObra)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CambioObra  $cambioObra
     * @return \Illuminate\Http\Response
     */
    public function destroy(CambioObra $cambioObra)
    {
        //
    }
    public function almacenCambioObra()
    {

        $datos = CambioObra::where('estado', 'ALMACEN')->orderBy('created_at', 'DESC')->get();
        return view('almacen.cambioobra.index', [
            'datos' => $datos
        ]);
    }
    public function procesarAlmacen(Request $request)
    {
            //   return dd($request->all());


        try {
            DB::beginTransaction();
            $cambio = CambioObra::find($request->cambio_id);

            $i = new NotasIngreso();
            $i->recibe = 'ALMACEN CENTRAL';
            $i->envia = $request->ingreso_envia;
            $i->fecha = $request->ingreso_fecha;
            $i->concepto = 'CAMBIO OBRA';
            $i->cant_total = $cambio->detalle_ingresos->sum('cantidad');
            $i->glosa = strtoupper($request->ingreso_glosa);
            $i->estado = 'T';
            $i->precio_total = $cambio->detalle_ingresos->sum('precio_total');
            $i->user_id = Auth::user()->id;
            $i->terminado = 1;
            $i->obs = $request->ingreso_obs;
            $i->save();

            foreach ($request->ingreso_detalle_libro_id as $k => $v) {
                $det = new DetalleIngreso();
                $libro = Libro::find($v);
                $det->cantidad = $request->cant[$k];
                $det->codigo = $libro->codigo;
                $det->titulo = $libro->titulo;
                $det->volumen = $libro->tomo;
                $det->precio_unitario = $request->ingreso_detalle_preciounitario[$k];
                $det->precio_total = $request->ingreso_detalle_preciototal[$k];
                $det->libro_id = $v;
                $det->ingreso_id = $i->id;
                $det->obs = $request->ingreso_obs_detalle[$k];
                $det->save();


            }
            foreach ($i->detalle as $d) {
                $libro = Libro::where('codigo', $d->codigo)->first();
                if (!is_null($libro)) {
                    $libro->stock = $libro->stock + $d->cantidad;
                    $libro->save();
                }
            }

            $egreso = new NotasEgreso();
            $egreso->envia = 'ALMACEN CENTRAL';
            $egreso->recibe = $request->egreso_recibe;
            $egreso->fecha = $request->egreso_fecha;
            $egreso->destino = 'CAMBIO DE OBRA';
            $egreso->cant_total = $cambio->detalle_egresos->sum('cantidad');
            $egreso->estado = 'T';
            $egreso->precio_total = $cambio->detalle_egresos->sum('precio_total');
            $egreso->user_id = auth()->user()->id;
            $egreso->terminado = 1;
//            $egreso->moneda=$request->;
//            $egreso->valor_cambio=$request->;
            $egreso->obs = $request->egreso_obs;
            $egreso->save();

            foreach ($request->egreso_detalle_libro_id as $k => $v) {
                $det = new DetalleEgreso();
                $libro = Libro::find($v);
                $det->cantidad = $request->egreso_detalle_cantidad[$k];
                $det->codigo = $libro->codigo;
                $det->titulo = $libro->titulo;
                $det->volumen = $libro->tomo;
                $det->precio_unitario = $request->egreso_detalle_preciounitario[$k];
                $det->precio_total = round($request->egreso_detalle_preciototal[$k]);
                $det->libro_id = $v;
                $det->egreso_id = $egreso->id;
                $det->obs = $request->egreso_obs_detalle[$k];
                $det->save();
            }
            foreach ($egreso->detalle as $d) {
                $libro = Libro::find($d->libro_id);
                if (!is_null($libro)) {
                    $libro->stock = $libro->stock - $d->cantidad;
                    $libro->save();
                }
            }
            $credito = Credito::find($cambio->credito_id);
         
          

            if ((float)$credito->saldo < $cambio->saldo) {
                $cambio->tipo_saldo = 'AUMENTA';
                $cambio->monto_tipo_saldo = $cambio->saldo - $credito->saldo;
            }
            if ((float)$credito->saldo > $cambio->saldo) {
             
                $cambio->tipo_saldo = 'DISMINUYE';
                $cambio->monto_tipo_saldo = $credito->saldo - $cambio->saldo;
            }
            if ((float)$credito->saldo == $cambio->saldo) {

                $cambio->tipo_saldo = 'IGUAL';
                $cambio->monto_tipo_saldo = 0;
            }
            $credito->numcuotas = $cambio->numcuotas;
            $credito->saldo = $cambio->saldo;

            $cambio->estado = 'PROCESADO';
            $cambio->terminado = '1';
            $cambio->numingreso = $i->id;
            $cambio->numegreso = $egreso->id;
            $cambio->save();

            

           
            if ($credito->saldo <= 0) {
                $credito->estado = 'T';
                $credito->fecha_terminado = $cambio->fecha;
                $credito->tipo_terminado = 'cambioObra';
                $credito->id_terminado = $cambio->id;
                $credito->fecha_terminado = $cambio->fecha;
                $credito->save();
            }

          
           
           

            $credito->fechacuotas = $cambio->fechacuotas->format('d/m/Y');
            $credito->dias = $cambio->dias_pago;
            $credito->save();


            DB::commit();
            Session::flash('success', 'El cambio de obra se proceso correctamente');
        } catch (\Exception $e) {


            return dd($e);

            DB::rollBack();
            Session::flash('error', 'Ocurrio un error al procesar');


        }
        return redirect('almacen/cambio-obra');
    }
    public function registrarNotasAlmacen(CambioObra $cambio)
    {

        return view('almacen.cambioobra.procesar', [
            'cambio' => $cambio
        ]);

    }
}
