<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Svg\Tag\Path;
use App\Backups;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\HttpFoundation\Response;
use Carbon\Carbon;
use TheSeer\Tokenizer\Exception;

class BackupController extends Controller
{

    private $service;
    function __construct()
    {
        $client = new \Google_Client();

        $client->setClientId(env('GOOGLE_DRIVE_CLIENT_ID'));
        $client->setClientSecret(env('GOOGLE_DRIVE_CLIENT_SECRET'));
        $client->refreshToken(env('GOOGLE_DRIVE_REFRESH_TOKEN'));

        $this->service = new \Google_Service_Drive($client);
    }
    //
    public function prueba()
    {

        // $archivo = public_path() . '/CONSOLIDADO.xlsx';
        // return $archivo;
        Storage::disk('google')->put('test.txt', 'jajajajaj');

    }

    function downloadLocal(Backups $backup)
    {

        if (Storage::disk('backups')->exists('Laravel/' . $backup->name_file)) {
            return Response()->download(storage_path() . '/backups/Laravel/' . $backup->name_file);
        } else {
            return false;
        }

    }

    function downloadNube($fileId)
    {

        try {

            $content = $this->service->files->get($fileId, array(
                'alt' => 'media'
            ));
            // return dd($content->getHeaders());
            foreach ($content->getHeaders() as $name => $values) {
                header($name . ': ' . implode(', ', $values));
            }
            $yourfilename = 'backup.zip';
            header('Content-Disposition: inline; filename="' . $yourfilename . '"');
            echo $content->getBody();

        } catch (\Exception $e) {

        }

    }


    function create()
    {
        try {
            Artisan::call('backup:run');
            session()->flash('success', ' Se realizo el Backup con Exito !');
        } catch (\Exception $e) {
            session()->flash('error', ' Ocurrio un error en el servidor . intentelo nuevamente ');

        }
        return back();
    }

    protected function downloadFile($service, $file)
    {
        $downloadUrl = $file->webContentLink;
        return dd($downloadUrl);
        if ($downloadUrl) {
            $request = new Google_Http_Request($downloadUrl, 'GET', null, null);
            $httpRequest = $service->getClient()->getAuth()->authenticatedRequest($request);
            if ($httpRequest->getResponseHttpCode() == 200) {
                return $httpRequest->getResponseBody();
            } else {
      // An error occurred.
                return null;
            }
        } else {
    // The file doesn't have any content stored on Drive.
            return null;
        }
    }


    public function cloud()
    {
    

        // return dd($service);

        $result = [];
        $pageToken = null;

        $three_months_ago = Carbon::now()->subMonths(3)->toRfc3339String();

        do {
            try {
                $parameters = [
                    'q' => "'" . env('GOOGLE_DRIVE_FOLDER_ID') . "' in parents",


                    // 'q' => "viewedByMeTime >= '$three_months_ago' or modifiedTime >= '$three_months_ago'",
                    'orderBy' => 'modifiedTime',
                    'fields' => 'nextPageToken, files(id, name, modifiedTime, iconLink, webViewLink, webContentLink)',
                ];

                if ($pageToken) {
                    $parameters['pageToken'] = $pageToken;
                }

                $result = $this->service->files->listFiles($parameters);
                $files = $result->files;

                $pageToken = $result->getNextPageToken();

            } catch (Exception $e) {
                return dd($e);
                return redirect('/files')->with(
                    'message',
                    [
                        'type' => 'error',
                        'text' => 'Something went wrong while trying to list the files'
                    ]
                );
                $pageToken = null;
            }
        } while ($pageToken);

        $page_data = [
            'files' => $files
        ];

        // return dd($page_data['files']);

        return view('backups.drive', [
            'datos' => $page_data['files']
        ]);

    }
    public function index(Request $request)
    {
        $mes = date(' m ');
        $anio = date(' Y ');

        if (isset($request->consulta)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }

        $datos = Backups::whereMonth('date', '=', $mes)
            ->whereYear('date', '=', $anio)
            ->get();

        return view(' backups.index ', [
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio
        ]);
    }
}
