<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class DevolucionObras extends Model
{
    protected $table='devolucionobras';
    protected  $fillable=[
        'fecha',
        'num_cuenta',
        'num_contrato',
        'estado',
        'tipo_devolucion',
        'obs',
        'user_id',
        'contrato_id',
        'ingreso_id',
        'procedencia',
        'fecha_remision',
        'monto_saldo',
        'monto_devolucion',


    ];
    protected $dates=['fecha','fecha_remision'];


    public function contrato(){
        return $this->belongsTo(Contrato::class,'contrato_id','id');
    }

    public function ingreso(){
        return $this->belongsTo(NotasIngreso::class,'ingreso_id');

    }

    public function detalle(){
        return $this->hasMany(DetalleDevolucionObras::class,'devolucionobras_id');
    }

    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function setFechaAttribute($fecha){

        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);

    }
}
