<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DetalleEgreso extends Model
{
    protected  $table='detalle_egreso';
    protected $fillable=[
        'cantidad',
        'precio_total',
        'codigo',
        'titulo',
        'volumen',
        'libro_id',
        'precio_unitario',
        'egreso_id',
        'obs',
            ];

    public  $timestamps=false;

    public function getPrecioTotalAttribute(){
        return round($this->cantidad*$this->precio_unitario,2);
    }
    public function egreso(){
        return $this->belongsTo(NotasEgreso::class,'egreso_id');
    }
}
