<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DetalleContrato extends Model
{
   protected  $table='detalle_contrato';
   protected  $fillable=[
        'cantidad',
        'codigo',
        'titulo',
        'volumen',
        'precio_unitario',
        'contrato_id',
        'libros_id',
        'sw',
   ];
   public  $timestamps=false;

   public function contrato(){
       return $this->belongsTo(Contrato::class,'contrato_id');
   }

   public function getPrecioTotalAttribute(){
       return round(($this->cantidad*$this->precio_unitario),2);

   }

   public function libro(){
       return $this->hasOne(Libro::class,'codigo','codigo');
   }
}
