<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class Contrato extends Model
{
    protected $table='contratos';
    protected  $fillable=[

            'numcontrato',
            'tipocontrato',
            'fechacontrato',
            'localidad',
            'preciototal',
            'tipoventa',
            'idvendedor',
            'idchofer',
            'nombres',
            'apellidopaterno',
            'apellidomaterno',
            'ci',
            'terminado',
             'user_id',
              'estado'
    ];
    protected $dates=['fechacontrato'];

    public function devolucion(){
        return $this->hasOne(DevolucionObras::class,'contrato_id','id');
    }

    public function getNombreCompletoAttribute(){
        return $this->attributes['nombres'].' '.$this->attributes['apellidopaterno'].' '.$this->attributes['apellidomaterno'];
    }
    public function getApellidosAttribute(){
        return $this->attributes['apellidopaterno'].' '.$this->attributes['apellidomaterno'];
    }
    public function vendedor(){
        return $this->belongsTo(Vendedor::class,'idvendedor');
    }
//    public function cobrador(){
//        return $this->belongsTo(cobrador::class,'idvendedor');
//    }

    public function chofer(){
        return $this->belongsTo(Vendedor::class,'idchofer');
    }

    public function setFechacontratoAttribute($fecha){
        $this->attributes['fechacontrato']=Carbon::createFromFormat('d/m/Y',$fecha);
    }

    public function detalle(){
        return $this->hasMany(DetalleContrato::class,'contrato_id')->orderBy('codigo','ASC');
    }

    public function credito(){
        return $this->HasOne(Credito::class,'contrato_id','id');
    }


    public static  function agenda($fecha_ini,$fecha_fin,$fecha_ref,$vendedor,$mes,$anio,$acumulado,$filtro){

$datos=[];
//return  dd($filtro,$vendedor,$mes,$anio);
if($filtro=='MES'){
    if($vendedor==0 || is_null($vendedor)) {
        $sql = self::where('tipocontrato','DIFERIDO')
            ->whereMonth('fechacontrato','=',$mes)
            ->whereYear('fechacontrato','=',$anio)
            ->orderBy('id', 'ASC')
            ->get();
    }
    else{
        $sql = self::where('tipocontrato', 'DIFERIDO')
            ->whereMonth('fechacontrato','=',$mes)
            ->whereYear('fechacontrato','=',$anio)
            ->where('idvendedor',$vendedor)
            ->orderBy('id', 'ASC')->get();
    }

}
elseif ($filtro=='RANGO') {
    if ($vendedor == 0 || is_null($vendedor)) {
        $sql = self::where('tipocontrato', 'DIFERIDO')
            ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
            ->orderBy('id', 'ASC')->get();
    } else {
        $sql = self::where('tipocontrato', 'DIFERIDO')
            ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
            ->where('idvendedor', $vendedor)
            ->orderBy('id', 'ASC')->get();
    }
}
elseif ($filtro=='ACUMULADO'){
    if ($vendedor == 0 || is_null($vendedor)) {
        $sql = self::where('tipocontrato', 'DIFERIDO')
            ->whereBetween('fechacontrato', ['2001-01-01', $fecha_fin->format('Y-m-d')])
            ->orderBy('id', 'ASC')->get();
    } else {
        $sql = self::where('tipocontrato', 'DIFERIDO')
            ->whereBetween('fechacontrato', ['2001-01-01', $fecha_fin->format('Y-m-d')])
            ->where('idvendedor', $vendedor)
            ->orderBy('id', 'ASC')->get();
    }
}

        if(count($sql)>0){
            foreach($sql as $c){

                $dias=$c->fechacontrato->diffInDays($fecha_ref);
                $numero=0;
                    $numero7=0;
                    $numero15=0;
                    $numero30=0;
                    $numeromas=0;
                if($dias<8){
                    $numero7=1;
                    $numero15=0;
                    $numero30=0;
                    $numeromas=0;
                }
                elseif ($dias <16 && $dias >6){
                    $numero7=0;
                    $numero15=1;
                    $numero30=0;
                    $numeromas=0;
                }
                elseif ($dias <31 && $dias >29){
                    $numero7=0;
                    $numero15=0;
                    $numero30=1;
                    $numeromas=0;
                }
                elseif ($dias>30){
                    $numero7=0;
                    $numero15=0;
                    $numero30=0;
                    $numeromas=1;
                }


                $datos[]=[
                    'fecha'=>$c->fechacontrato->format('d/m/Y'),
                    'vendedor'=>$c->vendedor->nombre_completo,
                    'cliente'=>$c->nombre_completo,
                    'numcontrato'=>$c->numcontrato,
                    'numero7'=>$numero7,
                    'numero15'=>$numero15,
                    'numero30'=>$numero30,
                    'mas'=>$numeromas,
             ];
            }

        }

        return Collection::make($datos);

    }

    public function validarDisponibles(){

        $faltantes=[];
//        return dd($this->detalle);

        if(count($this->detalle)>0){
            foreach($this->detalle as $d){
                $disponible=Kardex::select('id')
                    ->where('vendedor_id',$this->idchofer)
                    ->where('cod_libro',$d->codigo)
                    ->whereIn('estado',['Remitido'])
                    ->whereIn('cargo',[0,1])
                    ->whereMonth('fechakardex','=',$this->fechacontrato->month)
                    ->whereYear('fechakardex','=',$this->fechacontrato->year)
                    ->get()->count();
//                return dd($d->cantidad,$d->codigo);
                if($disponible<$d->cantidad){
                    $faltantes[]=[
                        'codigo'=>$d->codigo,
                        'titulo'=>$d->titulo,
                        'tomo'=>$d->volumen,
                        'cantidad_faltante'=>$d->cantidad-$disponible,
                        'cantidad'=>$d->cantidad,
                        'libro_id'=>$d->libro_id,
                    ];
                }
            }
        }

        return $faltantes;

    }

    public static  function planillaProduccion($filtro='mes',$mes=null,$anio=null,$fecha_ini=null,$fecha_fin=null,$fecha_acum=null,$cobrador_id=0,$vendedor_id=0){

//        $datos=[];
//        $sql=" SELECT * FROM view_contrato_credito WHERE MONTH(fechadoc)='".$mes."' AND YEAR(fechadoc)='".$anio."'  AND (tipocontrato='VENTA' OR tipocontrato='CUENTA')   AND tipoventa='CREDITO' ORDER BY ".$orden;
//         $table=DB::table('view_contrato_credito');
//        if($filtro=='mes'){

//            $table->whereMonth('fechadoc','=',$mes)->whereYear('fechadoc','=',$anio)
//        }
    }

}
