<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class CambioObra extends Model
{
    protected $table='cambioobra';
    protected $fillable=[

        'fecha',
        'estado',
        'numingreso',
        'numegreso',
        'terminado',
        'saldo',
        'credito_id',
        'numcuotas',
        'fechacuotas',
        'dias_pago',
        'obs',
        'user_id',
        'monto',
        'cuentaantigua',
        'tipo_saldo',
        'monto_tipo_saldo'

    ];
    protected  $dates=['fechacuotas','fecha'];

    public function detalle(){
        return $this->hasMany(DetalleCambioObra::class,'cambioobra_id');
    }
    public function detalle_ingresos(){
        return $this->hasMany(DetalleCambioObra::class,'cambioobra_id')
                      ->where('tipo','i')->where('cambio','1');
    }
    public function detalle_egresos(){
        return $this->hasMany(DetalleCambioObra::class,'cambioobra_id')
            ->where('tipo','e')->where('cambio','1');
    }
    public function detalle_contrato(){
        return $this->hasMany(DetalleCambioObra::class,'cambioobra_id')
            ->where('tipo','c')->where('cambio','0');
    }
    public function credito(){
        return $this->hasOne(Credito::class,'id','credito_id');
    }
    public function setFechaAttribute($fecha){
       $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public function setFechacuotasAttribute($fecha){
        $this->attributes['fechacuotas']=Carbon::createFromFormat('d/m/Y',$fecha);
    }


}
